/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.items.wizard;

import ch.dvbern.tax.common.presentation.cd.action.ValidateAction;
import ch.dvbern.tax.common.presentation.cd.items.IValueItem;
import ch.dvbern.tax.common.presentation.cd.items.wizard.AWizardItem;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.util.OsSupport;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.Collection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class WValueItem
extends AWizardItem
implements IValueItem {
    private WizardDisplayInfoDTO.ItemItemDTO item;
    private int style;
    private boolean tableItem;

    public WValueItem(WizardDisplayInfoDTO.ItemItemDTO item, boolean tableItem) {
        this.item = item;
        this.tableItem = tableItem;
        this.style = 0;
        if (item.getReadonly()) {
            this.style = 1;
        } else if (item.getState() == 11) {
            this.style = 2;
        }
    }

    public Object getValue() {
        return this.item.getValue();
    }

    public String getRenderedValue() {
        return WValueItem.render(this.item);
    }

    public int getStyle() {
        return this.style;
    }

    public int getColspan() {
        return this.item.getColspan();
    }

    public int getRowspan() {
        return this.item.getRowspan();
    }

    public String getAlign() {
        return this.item.getAlign();
    }

    public int getMaxLength() {
        return this.item.getMaxlength();
    }

    public String getRegularExpression() {
        if (this.item.getRendererAndInputValidator() != null) {
            return this.item.getRendererAndInputValidator().getUserInputRegExpPattern();
        }
        return null;
    }

    public int calcLength(String input) {
        if (this.item.getRendererAndInputValidator() != null) {
            return this.item.getRendererAndInputValidator().calcLength(input);
        }
        return input == null ? 0 : input.length();
    }

    public boolean isValidateIfLeftEmpty() {
        return this.item.isValidateIfLeftEmpty();
    }

    public int getState() {
        return this.item.getState();
    }

    public OptionItemsDTO getOptionItems() {
        return this.item.getOptionItems();
    }

    public void setDefaultValue(String value) {
        AbstractConverter conv = this.item.getRendererAndInputValidator();
        if (conv != null) {
            try {
                Object convertedValue = conv.getObject(value, this.item.getOptionItems());
                this.item.setValue(convertedValue);
            }
            catch (AbstractConverter.ConvertException e) {
                e.printStackTrace();
            }
        } else {
            this.item.setValue(value);
        }
    }

    public Object getUID() {
        return this.item.getUniqueItemIdentifier();
    }

    public int getType() {
        return this.item.getType();
    }

    public Color getForegroundColor() {
        if (this.item.getForegroundColor() != null) {
            return GuiUtil.getColorRegistry().get(this.item.getForegroundColor());
        }
        switch (this.getStyle()) {
            case 1: {
                if (this.tableItem) {
                    return GuiUtil.getColorRegistry().get(GuiUtil.COLOR_TABLE_CELL_FOREGROUND_READONLY);
                }
                return GuiUtil.getColorRegistry().get(GuiUtil.COLOR_SECTION_INPUT_FOREGROUND_READONLY);
            }
            case 2: {
                if (this.tableItem) {
                    return GuiUtil.getColorRegistry().get(GuiUtil.COLOR_TABLE_CELL_FOREGROUND_TRANSPARENT);
                }
                return GuiUtil.getColorRegistry().get(GuiUtil.COLOR_SECTION_INPUT_FOREGROUND_TRANSPARENT);
            }
        }
        if (this.tableItem) {
            return GuiUtil.getColorRegistry().get(GuiUtil.COLOR_TABLE_CELL_FOREGROUND);
        }
        return GuiUtil.getColorRegistry().get(GuiUtil.COLOR_SECTION_INPUT_FOREGROUND);
    }

    public Color getBackgroundColor() {
        switch (this.getStyle()) {
            case 1: {
                if (this.tableItem) {
                    return GuiUtil.getColorRegistry().get(GuiUtil.COLOR_TABLE_CELL_BACKGROUND_READONLY);
                }
                return GuiUtil.getColorRegistry().get(GuiUtil.COLOR_SECTION_INPUT_BACKGROUND_READONLY);
            }
            case 2: {
                if (this.tableItem) {
                    return GuiUtil.getColorRegistry().get(GuiUtil.COLOR_TABLE_CELL_BACKGROUND_TRANSPARENT);
                }
                return GuiUtil.getColorRegistry().get(GuiUtil.COLOR_SECTION_INPUT_BACKGROUND_TRANSPARENT);
            }
        }
        switch (this.item.getState()) {
            case 4: {
                return RED;
            }
            case 2: {
                return YELLOW;
            }
        }
        if (this.item.getType() == 3 || this.item.getType() == 1) {
            return GuiUtil.getColorRegistry().get(GuiUtil.COLOR_SECTION_LABEL_BACKGROUND);
        }
        return GuiUtil.getColorRegistry().get(GuiUtil.COLOR_SECTION_INPUT_BACKGROUND);
    }

    public Font getFont() {
        switch (this.getStyle()) {
            case 1: {
                if (this.tableItem) {
                    return GuiUtil.getFontRegistry().get("font.normal");
                }
                return GuiUtil.getFontRegistry().get("font.disabled");
            }
            case 2: {
                return GuiUtil.getFontRegistry().get("font.normal");
            }
        }
        return GuiUtil.getFontRegistry().get("font.normal");
    }

    public void update(String newValue) {
        ValidateAction validateAction = new ValidateAction();
        validateAction.execute(newValue, this.item);
    }

    public Object getOptionValue() {
        return null;
    }

    public Collection getMessages() {
        return this.item.getMessages();
    }

    public boolean hasBorder() {
        return !this.tableItem || OsSupport.isLinuxOs() || OsSupport.isMacOs();
    }

    public WizardDisplayInfoDTO.ItemItemDTO getItem() {
        return this.item;
    }

    public String getShortHelpKey() {
        return this.item.getShortHelpKey();
    }

    public boolean isDynamicWidth() {
        return false;
    }
}

