/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.items.expert;

import ch.dvbern.tax.common.presentation.cd.action.ValidateAction;
import ch.dvbern.tax.common.presentation.cd.expertdisplay.ExpertGuiUtil;
import ch.dvbern.tax.common.presentation.cd.items.IValueItem;
import ch.dvbern.tax.common.presentation.cd.items.expert.AExpertItem;
import ch.dvbern.tax.common.presentation.cd.util.OsSupport;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;

public class EValueItem
extends AExpertItem
implements IValueItem {
    private static boolean readOnlyPaddingEnabled = true;
    private ExpertDisplayInfoDTO.ValueItemDTO item;
    private ExpertDisplayInfoDTO.ValuePositionDTO valuePos;
    private Object valuePosValue;
    private int style;
    private int state;
    private boolean validateIfLeftEmpty;

    public static void setReadOnlyPaddingEnabled(boolean readOnlyPaddingEnabled) {
        EValueItem.readOnlyPaddingEnabled = readOnlyPaddingEnabled;
    }

    public EValueItem(ExpertDisplayInfoDTO.ValueItemDTO item, ExpertDisplayInfoDTO.ValuePositionDTO valuePos, Object valuePosValue, float zoom, boolean validateIfLeftEmpty) {
        super(item, zoom);
        this.item = item;
        this.valuePos = valuePos;
        this.valuePosValue = valuePosValue;
        this.validateIfLeftEmpty = validateIfLeftEmpty;
        ModelItemDTO mi = item.getModelItem();
        this.style = 0;
        if (item.isReadonly()) {
            this.style = 3;
        }
        this.state = 3;
        if (mi != null) {
            this.state = mi.getState();
        }
    }

    public Object getValue() {
        return this.item.getModelItem() != null ? this.item.getModelItem().getValue() : null;
    }

    public String getRenderedValue() {
        return EValueItem.render(this.item);
    }

    public int getStyle() {
        return this.style;
    }

    public String getAlign() {
        return this.item.getAlignmentString();
    }

    public int getMaxLength() {
        if (this.item.getRendererAndInputValidator() != null) {
            return this.item.getRendererAndInputValidator().getMaxLength();
        }
        return 100;
    }

    public String getRegularExpression() {
        if (this.item.getRendererAndInputValidator() != null) {
            return this.item.getRendererAndInputValidator().getUserInputRegExpPattern();
        }
        return null;
    }

    public int calcLength(String input) {
        if (this.item.getRendererAndInputValidator() != null) {
            return this.item.getRendererAndInputValidator().calcLength(input);
        }
        return input == null ? 0 : input.length();
    }

    public boolean isValidateIfLeftEmpty() {
        return this.validateIfLeftEmpty;
    }

    public int getState() {
        if (this.item.getModelItem() != null) {
            return this.item.getModelItem().getState();
        }
        return 3;
    }

    public OptionItemsDTO getOptionItems() {
        return this.item.getOptionItems();
    }

    public Object getOptionValue() {
        return this.valuePosValue;
    }

    public void setDefaultValue(String value) {
        if (this.item.getValuePositions() == null || this.item.getValuePositions().isEmpty()) {
            try {
                AbstractConverter conv = this.item.getRendererAndInputValidator();
                Object convertedValue = conv != null ? conv.getObject(value, this.item.getOptionItems()) : value;
                if (this.item.getModelItem() != null) {
                    this.item.setModelItem(this.item.getModelItem().clone(convertedValue));
                } else {
                    this.item.setModelItem(new ModelItemDTO(convertedValue));
                }
            }
            catch (AbstractConverter.ConvertException e) {
                e.printStackTrace();
            }
        }
    }

    public Object getUID() {
        return this.valuePos == null ? this.item.getUniqueItemIdentifier() : this.item.getUniqueItemIdentifier() + "." + this.valuePos.getValue();
    }

    public int getType() {
        if (this.item.getType() == 1) {
            return 3;
        }
        return this.item.getType();
    }

    public Color getForegroundColor() {
        return null;
    }

    public Color getBackgroundColor() {
        if (this.item.isReadonly()) {
            return this.getColor(this.item.getBgColor());
        }
        switch (this.state) {
            case 4: {
                return RED;
            }
            case 2: {
                return YELLOW;
            }
        }
        return this.getColor(this.item.getBgColor());
    }

    public Font getFont() {
        ExpertDisplayInfoDTO.FontDTO fontDTO = this.item.getFont();
        if (fontDTO != null && this.item.isReadonly() && (this.item.getType() == 1 || this.item.getType() == 3)) {
            ExpertDisplayInfoDTO.FontDTO bold;
            fontDTO = bold = new ExpertDisplayInfoDTO.FontDTO(fontDTO.getName(), fontDTO.getSize(), fontDTO.getStyle() | 1, fontDTO.getColor(), fontDTO.getCharSpace());
        }
        return ExpertGuiUtil.getFont(fontDTO, this.getZoom());
    }

    public void update(String newValue) {
        ValidateAction validateAction = new ValidateAction();
        validateAction.execute(newValue, this.item);
    }

    public Rectangle getBounds() {
        int height;
        int x = this.valuePos == null ? this.item.getX(this.getZoom()) : this.item.getX(this.getZoom()) + this.valuePos.getX(this.getZoom());
        int y = this.valuePos == null ? this.item.getY(this.getZoom()) : this.item.getY(this.getZoom()) + this.valuePos.getY(this.getZoom());
        int width = this.valuePos == null ? this.item.getWidth(this.getZoom()) : this.valuePos.getWidth(this.getZoom());
        int n = height = this.valuePos == null ? this.item.getHeight(this.getZoom()) : this.valuePos.getHeight(this.getZoom());
        if (readOnlyPaddingEnabled && this.getStyle() == 3) {
            if (OsSupport.isWindowsOs()) {
                x += 7;
                width -= 14;
                y += 2;
                height -= 3;
            } else if (OsSupport.isLinuxOs()) {
                x += 5;
                width -= 10;
                y += 2;
                height -= 4;
            } else if (OsSupport.isMacOs()) {
                x += 5;
                width -= 10;
                y += 5;
                height -= 8;
            }
        }
        if (OsSupport.isMacOs()) {
            y -= 2;
            height += 5;
            x -= 3;
            width += 6;
        }
        return new Rectangle(x, y, width, height);
    }

    public Collection getMessages() {
        if (this.item.getModelItem() != null) {
            return this.item.getModelItem().getMessages();
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isMoveToForeground() {
        return true;
    }

    public boolean hasBorder() {
        return this.style == 0;
    }

    public ExpertDisplayInfoDTO.ValueItemDTO getItem() {
        return this.item;
    }

    public String getShortHelpKey() {
        return this.item.getShortHelpKey();
    }

    public boolean isDynamicWidth() {
        return this.item.isAutoWidthOnFocus();
    }
}

