/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.items.expert;

import ch.dvbern.tax.common.presentation.cd.action.ValidateAction;
import ch.dvbern.tax.common.presentation.cd.items.IValueItem;
import ch.dvbern.tax.common.presentation.cd.items.expert.ETableCell;
import ch.dvbern.tax.common.presentation.cd.util.OsSupport;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.swt.graphics.Color;

public class EValueCell
extends ETableCell
implements IValueItem {
    private ExpertDisplayInfoDTO.TableDTO.ValueCellDTO cell;
    private ExpertDisplayInfoDTO.TableDTO.ColumnDTO col;
    private int style;
    private int state;

    public EValueCell(ExpertDisplayInfoDTO.TableDTO.ValueCellDTO cell, ExpertDisplayInfoDTO.TableDTO.ColumnDTO col, float zoom, ExpertDisplayInfoDTO.TableDTO.RowDTO row) {
        super(cell, col, zoom, row);
        this.cell = cell;
        this.col = col;
        ModelItemDTO mi = cell.getModelItem();
        this.style = 0;
        if (col.isReadonly()) {
            this.style = 1;
        } else if (mi != null) {
            if (mi.getState() == 11) {
                this.style = 2;
            } else if (mi.getState() == 12) {
                this.style = 1;
            }
        }
        this.state = 3;
        if (mi != null) {
            this.state = mi.getState();
        }
    }

    public Object getValue() {
        ModelItemDTO mi = this.cell.getModelItem();
        if (mi != null) {
            return mi.getValue();
        }
        return null;
    }

    public String getRenderedValue() {
        return EValueCell.render(this.getColumn(), this.cell);
    }

    public int getStyle() {
        return this.style;
    }

    public int getState() {
        if (this.cell.getModelItem() != null) {
            return this.cell.getModelItem().getState();
        }
        return 3;
    }

    public OptionItemsDTO getOptionItems() {
        return this.cell.getOptionItems();
    }

    public void setDefaultValue(String value) {
        try {
            AbstractConverter conv = this.col.getRendererAndInputValidator();
            Object convertedValue = conv != null ? conv.getObject(value, this.cell.getOptionItems()) : value;
            if (this.cell.getModelItem() != null) {
                this.cell.setModelItem(this.cell.getModelItem().clone(convertedValue));
            } else {
                this.cell.setModelItem(new ModelItemDTO(convertedValue));
            }
        }
        catch (AbstractConverter.ConvertException e) {
            e.printStackTrace();
        }
    }

    public Color getBackgroundColor() {
        switch (this.getStyle()) {
            case 1: {
                return this.getColor(this.getColumn().getBackground());
            }
            case 2: {
                return this.getColor(this.getColumn().getBackground());
            }
        }
        switch (this.state) {
            case 4: {
                return RED;
            }
            case 2: {
                return YELLOW;
            }
        }
        return this.getColor(this.getColumn().getBackground());
    }

    public void update(String newValue) {
        ValidateAction validateAction = new ValidateAction();
        validateAction.execute(newValue, this.cell, this.getRow(), this.getColumn());
    }

    public Color getForegroundColor() {
        return BLACK;
    }

    public Collection getMessages() {
        if (this.cell.getModelItem() != null) {
            return this.cell.getModelItem().getMessages();
        }
        return Collections.EMPTY_LIST;
    }

    public boolean hasBorder() {
        return OsSupport.isLinuxOs() || OsSupport.isMacOs();
    }

    public String getShortHelpKey() {
        return this.getColumn().getShortHelpKey();
    }

    public boolean isDynamicWidth() {
        return true;
    }
}

