/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.items.expert;

import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.items.ITableItem;
import ch.dvbern.tax.common.presentation.cd.items.ITableRow;
import ch.dvbern.tax.common.presentation.cd.items.expert.AExpertItem;
import ch.dvbern.tax.common.presentation.cd.items.expert.ETableColumn;
import ch.dvbern.tax.common.presentation.cd.items.expert.ETableRow;
import ch.dvbern.tax.common.presentation.cd.util.OsSupport;
import ch.dvbern.tax.common.presentation.common.util.TableSortHelper;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Rectangle;

public class ETableItem
extends AExpertItem
implements ITableItem {
    private ExpertDisplayInfoDTO.TableDTO table;
    private List coldefs;
    private List rows;
    private ETableRow emptyRow;
    private List allCols;

    public ETableItem(ExpertDisplayInfoDTO.TableDTO table, float zoom) {
        super(table, zoom);
        this.table = table;
        List<ExpertDisplayInfoDTO.TableDTO.ColumnDTO> inputCols = table.getInputColumns();
        this.allCols = table.getAllColumns();
        if (table.isEnhanced()) {
            ExpertDisplayInfoDTO.TableDTO.ColumnDTO dummy = new ExpertDisplayInfoDTO.TableDTO.ColumnDTO("", 0, table.getWidth(), 0, table.isReadonly(), table.getTitleFont(), table.getBgColor(), null, null, false, null, 0, true, null, false, false, table.getUniqueItemIdentifier() + ".dummycolumn", null, table.getTitleFont());
            this.allCols = inputCols = Collections.singletonList(dummy);
        }
        this.coldefs = new ArrayList();
        Iterator it = inputCols.iterator();
        while (it.hasNext()) {
            ExpertDisplayInfoDTO.TableDTO.ColumnDTO element = (ExpertDisplayInfoDTO.TableDTO.ColumnDTO)it.next();
            this.coldefs.add(new ETableColumn(element, zoom));
        }
        this.initRows();
    }

    private void initRows() {
        this.rows = new ArrayList();
        if (this.table.getInputRows() != null) {
            Iterator it = this.table.getInputRows().iterator();
            while (it.hasNext()) {
                ExpertDisplayInfoDTO.TableDTO.RowDTO element = (ExpertDisplayInfoDTO.TableDTO.RowDTO)it.next();
                if (element.isEmptyRow()) {
                    this.emptyRow = new ETableRow(element, this.allCols, this.getZoom(), this);
                    continue;
                }
                this.rows.add(new ETableRow(element, this.allCols, this.getZoom(), this));
            }
        }
    }

    public String getTitleKey() {
        return null;
    }

    public String getAlign() {
        return "left";
    }

    public boolean isEditable() {
        return this.table.isEditable();
    }

    public Object getUID() {
        return this.table.getUniqueItemIdentifier();
    }

    public List getColdefs() {
        return this.coldefs;
    }

    public List getRows() {
        return this.rows;
    }

    public ITableRow getEmptyRow() {
        return this.emptyRow;
    }

    public Rectangle getBounds() {
        Rectangle bounds = super.getBounds();
        bounds.x -= 22;
        bounds.width += 44;
        return bounds;
    }

    public boolean isFirstColumnStatus() {
        return false;
    }

    public int getRowHeigth() {
        if (this.table.isEnhanced()) {
            return Math.round(this.table.getRowHeight() * this.getZoom());
        }
        if (OsSupport.isMaxOsPpc()) {
            return 23;
        }
        if (OsSupport.isMaxOsIntel()) {
            return 24;
        }
        return 0;
    }

    public boolean isVariableHeight() {
        return false;
    }

    public boolean isHeaderVisible() {
        if (this.table.isEnhanced()) {
            return false;
        }
        return this.table.isHeaderVisible();
    }

    public boolean isMoveToForeground() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    public ExpertDisplayInfoDTO.TableDTO getItem() {
        return this.table;
    }

    public boolean isEnhanced() {
        return this.table.isEnhanced();
    }

    public String getTableDmk() {
        return this.table.getDataModelKey();
    }

    public void applySorts(Map tableSorts) {
        LocalizationHelper locHelper = TaxmeController.getInstance().getLocalisationHelper();
        TableSortHelper.sortTable(this.table, locHelper, tableSorts);
        this.initRows();
    }

    public boolean isReadOnly() {
        return this.table.isReadonly();
    }

    public List getLabelAddOns() {
        return null;
    }
}

