/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.items.expert;

import ch.dvbern.tax.common.presentation.cd.expertdisplay.ExpertGuiUtil;
import ch.dvbern.tax.common.presentation.cd.items.expert.AExpertItem;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public abstract class ETableCell
extends AExpertItem {
    private ExpertDisplayInfoDTO.TableDTO.ColumnDTO col;
    private ExpertDisplayInfoDTO.TableDTO.RowDTO row;
    private ExpertDisplayInfoDTO.TableDTO.CellDTO cell;

    public ETableCell(ExpertDisplayInfoDTO.TableDTO.CellDTO cell, ExpertDisplayInfoDTO.TableDTO.ColumnDTO col, float zoom, ExpertDisplayInfoDTO.TableDTO.RowDTO row) {
        super(cell, zoom);
        this.cell = cell;
        this.col = col;
        this.row = row;
    }

    public String getAlign() {
        return this.col.getAlignmentString();
    }

    public int getMaxLength() {
        if (this.col.getRendererAndInputValidator() != null) {
            return this.col.getRendererAndInputValidator().getMaxLength();
        }
        return 100;
    }

    public int calcLength(String input) {
        if (this.col.getRendererAndInputValidator() != null) {
            return this.col.getRendererAndInputValidator().calcLength(input);
        }
        return input == null ? 0 : input.length();
    }

    public String getRegularExpression() {
        if (this.col.getRendererAndInputValidator() != null) {
            return this.col.getRendererAndInputValidator().getUserInputRegExpPattern();
        }
        return null;
    }

    public boolean isValidateIfLeftEmpty() {
        return !this.row.isEmptyRow();
    }

    public Object getOptionValue() {
        return null;
    }

    public int getType() {
        return this.col.getType();
    }

    public Font getFont() {
        return ExpertGuiUtil.getFont(this.cell.getFont(), this.getZoom());
    }

    public Color getBackgroundColor() {
        return this.getColor(this.getColumn().getBackground());
    }

    public Color getForegroundColor() {
        return BLACK;
    }

    protected ExpertDisplayInfoDTO.TableDTO.ColumnDTO getColumn() {
        return this.col;
    }

    protected ExpertDisplayInfoDTO.TableDTO.RowDTO getRow() {
        return this.row;
    }

    public boolean isMoveToForeground() {
        return false;
    }

    protected Color getColor(ExpertDisplayInfoDTO.ColorDTO color) {
        if (color == null) {
            return WHITE;
        }
        return super.getColor(color);
    }
}

