/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.items.expert;

import ch.dvbern.tax.common.presentation.cd.expertdisplay.ExpertGuiUtil;
import ch.dvbern.tax.common.presentation.cd.items.IItem;
import ch.dvbern.tax.common.presentation.cd.items.common.AItem;
import ch.dvbern.tax.common.presentation.cd.util.OutputRenderer;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;

public abstract class AExpertItem
extends AItem
implements IItem {
    private static final OutputRenderer renderer = new OutputRenderer();
    private ExpertDisplayInfoDTO.ItemDTO item;
    private ExpertDisplayInfoDTO.TableDTO.CellDTO cell;
    private float zoom;

    protected AExpertItem(ExpertDisplayInfoDTO.ItemDTO item, float zoom) {
        this.item = item;
        this.zoom = zoom;
    }

    protected AExpertItem(ExpertDisplayInfoDTO.TableDTO.CellDTO cell, float zoom) {
        this.cell = cell;
        this.zoom = zoom;
    }

    public int getRowspan() {
        return 0;
    }

    public int getColspan() {
        return 0;
    }

    public Color getBackgroundColor() {
        if (this.item != null) {
            return this.getColor(this.item.getBgColor());
        }
        return null;
    }

    public Color getForegroundColor() {
        return null;
    }

    public Object getUID() {
        if (this.item != null) {
            return this.item.getUniqueItemIdentifier();
        }
        return this.cell.getUniqueItemIdentifier();
    }

    public Rectangle getBounds() {
        if (this.item == null) {
            return null;
        }
        int x = this.item.getX(this.zoom);
        int y = this.item.getY(this.zoom);
        int width = this.item.getWidth(this.zoom);
        int heigth = this.item.getHeight(this.zoom);
        return new Rectangle(x, y, width, heigth);
    }

    protected Color getColor(ExpertDisplayInfoDTO.ColorDTO color) {
        if (color == null) {
            return null;
        }
        return ExpertGuiUtil.getColor(color);
    }

    protected static String render(ExpertDisplayInfoDTO.ValueItemDTO item) {
        return renderer.render(item);
    }

    protected static String render(ExpertDisplayInfoDTO.TableDTO.ColumnDTO col, ExpertDisplayInfoDTO.TableDTO.ValueCellDTO cell) {
        return renderer.render(col, cell);
    }

    protected float getZoom() {
        return this.zoom;
    }
}

