/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.help.gui.model;

import ch.dvbern.tax.common.presentation.cd.help.model.HelpItem;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;

public class HelpTreeLabelProvider
implements ILabelProvider {
    private static final int EXPANDED = 1;
    private static final int COLLAPSED = 2;
    private Image help = null;
    private Image helpOpened = null;
    private Image helpClosed = null;
    private List listeners;
    private List expandeds;
    private List collapseds;

    public HelpTreeLabelProvider() {
        try {
            this.listeners = new ArrayList();
            this.expandeds = new ArrayList();
            this.collapseds = new ArrayList();
            this.help = GuiUtil.getImageRegistry().get("icon.help.tree.leaf");
            this.helpClosed = GuiUtil.getImageRegistry().get("icon.help.tree.closed");
            this.helpOpened = GuiUtil.getImageRegistry().get("icon.help.tree.opened");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public Image getImage(Object element) {
        HelpItem item = (HelpItem)element;
        if (item.getItems().size() > 0) {
            int i;
            for (i = 0; i < this.expandeds.size(); ++i) {
                if (item != this.expandeds.get(i)) continue;
                return this.helpOpened;
            }
            for (i = 0; i < this.collapseds.size(); ++i) {
                if (item != this.collapseds.get(i)) continue;
                return this.helpClosed;
            }
            return this.helpClosed;
        }
        return this.help;
    }

    public String getText(Object element) {
        return ((HelpItem)element).getName();
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public void changeSomeState(Object element, int type) {
        int i;
        if (type == 1) {
            this.expandeds.add(element);
            for (i = 0; i < this.collapseds.size(); ++i) {
                if ((HelpItem)element != this.collapseds.get(i)) continue;
                this.collapseds.remove(element);
            }
        } else if (type == 2) {
            this.collapseds.add(element);
            for (i = 0; i < this.expandeds.size(); ++i) {
                if ((HelpItem)element != this.expandeds.get(i)) continue;
                this.expandeds.remove(element);
            }
        }
        LabelProviderChangedEvent labelProviderChangedEvent = new LabelProviderChangedEvent((IBaseLabelProvider)this);
        for (int i2 = 0; i2 < this.listeners.size(); ++i2) {
            ILabelProviderListener listener = (ILabelProviderListener)this.listeners.get(i2);
            listener.labelProviderChanged(labelProviderChangedEvent);
        }
    }
}

