/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.help.gui;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.menu.HelpAboutAction;
import ch.dvbern.tax.common.presentation.cd.help.action.BackAction;
import ch.dvbern.tax.common.presentation.cd.help.action.ExitAction;
import ch.dvbern.tax.common.presentation.cd.help.action.ForwardAction;
import ch.dvbern.tax.common.presentation.cd.help.action.HelpIndexAction;
import ch.dvbern.tax.common.presentation.cd.help.action.HelpTaxmeAction;
import ch.dvbern.tax.common.presentation.cd.help.action.HelpWegleitungAction;
import ch.dvbern.tax.common.presentation.cd.help.gui.model.HelpTreeContentProvider;
import ch.dvbern.tax.common.presentation.cd.help.gui.model.HelpTreeLabelProvider;
import ch.dvbern.tax.common.presentation.cd.help.gui.model.HelpTreeViewer;
import ch.dvbern.tax.common.presentation.cd.help.model.HelpItem;
import ch.dvbern.tax.common.presentation.cd.help.model.HelpModel;
import ch.dvbern.tax.common.presentation.cd.help.model.HelpRoot;
import ch.dvbern.tax.common.presentation.cd.help.parser.HelpContentHandler;
import ch.dvbern.tax.common.presentation.cd.resourcetools.IToolCommunicationGui;
import ch.dvbern.tax.common.presentation.cd.resourcetools.action.ToolEditOnMainHelpAction;
import ch.dvbern.tax.common.presentation.cd.resourcetools.action.ToolHelpIndexAction;
import ch.dvbern.tax.common.presentation.cd.resourcetools.action.ToolHelpTreeStructureAction;
import ch.dvbern.tax.common.presentation.cd.resourcetools.action.ToolHtmlEditorSetAction;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class HelpApplication
extends ApplicationWindow
implements SelectionListener,
ISelectionChangedListener,
IToolCommunicationGui {
    private ExitAction exitAction;
    private HelpAboutAction helpAction;
    private BackAction backAction = new BackAction(this);
    private ForwardAction forwardAction = new ForwardAction(this);
    private HelpIndexAction helpIndexAction;
    private HelpTaxmeAction helpTaxmeAction;
    private HelpWegleitungAction helpWegleitungAction;
    private ToolHelpIndexAction toolHelpIndexAction;
    private ToolHelpTreeStructureAction toolHelpTreeStructureAction;
    private ToolEditOnMainHelpAction toolEditOnMainHelpAction;
    private ToolHtmlEditorSetAction toolHtmlEditorSetAction;
    private HelpModel helpModel;
    private Browser browser;
    private TabFolder tabFolder;
    private HelpTreeViewer viewer;
    private ArrayList viewers;
    private boolean helpIndexEnable;
    private Object[] selections = new Object[]{"", "", "", "", "", "", "", "", ""};

    public String toolGetCurrentShortHelpFileNameOnField(String sKey) {
        return null;
    }

    public HelpApplication(Shell shell) {
        super(shell);
        String indexEnable = TaxmeConfig.getString("HelpIndexEnabled");
        this.helpIndexEnable = indexEnable == null || !indexEnable.equals("false");
        this.helpModel = HelpContentHandler.getHelpModel();
        this.exitAction = new ExitAction(this);
        this.helpAction = new HelpAboutAction();
        this.helpIndexAction = new HelpIndexAction(this);
        this.helpTaxmeAction = new HelpTaxmeAction(this);
        this.helpWegleitungAction = new HelpWegleitungAction(this);
        this.viewers = new ArrayList();
        this.addMenuBar();
        this.addCoolBar(0);
        this.addStatusLine();
    }

    protected Control createContents(Composite parent) {
        this.getShell().setText(Messages.getString("taxme.cd.help.title"));
        this.getShell().setSize(800, 600);
        int size = this.helpModel.getRoots().size();
        if (!this.helpIndexEnable) {
            --size;
        }
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new FormLayout());
        Sash sash = new Sash(main, 512);
        sash.addSelectionListener((SelectionListener)this);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(30, 0);
        sash.setLayoutData((Object)data);
        Composite navigationPart = new Composite(main, 2048);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)sash, 0);
        navigationPart.setLayoutData((Object)data);
        Composite viewPart = new Composite(main, 2048);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment((Control)sash, 0);
        data.right = new FormAttachment(100, 0);
        viewPart.setLayoutData((Object)data);
        viewPart.setLayout((Layout)new FillLayout());
        this.tabFolder = new TabFolder(navigationPart, 128);
        navigationPart.setLayout((Layout)new FillLayout());
        this.browser = new Browser(viewPart, 0);
        this.browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changed(LocationEvent arg0) {
                HelpApplication.this.backAction.setEnabled(HelpApplication.this.browser.isBackEnabled());
                HelpApplication.this.forwardAction.setEnabled(HelpApplication.this.browser.isForwardEnabled());
            }
        });
        for (int i = 0; i < size; ++i) {
            HelpRoot root = (HelpRoot)this.helpModel.getRoots().get(i);
            TabItem item = new TabItem(this.tabFolder, 0);
            item.setText(root.getName());
            Composite composite = new Composite((Composite)this.tabFolder, 2048);
            composite.setLayout((Layout)new FillLayout());
            item.setControl((Control)composite);
            this.createViewer((Composite)item.getControl(), root);
        }
        parent.layout();
        return main;
    }

    public void widgetSelected(SelectionEvent e) {
        Sash sash = (Sash)e.getSource();
        ((FormData)sash.getLayoutData()).left = new FormAttachment(0, e.x);
        sash.getParent().layout();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected MenuManager createMenuManager() {
        String sToolsEnabled;
        MenuManager menuBar = new MenuManager("");
        MenuManager menuFile = new MenuManager(Messages.getString("menu.file"), "menu.file");
        MenuManager menuHelp = new MenuManager(Messages.getString("menu.help"), "menu.help");
        MenuManager menuNavigate = new MenuManager(Messages.getString("menu.navigate"), "menu.navigate");
        MenuManager menuTools = null;
        menuBar.add((IContributionItem)menuFile);
        menuBar.add((IContributionItem)menuNavigate);
        menuBar.add((IContributionItem)menuHelp);
        menuFile.add((IAction)this.exitAction);
        menuFile.add((IContributionItem)new Separator());
        menuHelp.add((IAction)this.helpAction);
        menuNavigate.add((IAction)this.backAction);
        menuNavigate.add((IAction)this.forwardAction);
        menuNavigate.add((IContributionItem)new Separator());
        menuNavigate.add((IAction)this.helpWegleitungAction);
        menuNavigate.add((IAction)this.helpTaxmeAction);
        if (this.helpIndexEnable) {
            menuNavigate.add((IAction)this.helpIndexAction);
        }
        if ((sToolsEnabled = TaxmeConfig.getString("ToolsEnabled")) != null && sToolsEnabled.equals("true")) {
            menuTools = new MenuManager(Messages.getString("menu.tools"), "menu.tools");
            menuBar.add((IContributionItem)menuTools);
            this.toolHelpIndexAction = new ToolHelpIndexAction(this);
            menuTools.add((IAction)this.toolHelpIndexAction);
            this.toolHelpTreeStructureAction = new ToolHelpTreeStructureAction(this);
            menuTools.add((IAction)this.toolHelpTreeStructureAction);
            this.toolEditOnMainHelpAction = new ToolEditOnMainHelpAction(this);
            menuTools.add((IAction)this.toolEditOnMainHelpAction);
            this.toolHtmlEditorSetAction = new ToolHtmlEditorSetAction(this);
            menuTools.add((IAction)this.toolHtmlEditorSetAction);
        }
        return menuBar;
    }

    protected CoolBarManager createCoolBarManager(int style) {
        CoolBarManager coolBarManager = new CoolBarManager(style);
        ToolBarManager tbm = new ToolBarManager(0x800040);
        tbm.add((IAction)this.backAction);
        tbm.add((IAction)this.forwardAction);
        this.backAction.setEnabled(false);
        this.forwardAction.setEnabled(false);
        coolBarManager.add((IToolBarManager)tbm);
        return coolBarManager;
    }

    protected StatusLineManager createStatusLineManager() {
        StatusLineManager slm = new StatusLineManager();
        return slm;
    }

    private void createViewer(Composite itemComposite, HelpRoot root) {
        this.viewer = new HelpTreeViewer(itemComposite, 770);
        this.viewers.add(this.viewer);
        HelpTreeContentProvider contentProvider = new HelpTreeContentProvider();
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        HelpTreeLabelProvider labelProvider = new HelpTreeLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setInput(root);
        this.viewer.addSelectionChangedListener(this);
    }

    public HelpTreeViewer getViewer() {
        return this.viewer;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.viewer = (HelpTreeViewer)((Object)event.getSource());
        if (this.viewer.getSelection() instanceof StructuredSelection) {
            StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
            if (this.selections[4].equals("")) {
                this.selections[4] = selection;
            } else {
                this.selections[5] = selection;
                System.arraycopy(this.selections, 1, this.selections, 0, this.selections.length - 1);
            }
            if (!selection.isEmpty()) {
                HelpItem itemSelected = (HelpItem)selection.getFirstElement();
                this.displayHTML(itemSelected);
            }
            this.getShell().forceFocus();
        }
    }

    public Object[] getSelections() {
        return this.selections;
    }

    public void showCurrent() {
        this.displayHTML();
    }

    private void displayHTML() {
        String fileName = TaxmeController.getInstance().getApp().toolGetCurrentMainHelpFileName();
        if (fileName == null || fileName.equals("")) {
            fileName = "0001.htm";
        }
        String mainHelpDir = this.toolGetCurrentMainHelpDirectory() + this.toolGetCurrentLanguage();
        try {
            URL url = new URL("file:" + mainHelpDir + File.separator + fileName);
            File file = new File(url.getFile());
            if (file.exists() && !file.isDirectory()) {
                String newUrl = url.toExternalForm();
                if (!newUrl.equals(this.browser.getUrl())) {
                    this.browser.setUrl(newUrl);
                }
            } else {
                this.browser.setText("");
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    private void displayHTML(HelpItem item) {
        String mainHelpDir = this.toolGetCurrentMainHelpDirectory() + this.toolGetCurrentLanguage();
        try {
            URL url = new URL("file:" + mainHelpDir + File.separator + item.getTopic());
            File file = new File(url.getFile());
            if (file.exists() && !file.isDirectory()) {
                this.browser.setUrl(url.toExternalForm());
            } else {
                this.browser.setUrl("about:blank");
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public TabFolder getTabFolder() {
        return this.tabFolder;
    }

    public Map toolGetAllNlsErrorMessages() {
        return null;
    }

    public List toolGetAvailableLanguages() {
        return null;
    }

    public String toolGetCurrentFullHTMLFileName() {
        if (this.viewer.getSelection() instanceof StructuredSelection) {
            StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
            HelpItem itemSelected = (HelpItem)selection.getFirstElement();
            String mainHelpDir = this.toolGetCurrentMainHelpDirectory();
            return new File(mainHelpDir + File.separator + itemSelected.getTopic()).getAbsolutePath();
        }
        return null;
    }

    public String toolGetCurrentLanguage() {
        return TaxmeController.getInstance().getLanguage();
    }

    public String toolGetCurrentMainHelpDirectory() {
        return TaxmeConfig.getMainhelpDir();
    }

    public String toolGetCurrentMainHelpFileName() {
        String s = this.browser.getUrl();
        try {
            URL file = new URL(s);
            String fileName = new File(file.getFile()).getName();
            return fileName;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String toolGetCurrentMainHelpName() {
        return null;
    }

    public List toolGetCurrentScreenErrorIds() {
        return null;
    }

    public String toolGetCurrentScreenName() {
        return null;
    }

    public String toolGetCurrentShortHelpDirectory() {
        return null;
    }

    public String toolGetCurrentShortHelpFileName() {
        return null;
    }

    public String toolGetFullHtmlEditorName() {
        return TaxmeConfig.getString("ToolHtmlEditorName");
    }

    public List toolGetGuiModelAsVector(String sFileName) {
        return null;
    }

    public Hashtable toolGetGuiModelConfigEntries() {
        return null;
    }

    public HelpRoot toolGetMainHelpIndexModel() {
        return (HelpRoot)this.helpModel.getRoots().get(2);
    }

    public HelpRoot toolGetMainHelpModel() {
        if (this.tabFolder.getSelectionIndex() == 0) {
            return (HelpRoot)this.helpModel.getRoots().get(0);
        }
        if (this.tabFolder.getSelectionIndex() == 1) {
            return (HelpRoot)this.helpModel.getRoots().get(1);
        }
        return (HelpRoot)this.helpModel.getRoots().get(2);
    }

    public List toolGetNavigationFromFile() {
        return null;
    }

    public Hashtable toolGetNavigationNls() {
        return null;
    }

    public boolean toolIsErrorsWarningsEnabled() {
        return false;
    }

    public boolean toolIsGuiModelsEnabled() {
        return false;
    }

    public boolean toolIsHelpIndexEnabled() {
        return true;
    }

    public boolean toolIsHelpMappingEnabled() {
        return false;
    }

    public boolean toolIsHelpTreestructureEnabled() {
        return true;
    }

    public boolean toolIsHtmlEditOnMainHelpEnabled() {
        String sMainHelpEnabled = TaxmeConfig.getString("ToolEditMainHelpEnabled");
        return sMainHelpEnabled != null && sMainHelpEnabled.equals("true");
    }

    public boolean toolIsHtmlEditOnMainPanelHelpEnabled() {
        return false;
    }

    public boolean toolIsHtmlEditOnShortHelpEnabled() {
        return false;
    }

    public boolean toolIsMainNavigationEnabled() {
        return false;
    }

    public void toolRefreshCurrentHTML() {
        this.browser.refresh();
    }

    public void toolRefreshErrorsWarnings() {
    }

    public void toolRefreshGuiModels() {
    }

    public void toolRefreshHelpMappings() {
    }

    public void toolRefreshNavigation() {
    }

    public void toolRefreshTreeSructures() {
        for (int i = 0; i < this.viewers.size(); ++i) {
            StructuredSelection selection;
            ((HelpTreeViewer)((Object)this.viewers.get(i))).refresh();
            if (!(((HelpTreeViewer)((Object)this.viewers.get(i))).getSelection() instanceof StructuredSelection) || (selection = (StructuredSelection)((HelpTreeViewer)((Object)this.viewers.get(i))).getSelection()).isEmpty()) continue;
            HelpItem itemSelected = (HelpItem)selection.getFirstElement();
            this.displayHTML(itemSelected);
        }
        this.getShell().forceFocus();
    }

    public void toolSaveAllNlsErrorMessages(Map allNlsErrorMessages) {
    }

    public void toolSaveGuiModelFromVector(List vGuiModel, String sFileName) {
    }

    public void toolSaveHelpMapping(String mainHelp, String shortHelp) {
    }

    public void toolSaveHtmlEditorName(String sFile) {
        TaxmeConfig.setValue("ToolHtmlEditorName", sFile);
    }

    public void toolSaveMainHelpIndexTree(HelpItem root) {
    }

    public void toolSaveMainHelpTrees(HelpItem root) {
    }

    public void toolSaveNavigationNls(Hashtable navigationNls) {
    }

    public Shell getCallBackShell() {
        return this.getShell();
    }

    public void back() {
        this.browser.back();
    }

    public void forward() {
        this.browser.forward();
    }
}

