/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.expertdisplay;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.common.util.StringUtil;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ExpertMultiFormIndexPart
extends ch.dvbern.tax.common.presentation.cd.widgets.Composite {
    private static final Image IMG_DELETE = GuiUtil.getImageRegistry().get("icon.button.delete");
    private static final Image IMG_ADD = GuiUtil.getImageRegistry().get("icon.button.add");
    private static final Image IMG_OK = GuiUtil.getImageRegistry().get("icon.state.ok");
    private static final Image IMG_WARNING = GuiUtil.getImageRegistry().get("icon.state.warning");
    private static final Image IMG_MISSING = GuiUtil.getImageRegistry().get("icon.state.missingvalue");
    private static final Image IMG_ERROR = GuiUtil.getImageRegistry().get("icon.state.error");
    private static final Color COL_OK = GuiUtil.getColorRegistry().get(GuiUtil.COLOR_GREEN);
    private static final Color COL_WARNING = GuiUtil.getColorRegistry().get(GuiUtil.COLOR_YELLOW);
    private static final Color COL_MISSING = GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE);
    private static final Color COL_TRANSP = GuiUtil.getColorRegistry().get(GuiUtil.COLOR_GREY);
    private static final Color COL_ERROR = GuiUtil.getColorRegistry().get(GuiUtil.COLOR_RED);
    private static final Color COL_WHITE = GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE);
    private static final Color COL_GREY_LIGHT = GuiUtil.getColorRegistry().get(GuiUtil.COLOR_GREY_LIGHT);
    private final ImageRegistry imageRegistry = new ImageRegistry();

    public ExpertMultiFormIndexPart(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(4, false));
        this.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
    }

    public void setContent(ExpertDisplayInfoDTO expertInfoDTO) {
        ExpertDisplayInfoDTO.NavigationDTO newEntry = null;
        Iterator iter = expertInfoDTO.getNavigationItems().iterator();
        while (iter.hasNext()) {
            ExpertDisplayInfoDTO.NavigationDTO element = (ExpertDisplayInfoDTO.NavigationDTO)iter.next();
            if (!element.isSelected()) continue;
            this.createRows(element.getSubItems());
            newEntry = element.getNewEntryItem();
        }
        if (newEntry != null) {
            this.addNewEntry(newEntry);
        }
        this.layout();
    }

    private void createHeaderLine() {
        Label header = this.createHeaderLabel();
        header.setText(Messages.getString("label.multiform.header.delete", (Control)header));
        header = this.createHeaderLabel();
        header.setText(Messages.getString("label.multiform.header.state", (Control)header));
        header = this.createHeaderLabel();
        header.setText(Messages.getString("label.multiform.header.desc", (Control)header));
        header = this.createHeaderLabel();
        header.setText(Messages.getString("label.multiform.header.forms", (Control)header));
    }

    private Label createHeaderLabel() {
        Label label = new Label((Composite)this, 0);
        GridData gd = new GridData(768);
        label.setLayoutData((Object)gd);
        label.setBackground(COL_GREY_LIGHT);
        label.setFont(GuiUtil.getFontRegistry().get("font.header.table"));
        return label;
    }

    private void addNewEntry(ExpertDisplayInfoDTO.NavigationDTO newEntry) {
        ch.dvbern.tax.common.presentation.cd.widgets.Composite c = new ch.dvbern.tax.common.presentation.cd.widgets.Composite(this, 0);
        c.setBackground(COL_WHITE);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 4;
        c.setLayoutData(gd);
        c.setLayout((Layout)new GridLayout(2, false));
        Label b = new Label((Composite)c, 0);
        b.setImage(IMG_ADD);
        final String fak = newEntry.getAccessKey();
        b.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent ev) {
                TaxmeController.getInstance().setFormAccessKey(fak);
            }
        });
        if (newEntry.getDescriptionKey() != null) {
            Label desc = new Label((Composite)c, 0);
            String msg = ExpertDisplayInfoDTO.getLabelText(newEntry.getDescriptionKey(), newEntry.getDesciptionAddOns(), TaxmeController.getInstance().getLocalisationHelper());
            msg = StringUtil.htmlToText(msg);
            desc.setText(msg);
            desc.setBackground(COL_WHITE);
            desc.setFont(GuiUtil.getFontRegistry().get("font.normal"));
        }
    }

    private void createRows(List forms) {
        boolean rowFound = false;
        if (forms != null) {
            Iterator it = forms.iterator();
            while (it.hasNext()) {
                ExpertDisplayInfoDTO.NavigationDTO subItem = (ExpertDisplayInfoDTO.NavigationDTO)it.next();
                if (!subItem.isEditable() && !subItem.isDeleteable()) continue;
                rowFound = true;
            }
            if (rowFound) {
                this.createHeaderLine();
            }
            it = forms.iterator();
            while (it.hasNext()) {
                ExpertDisplayInfoDTO.NavigationDTO element = (ExpertDisplayInfoDTO.NavigationDTO)it.next();
                if (!element.isEditable() && !element.isDeleteable()) continue;
                this.createRow(element);
            }
        }
        Label l = new Label((Composite)this, 0);
        l.setFont(GuiUtil.getFontRegistry().get("font.normal"));
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 4;
        l.setLayoutData((Object)gd);
        l.setBackground(COL_WHITE);
        if (rowFound) {
            l.setText(Messages.getString("label.expert.erklaerung.bearbeiten", (Control)l));
        } else {
            l.setText(Messages.getString("label.kein.eintrag", (Control)l));
        }
    }

    private void createRow(final ExpertDisplayInfoDTO.NavigationDTO element) {
        GridData gd;
        ch.dvbern.tax.common.presentation.cd.widgets.Composite c = new ch.dvbern.tax.common.presentation.cd.widgets.Composite(this, 0);
        c.setLayoutData(new GridData(1808));
        c.setLayout((Layout)new GridLayout(1, false));
        c.setBackground(COL_GREY_LIGHT);
        if (element.isDeleteable()) {
            Label b = new Label((Composite)c, 0);
            gd = new GridData(1808);
            gd.horizontalAlignment = 0x1000000;
            gd.verticalAlignment = 0x1000000;
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = true;
            b.setLayoutData((Object)gd);
            b.setImage(IMG_DELETE);
            b.setToolTipText(Messages.getString("label.button.delete", (Control)b));
            b.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent ev) {
                    if (DialogUtil.showYesNoDialog(Messages.getString("message.askTableRowDelete"))) {
                        TaxmeController.getInstance().getTmoSession().delete(element.getTableEntryDMK());
                        TaxmeController.getInstance().update();
                    }
                }
            });
        }
        c = new ch.dvbern.tax.common.presentation.cd.widgets.Composite(this, 0);
        c.setLayoutData(new GridData(1808));
        c.setLayout((Layout)new GridLayout(1, false));
        c.setBackground(COL_GREY_LIGHT);
        Label state = new Label((Composite)c, 0);
        gd = new GridData(1808);
        gd.horizontalAlignment = 2;
        gd.verticalAlignment = 2;
        state.setLayoutData((Object)gd);
        state.setBackground(COL_GREY_LIGHT);
        switch (element.getState()) {
            case 4: {
                state.setImage(IMG_ERROR);
                break;
            }
            case 2: {
                state.setImage(IMG_WARNING);
                break;
            }
            case 3: {
                state.setImage(IMG_MISSING);
                break;
            }
            default: {
                state.setImage(IMG_OK);
            }
        }
        ch.dvbern.tax.common.presentation.cd.widgets.Composite desc = new ch.dvbern.tax.common.presentation.cd.widgets.Composite(this, 0);
        desc.setLayout((Layout)new GridLayout(1, false));
        desc.setLayoutData(new GridData(1808));
        desc.setBackground(COL_GREY_LIGHT);
        Label name = new Label((Composite)desc, 0);
        name.setBackground(COL_GREY_LIGHT);
        name.setFont(GuiUtil.getFontRegistry().get("font.normal"));
        if (element.getDescriptionKey() != null) {
            String msg = ExpertDisplayInfoDTO.getLabelText(element.getDescriptionKey(), element.getDesciptionAddOns(), TaxmeController.getInstance().getLocalisationHelper());
            msg = StringUtil.htmlToText(msg);
            name.setText(msg);
        }
        ch.dvbern.tax.common.presentation.cd.widgets.Composite forms = new ch.dvbern.tax.common.presentation.cd.widgets.Composite(this, 0);
        gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        forms.setLayoutData(gd);
        forms.setBackground(COL_GREY_LIGHT);
        GridLayout fl = new GridLayout(element.getSubItemsCount(), false);
        forms.setLayout((Layout)fl);
        if (element.getSubItems() == null || element.getSubItems().isEmpty()) {
            this.addForm(forms, element);
        } else {
            Iterator it = element.getSubItems().iterator();
            while (it.hasNext()) {
                ExpertDisplayInfoDTO.NavigationDTO form = (ExpertDisplayInfoDTO.NavigationDTO)it.next();
                this.addForm(forms, form);
            }
        }
    }

    private void addForm(ch.dvbern.tax.common.presentation.cd.widgets.Composite forms, final ExpertDisplayInfoDTO.NavigationDTO form) {
        ch.dvbern.tax.common.presentation.cd.widgets.Composite formComp = new ch.dvbern.tax.common.presentation.cd.widgets.Composite(forms, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginRight = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginLeft = 6;
        formComp.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 2;
        gd.verticalAlignment = 2;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        formComp.setLayoutData(gd);
        switch (form.getState()) {
            case 4: {
                formComp.setBackground(COL_ERROR);
                break;
            }
            case 2: {
                formComp.setBackground(COL_WARNING);
                break;
            }
            case 3: {
                formComp.setBackground(COL_MISSING);
                break;
            }
            case 11: {
                formComp.setBackground(COL_TRANSP);
                break;
            }
            default: {
                formComp.setBackground(COL_OK);
            }
        }
        Label fb = new Label((Composite)formComp, 0);
        Image img = this.readImage(form.getIconName());
        if (img != null) {
            fb.setImage(img);
        }
        if (form.getDescriptionKey() != null) {
            String msg = ExpertDisplayInfoDTO.getLabelText(form.getDescriptionKey(), form.getDesciptionAddOns(), TaxmeController.getInstance().getLocalisationHelper());
            msg = StringUtil.htmlToText(msg);
            fb.setToolTipText(msg);
        }
        fb.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent arg0) {
                TaxmeController.getInstance().setFormAccessKey(form.getAccessKey());
            }
        });
    }

    private Image readImage(String name) {
        return GuiUtil.getImage(TaxmeController.getInstance().getFormSource(), name, this.imageRegistry);
    }
}

