/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.dialog;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.dialog.TitleAreaDialog;
import ch.dvbern.tax.common.presentation.cd.resourcetools.TranslationManager;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class TranslationDialog
extends TitleAreaDialog {
    private String nlsKey = null;
    private static final int BORDER = 5;
    private boolean dirty = false;

    public TranslationDialog(Shell parentShell, String nlsKey) {
        super(parentShell);
        this.nlsKey = nlsKey;
    }

    protected Control createDialogArea(Composite parent) {
        String title = Messages.getString("title.translation.dialog") + ": " + this.nlsKey;
        this.getShell().setText(title);
        this.setTitle(title);
        this.setMessage(Messages.getString("label.translation.message"));
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createContent(composite);
        return composite;
    }

    private void createContent(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayoutData((Object)new GridData(1808));
        c.setLayout((Layout)new FormLayout());
        final Map resources = TranslationManager.getInstance().getResourceMap();
        final Table table = new Table(c, 98304);
        FormData fdTable = new FormData();
        table.setLayoutData((Object)fdTable);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(Messages.getString("label.translation.locale"));
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(Messages.getString("label.translation.text"));
        Iterator iter = resources.keySet().iterator();
        while (iter.hasNext()) {
            TableItem tableItem = new TableItem(table, 65536);
            String key = (String)iter.next();
            Properties rb = (Properties)resources.get(key);
            String translation = null;
            translation = rb.containsKey(this.nlsKey) ? rb.get(this.nlsKey).toString() : "?";
            tableItem.setText(new String[]{key, translation});
        }
        final TableEditor editor = new TableEditor(table);
        editor.horizontalAlignment = 4;
        editor.grabHorizontal = true;
        editor.minimumWidth = 50;
        boolean EDITABLECOLUMN = true;
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item;
                Control oldEditor = editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((item = (TableItem)e.item) == null) {
                    return;
                }
                Text newEditor = new Text((Composite)table, 0);
                newEditor.setText(item.getText(1));
                newEditor.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        Text text = (Text)editor.getEditor();
                        editor.getItem().setText(1, text.getText());
                        TranslationDialog.this.dirty = true;
                    }
                });
                newEditor.addFocusListener((FocusListener)new TableEditorFocusListener(table, resources));
                newEditor.selectAll();
                newEditor.setFocus();
                editor.setEditor((Control)newEditor, item, 1);
            }
        });
        fdTable.top = new FormAttachment(0, 5);
        fdTable.left = new FormAttachment(0, 5);
        fdTable.right = new FormAttachment(100, -5);
        fdTable.bottom = new FormAttachment(100, -5);
        table.setVisible(true);
        column1.pack();
        column2.pack();
    }

    protected void okPressed() {
        if (this.dirty) {
            TranslationManager.getInstance().save();
            this.dirty = false;
        }
        this.cancelPressed();
    }

    class TableEditorFocusListener
    implements FocusListener {
        private Table table;
        private Map resources;

        public TableEditorFocusListener(Table table, Map resources) {
            this.table = table;
            this.resources = resources;
        }

        public void focusGained(FocusEvent arg0) {
        }

        public void focusLost(FocusEvent arg0) {
            if (TranslationDialog.this.dirty) {
                TableItem[] items = this.table.getItems();
                for (int i = 0; i < items.length; ++i) {
                    TableItem item = items[i];
                    Properties p = (Properties)this.resources.get(item.getText(0));
                    p.put(TranslationDialog.this.nlsKey, item.getText(1));
                }
            }
        }
    }
}

