/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.dialog;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.dialog.TitleAreaDialog;
import ch.dvbern.tax.common.presentation.cd.util.ConnectionUtil;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.presentation.cd.util.ProxyConfig;
import ch.dvbern.tax.common.presentation.cd.widgets.Button;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ProxySettingsDialog
extends TitleAreaDialog {
    private Label labelHost;
    private Label labelPort;
    private Button buttonEnabled;
    private Text textHost;
    private Text textPort;
    private ProxyConfig proxyConfig;

    public ProxySettingsDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("title.proxy.conf"));
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.getString("title.proxy.conf"));
        this.setMessage(Messages.getString("label.proxy.conf.message"));
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(1808));
        this.buttonEnabled = new Button(panel, 32);
        this.buttonEnabled.setText(Messages.getString("label.proxy.conf.enabled", (Control)this.buttonEnabled));
        GridData ldButton = new GridData(768);
        ldButton.horizontalSpan = 2;
        this.buttonEnabled.setLayoutData(ldButton);
        this.labelHost = new Label(panel, 0);
        this.labelHost.setText(Messages.getString("label.proxy.conf.host", (Control)this.labelHost));
        this.textHost = new Text(panel, 2048);
        this.textHost.setLayoutData((Object)new GridData(768));
        this.labelPort = new Label(panel, 0);
        this.labelPort.setText(Messages.getString("label.proxy.conf.port", (Control)this.labelPort));
        this.textPort = new Text(panel, 2048);
        this.textPort.setLayoutData((Object)new GridData(768));
        ProxyConfig conf = ConnectionUtil.getProxyConfig();
        if (conf != null) {
            this.buttonEnabled.setSelection(conf.isProxyEnabled());
            if (conf.getHost() != null) {
                this.textHost.setText(conf.getHost());
            }
            if (conf.getPort() != 0) {
                this.textPort.setText(Integer.toString(conf.getPort()));
            }
        }
        this.setFieldsState();
        this.buttonEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                ProxySettingsDialog.this.setFieldsState();
            }
        });
        if (this.buttonEnabled.getSelection()) {
            this.textHost.setFocus();
        } else {
            this.buttonEnabled.setFocus();
        }
        return panel;
    }

    protected void okPressed() {
        try {
            this.proxyConfig.setProxyEnabled(this.buttonEnabled.getSelection());
            this.proxyConfig.setHost(this.textHost.getText());
            this.proxyConfig.setPort(Integer.parseInt(this.textPort.getText()));
            this.close();
        }
        catch (NumberFormatException nfe) {
            DialogUtil.showErrorDialog(Messages.getString("error.proxy.config.port"));
        }
    }

    public void setProxyConfig(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    private void setFieldsState() {
        this.textHost.setEnabled(this.buttonEnabled.getSelection());
        this.textPort.setEnabled(this.buttonEnabled.getSelection());
    }
}

