/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.dialog;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ActionRegistry;
import ch.dvbern.tax.common.presentation.cd.action.PrintableAction;
import ch.dvbern.tax.common.presentation.cd.action.WizardMultiPrintAction;
import ch.dvbern.tax.common.presentation.cd.dialog.TitleAreaDialog;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.util.PrintUtil;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PrintDialog
extends TitleAreaDialog {
    private List buttonsEinzeln = new ArrayList();
    private List buttonsAlle = new ArrayList();
    private static final int MARGIN_LEFT = 20;
    private static boolean allowMultipleWizardPrint = false;

    public PrintDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("title.shell.print.dialog"));
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.getString("title.print.dialog"));
        this.setMessage(Messages.getString("label.print.message"));
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData());
        Label labelEinzeln = new Label(panel, 64);
        GridData gd = new GridData();
        gd.widthHint = 500;
        labelEinzeln.setLayoutData((Object)gd);
        labelEinzeln.setText(Messages.getString("label.print.einzelformulare", (Control)labelEinzeln));
        this.buttonsEinzeln.clear();
        List navItems = TaxmeController.getInstance().getTmoSession().getExpertNavigationItems();
        Iterator iter = navItems.iterator();
        while (iter.hasNext()) {
            ExpertDisplayInfoDTO.NavigationDTO navigationDTO = (ExpertDisplayInfoDTO.NavigationDTO)iter.next();
            GridData gd2 = new GridData();
            gd2.horizontalIndent = 20;
            if (navigationDTO.isExtraForm() || navigationDTO.getPrintState() == 12) continue;
            Button buttonEinzeln = new Button(panel, 32);
            buttonEinzeln.setLayoutData((Object)gd2);
            buttonEinzeln.setData((Object)navigationDTO);
            buttonEinzeln.setText(Messages.getString(navigationDTO.getFormName(), (Control)buttonEinzeln));
            if (navigationDTO.getState() == 1 || navigationDTO.getState() == 2) {
                buttonEinzeln.setEnabled(true);
            } else {
                buttonEinzeln.setEnabled(false);
            }
            this.buttonsEinzeln.add(buttonEinzeln);
        }
        Label labelAlles = new Label(panel, 64);
        GridData gdAlles = new GridData();
        gdAlles.widthHint = 500;
        labelAlles.setLayoutData((Object)gdAlles);
        labelAlles.setText(Messages.getString("label.print.alleformulare", (Control)labelAlles));
        int stateStek = TaxmeController.getInstance().getWizardDisplayInfoDTO().getNavigationDTO().getState();
        if (stateStek != 1 && stateStek != 2) {
            Label labelWarnung = new Label(panel, 64);
            GridData gdWarnung = new GridData();
            gdWarnung.widthHint = 500;
            labelWarnung.setLayoutData((Object)gdWarnung);
            labelWarnung.setFont(GuiUtil.getFontRegistry().getBold("font.normal"));
            labelWarnung.setForeground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_RED));
            labelWarnung.setText(Messages.getString("label.print.warnung.nicht.gruen", (Control)labelWarnung));
        }
        this.buttonsAlle.clear();
        ActionRegistry reg = ActionRegistry.getInstance();
        Iterator it = reg.getPrintActions().iterator();
        while (it.hasNext()) {
            Action action = (Action)it.next();
            GridData gd4 = new GridData();
            gd4.horizontalIndent = 20;
            Button buttonAlles = new Button(panel, 32);
            if (stateStek == 1 || stateStek == 2) {
                buttonAlles.setEnabled(true);
            } else {
                buttonAlles.setEnabled(false);
            }
            buttonAlles.setLayoutData((Object)gd4);
            buttonAlles.setText(action.getText());
            buttonAlles.addSelectionListener((SelectionListener)new PrintAllSelectionListener());
            buttonAlles.setData((Object)action);
            this.buttonsAlle.add(buttonAlles);
        }
        return panel;
    }

    protected void okPressed() {
        if (allowMultipleWizardPrint) {
            ArrayList docsForMultiPrint = new ArrayList();
            Iterator it = this.buttonsAlle.iterator();
            while (it.hasNext()) {
                Button button = (Button)it.next();
                if (!button.getSelection() || !(button.getData() instanceof PrintableAction)) continue;
                PrintableAction action = (PrintableAction)button.getData();
                docsForMultiPrint.addAll(action.getFormKeys());
            }
            WizardMultiPrintAction actionMulti = new WizardMultiPrintAction(docsForMultiPrint);
            actionMulti.run();
        } else {
            Iterator it = this.buttonsAlle.iterator();
            while (it.hasNext()) {
                Button button = (Button)it.next();
                if (!button.getSelection()) continue;
                Action action = (Action)button.getData();
                action.run();
                this.close();
                return;
            }
        }
        List checked = this.getChecked();
        if (checked.isEmpty()) {
            this.close();
        } else if (PrintUtil.printForms(checked, true)) {
            this.close();
        }
    }

    private List getChecked() {
        ArrayList checked = new ArrayList();
        Iterator iter = this.buttonsEinzeln.iterator();
        while (iter.hasNext()) {
            Button element = (Button)iter.next();
            if (!element.getSelection()) continue;
            ExpertDisplayInfoDTO.NavigationDTO navigationDTO = (ExpertDisplayInfoDTO.NavigationDTO)element.getData();
            this.addSubItems(navigationDTO, checked);
        }
        return checked;
    }

    private void addSubItems(ExpertDisplayInfoDTO.NavigationDTO navigationDTO, List items) {
        if (navigationDTO.getSubItems() != null) {
            Iterator iter = navigationDTO.getSubItems().iterator();
            while (iter.hasNext()) {
                ExpertDisplayInfoDTO.NavigationDTO childDTO = (ExpertDisplayInfoDTO.NavigationDTO)iter.next();
                this.addSubItems(childDTO, items);
            }
        } else {
            PrintUtil.FormKey key = new PrintUtil.FormKey(navigationDTO.getAccessKey(), 1);
            items.add(key);
        }
    }

    private boolean canShowButtonsEinzeln() {
        Iterator iter = this.buttonsAlle.iterator();
        while (iter.hasNext()) {
            Button element = (Button)iter.next();
            if (!element.getSelection()) continue;
            return false;
        }
        return true;
    }

    private void enableButtonsEinzeln() {
        Iterator iter = this.buttonsEinzeln.iterator();
        while (iter.hasNext()) {
            Button element = (Button)iter.next();
            ExpertDisplayInfoDTO.NavigationDTO navigationDTO = (ExpertDisplayInfoDTO.NavigationDTO)element.getData();
            if (navigationDTO.getState() == 1 || navigationDTO.getState() == 2) {
                element.setEnabled(true);
                continue;
            }
            element.setEnabled(false);
        }
        Iterator it = this.buttonsAlle.iterator();
        while (it.hasNext()) {
            Button button = (Button)it.next();
            button.setEnabled(true);
        }
    }

    private void disableButtonsEinzeln() {
        Iterator iter = this.buttonsEinzeln.iterator();
        while (iter.hasNext()) {
            Button element = (Button)iter.next();
            element.setSelection(false);
            element.setEnabled(false);
        }
    }

    public static void setAllowMultipleWizardPrint(boolean newAllowMultipleWizardPrint) {
        allowMultipleWizardPrint = newAllowMultipleWizardPrint;
    }

    private class PrintAllSelectionListener
    extends SelectionAdapter {
        private PrintAllSelectionListener() {
        }

        public void widgetSelected(SelectionEvent ev) {
            if (allowMultipleWizardPrint) {
                if (!PrintDialog.this.canShowButtonsEinzeln()) {
                    PrintDialog.this.disableButtonsEinzeln();
                } else {
                    PrintDialog.this.enableButtonsEinzeln();
                }
            } else if (((Button)ev.getSource()).getSelection()) {
                PrintDialog.this.disableButtonsEinzeln();
                Iterator it = PrintDialog.this.buttonsAlle.iterator();
                while (it.hasNext()) {
                    Button button = (Button)it.next();
                    if (ev.getSource() == button) continue;
                    button.setEnabled(false);
                }
            } else {
                PrintDialog.this.enableButtonsEinzeln();
            }
        }
    }
}

