/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.dialog;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.dialog.TitleAreaDialog;
import ch.dvbern.tax.common.presentation.cd.widgets.Button;
import java.net.PasswordAuthentication;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AuthenticationDialog
extends TitleAreaDialog {
    private Label labelUsername;
    private Label labelPassword;
    private Text textUsername;
    private Text textPassword;
    private Button buttonSave;
    private boolean saveSelected;
    private PasswordAuthentication auth;

    public AuthenticationDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("title.proxy.auth"));
    }

    public void create() {
        super.create();
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.getString("title.proxy.auth"));
        this.setMessage(Messages.getString("label.proxy.auth.message"));
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(1808));
        panel.setFont(parent.getFont());
        this.labelUsername = new Label(panel, 0);
        this.labelUsername.setText(Messages.getString("label.proxy.auth.user", (Control)this.labelUsername));
        this.textUsername = new Text(panel, 2048);
        this.textUsername.setLayoutData((Object)new GridData(768));
        this.textUsername.setFocus();
        if (this.auth != null) {
            this.textUsername.setText(this.auth.getUserName());
        }
        this.labelPassword = new Label(panel, 0);
        this.labelPassword.setText(Messages.getString("label.proxy.auth.password", (Control)this.labelPassword));
        this.textPassword = new Text(panel, 2048);
        this.textPassword.setEchoChar('*');
        this.textPassword.setLayoutData((Object)new GridData(768));
        if (this.auth != null) {
            this.textPassword.setText(new String(this.auth.getPassword()));
        }
        this.buttonSave = new Button(panel, 32);
        this.buttonSave.setText(Messages.getString("label.proxy.auth.save", (Control)this.buttonSave));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.buttonSave.setLayoutData(gd);
        this.buttonSave.setSelection(this.saveSelected);
        return panel;
    }

    protected void okPressed() {
        this.auth = new PasswordAuthentication(this.textUsername.getText(), this.textPassword.getText().toCharArray());
        this.saveSelected = this.buttonSave.getSelection();
        this.close();
    }

    public PasswordAuthentication getAuthentication() {
        return this.auth;
    }

    public void setAuthentication(PasswordAuthentication auth) {
        this.auth = auth;
    }

    public boolean isSaveSelected() {
        return this.saveSelected;
    }

    public void setSaveSelected(boolean saveSelected) {
        this.saveSelected = saveSelected;
    }
}

