/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.builders.wizard;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.builders.common.AControlBuilder;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.util.OsSupport;
import ch.dvbern.tax.common.presentation.cd.util.TaxmeConfigurator;
import ch.dvbern.tax.common.presentation.cd.widgets.BorderedLabel;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.util.LabelAddOnHelper;
import org.eclipse.swt.widgets.Control;

public class WLabelBuilder
extends AControlBuilder {
    private WizardDisplayInfoDTO.LabelItemDTO labelItemDTO;
    private BorderedLabel label;
    private Integer width;

    public void init(WizardDisplayInfoDTO.LabelItemDTO labelDTO, Integer width) {
        this.labelItemDTO = labelDTO;
        this.width = width;
        this.label = null;
    }

    public void createControl() {
        this.label = (BorderedLabel)this.controlReuseUtil.getControl(this.labelItemDTO.getUniqueItemIdentifier());
        if (this.label == null) {
            this.label = new BorderedLabel(this.parent, 2, OsSupport.isMacOs() ? 6 : 1, this.labelItemDTO.getColspan(), this.width, 64);
            this.controlReuseUtil.addControl(this.labelItemDTO.getUniqueItemIdentifier(), (Control)this.label);
            this.label.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_SECTION_LABEL_BACKGROUND));
            this.label.setFont(GuiUtil.getFontRegistry().get("font.normal"));
            String align = this.labelItemDTO.getAlign();
            if (align == null) {
                align = TaxmeConfigurator.getDefaultLabelAlignment();
            }
            this.label.setAlignment(align);
            if (this.labelItemDTO.getForegroundColor() != null) {
                this.label.setForeground(GuiUtil.getColorRegistry().get(this.labelItemDTO.getForegroundColor()));
            } else {
                this.label.setForeground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_SECTION_LABEL_FOREGROUND));
            }
        }
        String key = this.labelItemDTO.getName().toString();
        Object[] args = LabelAddOnHelper.getReplacements(this.labelItemDTO.getLabelAddOns(), TaxmeController.getInstance().getLocalisationHelper());
        this.label.setText(Messages.getString(key, (Control)this.label.getNestedLabel(), args));
        this.label.setData(this.labelItemDTO.getName().toString());
    }

    public Control getControl() {
        return this.label;
    }
}

