/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.builders.common;

import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.builders.common.AControlBuilder;
import ch.dvbern.tax.common.presentation.cd.items.IValueItem;
import ch.dvbern.tax.common.presentation.cd.items.expert.AExpertItem;
import ch.dvbern.tax.common.presentation.cd.parts.CheckboxPart;
import ch.dvbern.tax.common.presentation.cd.parts.ComboboxPart;
import ch.dvbern.tax.common.presentation.cd.parts.HiddenPart;
import ch.dvbern.tax.common.presentation.cd.parts.HighlightFocusElementListener;
import ch.dvbern.tax.common.presentation.cd.parts.IValuePart;
import ch.dvbern.tax.common.presentation.cd.parts.RadioGroupPart;
import ch.dvbern.tax.common.presentation.cd.parts.TabPart;
import ch.dvbern.tax.common.presentation.cd.parts.TextPart;
import ch.dvbern.tax.common.presentation.cd.resourcetools.manager.ToolCommunication;
import ch.dvbern.tax.common.presentation.cd.util.MessageControlMapper;
import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class ValueBuilder
extends AControlBuilder {
    private static final String DATA_KEY_SHORTHELP = "shortHelpKey";
    private IValueItem valueDTO;
    private Control control;
    private final boolean toolsEnabled = TaxmeConfig.getBoolean("ToolsEnabled");

    public void init(IValueItem valueDTO) {
        this.valueDTO = valueDTO;
        this.control = null;
    }

    public void createControl() {
        this.control = this.createValuePart(this.valueDTO);
    }

    protected Control createValuePart(IValueItem item) {
        Collection msgs;
        String shortHelpKey;
        IValuePart control = (IValuePart)this.controlReuseUtil.getControl(item.getUID());
        if (control == null) {
            switch (item.getType()) {
                case 0: {
                    control = new TextPart(this.parent);
                    break;
                }
                case 3: {
                    control = new CheckboxPart(this.parent);
                    break;
                }
                case 1: {
                    control = new RadioGroupPart(this.parent);
                    break;
                }
                case 2: {
                    control = new ComboboxPart(this.parent);
                    break;
                }
                default: {
                    control = new HiddenPart(this.parent);
                }
            }
            this.controlReuseUtil.addControl(item.getUID(), (Control)control);
            if (item.isMoveToForeground()) {
                ((Control)control).moveAbove(null);
            }
            if (item instanceof AExpertItem) {
                ((Control)control).addFocusListener((FocusListener)new HighlightFocusElementListener());
            }
        }
        control.init(item);
        final Control ctrl = (Control)control;
        if (ctrl.getData(DATA_KEY_SHORTHELP) == null) {
            ctrl.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent ev) {
                    TabPart part = TaxmeController.getInstance().getApp().getTabPart();
                    part.setFieldShortHelpKey((String)ctrl.getData(ValueBuilder.DATA_KEY_SHORTHELP));
                }
            });
            if (this.toolsEnabled) {
                ctrl.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseDoubleClick(MouseEvent ev) {
                        if (ev.button == 1) {
                            String key = (String)ctrl.getData(ValueBuilder.DATA_KEY_SHORTHELP);
                            ToolCommunication.getInstance().manageShortHelpMappingOnControls(TaxmeController.getInstance().getApp(), key);
                        }
                    }
                });
            }
        }
        if ((shortHelpKey = item.getShortHelpKey()) == null) {
            shortHelpKey = "";
        }
        ctrl.setData(DATA_KEY_SHORTHELP, (Object)shortHelpKey);
        Rectangle bounds = item.getBounds();
        if (bounds != null) {
            ((Control)control).setBounds(bounds);
        }
        if ((msgs = item.getMessages()) != null && !msgs.isEmpty()) {
            Iterator iter = msgs.iterator();
            while (iter.hasNext()) {
                MessageItemDTO msg = (MessageItemDTO)iter.next();
                MessageControlMapper.getInstance().put(msg, (Control)control);
            }
        }
        return (Control)control;
    }

    public Control getControl() {
        return this.control;
    }

    public List getTabOrder() {
        return Collections.singletonList(this.control);
    }
}

