/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd;

import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.common.imports.ImportConfig;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class TaxmeConfig {
    private static final String FILE_SEPARATOR = File.separator;
    private static final String DEFAULT_USER_CONF_FILE = "dvbern-tax" + FILE_SEPARATOR + "config" + FILE_SEPARATOR + "user-config.properties";
    private static final String DEFAULT_TABLE_SORTS_FILE = "dvbern-tax" + FILE_SEPARATOR + "config" + FILE_SEPARATOR + "table-sorts.conf";
    private static final String DEFAULT_PRINT_DIR = "dvbern-tax" + FILE_SEPARATOR + "print";
    private static final String DEFAULT_SAVE_DIR = "dvbern-tax" + FILE_SEPARATOR + "tax";
    private static final String PROJECT_HOME = new File("").getAbsolutePath() + FILE_SEPARATOR;
    private static Properties config;
    private static DataResource dataResource;
    private static ImportConfig importConfig;
    private static boolean expertModeEnabled;
    private static boolean wizardModeEnabled;
    private static File userConfigFile;
    private static File wizardTableSortsFile;
    private static Map wizardTableSorts;
    private static File expertTableSortsFile;
    private static Map expertTableSorts;
    private static String applicationVersion;
    private static File saveDir;
    private static File importDir;
    private static File pdfOutputDir;

    public static void load(InputStream is) {
        Properties appProps = TaxmeConfig.loadProperties(is, null);
        TaxmeConfig.init(appProps);
    }

    public static void load(File configFile) {
        Properties appProps = TaxmeConfig.loadProperties(configFile, null);
        TaxmeConfig.init(appProps);
    }

    private static void init(Properties appProps) {
        String userHome = System.getProperty("user.home");
        String confFileUsb = appProps.getProperty("user.usb.config");
        String confFileAbsolute = appProps.getProperty("user.absolute.config");
        String confFile = appProps.getProperty("user.config", DEFAULT_USER_CONF_FILE);
        if (confFileUsb != null) {
            userConfigFile = new File(confFileUsb);
        } else if (confFileAbsolute != null) {
            userConfigFile = new File(confFileAbsolute);
        } else if (confFile != null) {
            userConfigFile = new File(userHome, confFile);
        }
        TaxmeConfig.createFile(userConfigFile);
        config = TaxmeConfig.loadProperties(userConfigFile, appProps);
        String sortsFile = appProps.getProperty("table.sorts.config", DEFAULT_TABLE_SORTS_FILE);
        wizardTableSortsFile = new File(userHome, sortsFile + "." + 1);
        expertTableSortsFile = new File(userHome, sortsFile + "." + 2);
    }

    private static void createFile(File f) {
        if (f.exists()) {
            return;
        }
        File parent = f.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        try {
            f.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException("can't create user config file");
        }
    }

    private static Properties loadProperties(String file, Properties def) {
        return TaxmeConfig.loadProperties(new File(file), def);
    }

    private static Properties loadProperties(File file, Properties def) {
        InputStream fis = null;
        try {
            fis = new BufferedInputStream(new FileInputStream(file));
            Properties props = def == null ? new Properties() : new Properties(def);
            props.load(fis);
            Properties properties = props;
            return properties;
        }
        catch (IOException ioe) {
            throw new RuntimeException("can't load import properties " + file, ioe);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static Properties loadProperties(InputStream is, Properties def) {
        try {
            Properties props = def == null ? new Properties() : new Properties(def);
            props.load(is);
            Properties properties = props;
            return properties;
        }
        catch (IOException ioe) {
            throw new RuntimeException("can't load import properties from stream", ioe);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String getString(String key) {
        return config.getProperty(key);
    }

    public static String getString(String key, String defaultValue) {
        return config.getProperty(key, defaultValue);
    }

    public static int getInt(String key) {
        String value = config.getProperty(key);
        if (value == null) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    public static boolean getBoolean(String key) {
        return Boolean.valueOf(config.getProperty(key));
    }

    public static void setValue(String key, boolean value) {
        TaxmeConfig.setValue(key, Boolean.toString(value));
    }

    public static void setValue(String key, String value) {
        config.setProperty(key, value);
    }

    public static void setValue(String key, int value) {
        TaxmeConfig.setValue(key, Integer.toString(value));
    }

    public static void remove(String key) {
        config.remove(key);
    }

    private static String getProjectHome() {
        return PROJECT_HOME;
    }

    public static File getSaveDir() {
        if (saveDir == null) {
            String saveDirNameAbsolutePath = config.getProperty("user.savedir.absolute.path");
            String saveDirNameUsbPath = config.getProperty("user.savedir.usb.path");
            File tmpSaveDir = null;
            if (saveDirNameAbsolutePath != null) {
                tmpSaveDir = new File(saveDirNameAbsolutePath);
            }
            if (saveDirNameUsbPath != null) {
                tmpSaveDir = new File(saveDirNameUsbPath);
            }
            if (tmpSaveDir != null) {
                saveDir = tmpSaveDir;
            } else {
                String dir = config.getProperty("user.savedir", DEFAULT_SAVE_DIR);
                saveDir = new File(System.getProperty("user.home"), dir);
            }
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
        }
        return saveDir;
    }

    public static File getImportDir() {
        if (importDir == null) {
            String importDirNameAbsolutePath = config.getProperty("user.importdir.absolute.path");
            String importDirNameUsbPath = config.getProperty("user.importdir.usb.path");
            File tmpImportDir = null;
            if (importDirNameAbsolutePath != null) {
                tmpImportDir = new File(importDirNameAbsolutePath);
            }
            if (importDirNameUsbPath != null) {
                tmpImportDir = new File(importDirNameUsbPath);
            }
            if (tmpImportDir != null) {
                importDir = tmpImportDir;
            } else {
                String importDirName = config.getProperty("user.importdir", DEFAULT_SAVE_DIR);
                importDir = new File(System.getProperty("user.home"), importDirName);
            }
            if (!importDir.exists()) {
                importDir.mkdirs();
            }
        }
        return importDir;
    }

    public static File getPdfOutputDir() {
        if (pdfOutputDir == null) {
            String pdfOutputDirNameAbsolutePath = config.getProperty("user.printdir.absolute.path");
            String pdfOutputDirNameUsbPath = config.getProperty("user.printdir.usb.path");
            File tmpPdfOutputDir = null;
            if (pdfOutputDirNameAbsolutePath != null) {
                tmpPdfOutputDir = new File(pdfOutputDirNameAbsolutePath);
            }
            if (pdfOutputDirNameUsbPath != null) {
                tmpPdfOutputDir = new File(pdfOutputDirNameUsbPath);
            }
            if (tmpPdfOutputDir != null) {
                pdfOutputDir = tmpPdfOutputDir;
            } else {
                String dirName = config.getProperty("user.printdir", DEFAULT_PRINT_DIR);
                pdfOutputDir = new File(System.getProperty("user.home"), dirName);
            }
            if (!pdfOutputDir.exists()) {
                pdfOutputDir.mkdirs();
            }
        }
        return pdfOutputDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store() {
        OutputStream fos = null;
        try {
            fos = new BufferedOutputStream(new FileOutputStream(userConfigFile));
            config.store(fos, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        TaxmeConfig.saveMap(expertTableSorts, expertTableSortsFile);
        TaxmeConfig.saveMap(wizardTableSorts, wizardTableSortsFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveMap(Map map, File file) {
        if (map == null) {
            return;
        }
        TaxmeConfig.createFile(file);
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            oos.writeObject(map);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map readMap(File file) {
        if (!file.exists()) {
            return new HashMap();
        }
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            Map map = (Map)ois.readObject();
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            HashMap hashMap = new HashMap();
            return hashMap;
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String getWelcomeFilePath() {
        return TaxmeConfig.getInfoFilePath("welcome.html");
    }

    public static String getAboutFilePath() {
        return TaxmeConfig.getInfoFilePath("about.html");
    }

    public static String getShorthelpFilePath(String fileName) {
        return TaxmeConfig.getProjectHome() + TaxmeConfig.getString("shorthelp.dir") + TaxmeConfig.getLanguage() + "/" + fileName;
    }

    public static String getShorthelpDir() {
        return TaxmeConfig.getProjectHome() + TaxmeConfig.getString("shorthelp.dir");
    }

    public static String getMainhelpFilePath(String fileName) {
        return TaxmeConfig.getMainhelpDir() + TaxmeConfig.getLanguage() + FILE_SEPARATOR + fileName;
    }

    public static String getMainhelpDir() {
        if (TaxmeConfig.getString("mainhelp.dir") == null) {
            return null;
        }
        return TaxmeConfig.getProjectHome() + TaxmeConfig.getString("mainhelp.dir");
    }

    public static String getIconFilePath(String fileName) {
        return TaxmeConfig.getIconDir() + fileName;
    }

    public static String getIconDir() {
        return TaxmeConfig.getProjectHome() + TaxmeConfig.getString("icon.dir");
    }

    public static String getImageDir() {
        return TaxmeConfig.getProjectHome() + TaxmeConfig.getString("image.dir") + TaxmeConfig.getLanguage() + FILE_SEPARATOR;
    }

    public static String getFormImagesDir() {
        return TaxmeConfig.getProjectHome() + TaxmeConfig.getString("forms.dir") + TaxmeConfig.getLanguage() + FILE_SEPARATOR;
    }

    public static String getImageFilePath(String fileName) {
        return TaxmeConfig.getImageDir() + FILE_SEPARATOR + fileName;
    }

    public static String getResourceBundlePath(String lang) {
        return TaxmeConfig.getProjectHome() + TaxmeConfig.getString("resources.dir") + "resources_" + lang + ".properties";
    }

    public static String getResourceAdditionalBundlePath(String lang) {
        String additionalPath;
        if (TaxmeController.getInstance().getTmoSession() != null && (additionalPath = TaxmeController.getInstance().getTmoSession().getImageVariant()) != null && additionalPath.length() > 0) {
            return TaxmeConfig.getProjectHome() + TaxmeConfig.getString("resources.dir") + "/resources_" + additionalPath + "_" + lang + ".properties";
        }
        return null;
    }

    private static String getInfoFilePath(String fileName) {
        return TaxmeConfig.getProjectHome() + TaxmeConfig.getString("info.dir") + TaxmeConfig.getLanguage() + FILE_SEPARATOR + fileName;
    }

    private static String getLanguage() {
        return TaxmeController.getInstance().getLanguage();
    }

    public static void setDataResource(DataResource resource) {
        dataResource = resource;
    }

    public static DataResource getDataResource() {
        return dataResource;
    }

    public static ImportConfig getImportConfig() {
        if (importConfig == null) {
            String resDir = TaxmeConfig.getProjectHome() + TaxmeConfig.getString("resources.dir");
            Properties impConf = TaxmeConfig.loadProperties(resDir + "importConfig.properties", null);
            Properties impProps = TaxmeConfig.loadProperties(resDir + "imports.properties", null);
            importConfig = new ImportConfig(impConf, impProps);
        }
        return importConfig;
    }

    public static boolean isExpertModeEnabled() {
        return expertModeEnabled;
    }

    public static void setExpertModeEnabled(boolean experModeEnabled) {
        expertModeEnabled = experModeEnabled;
    }

    public static boolean isWizardModeEnabled() {
        return wizardModeEnabled;
    }

    public static void setWizardModeEnabled(boolean wizardModeEnabled) {
        TaxmeConfig.wizardModeEnabled = wizardModeEnabled;
    }

    public static void check() {
        if (config == null) {
            throw new RuntimeException("Configuration not loaded. Please load it with TaxmeConfig.loadConfig(..) .");
        }
        if (dataResource == null) {
            throw new RuntimeException("DataResource not configured. Please set it with TmoSessionImpl.setDataResource(..) .");
        }
        if (!expertModeEnabled && !wizardModeEnabled) {
            throw new RuntimeException("Expert and Wizard Mode are disabled. Please enable at least one Mode.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getApplicationVersion() {
        if (applicationVersion == null) {
            applicationVersion = "";
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader("version.txt"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    String searchString;
                    if (!(line = line.trim()).startsWith(searchString = "version=")) continue;
                    applicationVersion = line.substring(searchString.length()).trim();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return applicationVersion;
    }

    public static String getSteuerjahr() {
        return TaxmeConfig.getString("steuerjahr");
    }

    public static String getVorjahr() {
        return TaxmeConfig.getString("vorjahr");
    }

    public static Map getTableSorts(int mode) {
        if (mode == 2) {
            if (expertTableSorts == null) {
                expertTableSorts = TaxmeConfig.readMap(expertTableSortsFile);
            }
            return expertTableSorts;
        }
        if (wizardTableSorts == null) {
            wizardTableSorts = TaxmeConfig.readMap(wizardTableSortsFile);
        }
        return wizardTableSorts;
    }

    static {
        expertModeEnabled = true;
        wizardModeEnabled = true;
    }
}

