/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd;

import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.resourcetools.TranslationManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.eclipse.swt.widgets.Control;

public class Messages {
    private static Map bundles = new HashMap();
    private static boolean toolsEnabled = TaxmeConfig.getBoolean("ToolsEnabled");

    private Messages() {
    }

    public static String getStringWithoutTranslation(String key) {
        String lang = TaxmeController.getInstance().getLanguage();
        ResourceBundle bundle = Messages.getBundle(lang);
        try {
            String s = bundle.getString(key);
            if (s.indexOf("&nbsp;") != -1) {
                s = s.replaceAll("&nbsp;", " ");
            }
            return s;
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    public static String getStringWithoutTranslation(String key, Object[] args) {
        String text = Messages.getStringWithoutTranslation(key);
        if (args != null && args.length > 0) {
            MessageFormat mf = new MessageFormat(text);
            text = mf.format(args);
        }
        return text;
    }

    public static String getString(String key) {
        if (toolsEnabled && key != null) {
            TranslationManager.getInstance().getTranslationMap().add(key);
        }
        return Messages.getStringWithoutTranslation(key);
    }

    public static String getString(String key, Object[] args) {
        if (toolsEnabled && key != null) {
            TranslationManager.getInstance().getTranslationMap().add(key);
        }
        return Messages.getStringWithoutTranslation(key, args);
    }

    public static String getString(String key, Control control) {
        if (toolsEnabled && control != null) {
            TranslationManager.getInstance().registerControl(control, key);
        }
        return Messages.getStringWithoutTranslation(key);
    }

    public static String getString(String key, Control control, Object[] args) {
        if (toolsEnabled && control != null) {
            TranslationManager.getInstance().registerControl(control, key);
        }
        return Messages.getStringWithoutTranslation(key, args);
    }

    public static void setString(String key, String value) {
        String lang = TaxmeController.getInstance().getLanguage();
        Messages.setString(key, value, lang);
    }

    public static void setString(String key, String value, String lang) {
        String path = TaxmeConfig.getResourceBundlePath(lang);
        Properties p = new Properties();
        try {
            p.load(new BufferedInputStream(new FileInputStream(path)));
            p.setProperty(key, value);
            p.store(new BufferedOutputStream(new FileOutputStream(path)), null);
            Messages.reload();
        }
        catch (IOException e) {
            throw new RuntimeException("can't load resource bundle: " + path);
        }
    }

    public static void removeString(String key) {
        String lang = TaxmeController.getInstance().getLanguage();
        Messages.removeString(key, lang);
    }

    public static void removeString(String key, String lang) {
        String path = TaxmeConfig.getResourceBundlePath(lang);
        Properties p = new Properties();
        try {
            p.load(new BufferedInputStream(new FileInputStream(path)));
            p.remove(key);
            p.store(new BufferedOutputStream(new FileOutputStream(path)), null);
            Messages.reload();
        }
        catch (IOException e) {
            throw new RuntimeException("can't load resource bundle: " + path);
        }
    }

    private static ResourceBundle getBundle(String lang) {
        String path = null;
        try {
            String additionalPath;
            if (TaxmeController.getInstance().getTmoSession() != null && TaxmeController.getInstance().getTmoSession().getImageVariant() != null && (additionalPath = TaxmeController.getInstance().getTmoSession().getImageVariant()) != null && additionalPath.length() > 0) {
                String key = additionalPath + "_" + lang;
                ResourceBundle bundle = (ResourceBundle)bundles.get(key);
                if (bundle == null) {
                    path = TaxmeConfig.getResourceAdditionalBundlePath(lang);
                    bundle = new PropertyResourceBundle(new BufferedInputStream(new FileInputStream(path)));
                    bundles.put(key, bundle);
                }
                return bundle;
            }
            ResourceBundle bundle = (ResourceBundle)bundles.get(lang);
            if (bundle == null) {
                path = TaxmeConfig.getResourceBundlePath(lang);
                bundle = new PropertyResourceBundle(new BufferedInputStream(new FileInputStream(path)));
                bundles.put(lang, bundle);
            }
            return bundle;
        }
        catch (IOException e) {
            throw new RuntimeException("can't load resource bundle: " + path);
        }
    }

    public static void reload() {
        bundles.clear();
    }
}

