/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.bd.test;

import ch.dvbern.lib.resource.construct.ConstructionException;
import ch.dvbern.tax.common.engine.Engine;
import ch.dvbern.tax.common.engine.EngineXML;
import ch.dvbern.tax.common.engine.expertdisplay.Barcode2DGenerator;
import ch.dvbern.tax.common.integration.TmoIdentification;
import ch.dvbern.tax.common.presentation.bd.TmoSession;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.TmoSessionStateDTO;
import ch.dvbern.tax.common.transfer.dto.UpdateResultDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.ApplicationException;
import ch.dvbern.tax.common.transfer.failure.InvalidAuthenticationException;
import ch.dvbern.tax.common.transfer.failure.InvalidModelItemKeyException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class TmoSessionImpl
implements TmoSession {
    private static final String MODEL_XML = "/src/test/model/model.xml";
    private static final String XML_CONF = "/src/test/model/xml.conf";
    private Engine engine;
    private Map dataModel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(String id, String password) throws InvalidAuthenticationException, IOException {
        String projectBaseDir = System.getProperty("project.base.dir");
        new EngineXML(projectBaseDir, projectBaseDir + XML_CONF, projectBaseDir + MODEL_XML);
        StringBuffer xmlStructure = new StringBuffer();
        InputStreamReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(projectBaseDir + MODEL_XML);
            br = new BufferedReader(fr);
            String line = br.readLine();
            while (line != null) {
                xmlStructure.append(line);
                line = br.readLine();
            }
            br.close();
            fr.close();
            this.engine = Engine.createEngine(xmlStructure.toString(), null, false);
            this.dataModel = new HashMap();
            HashMap<String, ModelItemDTO> changes = new HashMap<String, ModelItemDTO>();
            changes.put("tables.subnavigation.subnavigation.0.module1.text1", new ModelItemDTO("TestString"));
            changes.put("tables.subnavigation.subnavigation.0.module2.int1", new ModelItemDTO(new Integer(22)));
            changes.put("tables.subnavigationV.subnavigation1.0.module1.subnavigation2.0.module2.subnavigation3.0.int", new ModelItemDTO(new Integer(111)));
            changes.put("tables.subnavigationV.subnavigation1.0.module1.subnavigation2.0.module2.subnavigation3.1.int", new ModelItemDTO(new Integer(222)));
            this.engine.update(this.dataModel, changes, true);
            this.printDataModel(this.dataModel);
        }
        catch (FileNotFoundException fnf) {
            fnf.printStackTrace();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        catch (ConstructionException ce) {
            ce.printStackTrace();
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (fr != null) {
                fr.close();
            }
        }
    }

    public void login(String caseId) throws InvalidAuthenticationException, IOException {
        this.login(caseId, "noPassword");
    }

    public void login(int mode, String guid, String address) throws InvalidAuthenticationException {
        throw new InvalidAuthenticationException();
    }

    public void login(int mode, String guid, String address, TmoIdentification id) throws InvalidAuthenticationException {
        throw new InvalidAuthenticationException();
    }

    private void printDataModel(Map dm) {
        System.out.println("\nData Model");
        Iterator i = dm.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry me = i.next();
            Object value = me.getValue() != null ? ((ModelItemDTO)me.getValue()).getValue() : null;
            System.out.println(">" + me.getKey() + " = " + value);
        }
    }

    public WizardDisplayInfoDTO getWizardDisplayInfo(String key, boolean autoEnable) {
        try {
            return this.engine.getWizardDisplayInfo(this.dataModel, key, true, false, false, 0, autoEnable).getWizardDisplayInfoDTO();
        }
        catch (InvalidModelItemKeyException imk) {
            imk.printStackTrace();
            return null;
        }
    }

    public WizardDisplayInfoDTO getWizardDisplayInfo(String key) {
        return this.getWizardDisplayInfo(key, false);
    }

    public void acceptUsageConditions(int importFlag) {
    }

    public TmoSessionStateDTO getTmoSessionState() {
        return new TmoSessionStateDTO(3);
    }

    public void reinitializeSession() {
    }

    public void update(Map newValues) {
        this.engine.update(this.dataModel, newValues, true);
    }

    public void delete(String dataModelKey) {
        try {
            this.engine.delete(this.dataModel, dataModelKey);
        }
        catch (InvalidModelItemKeyException imike) {
            imike.printStackTrace();
        }
    }

    public WizardDisplayInfoDTO update(Map newValues, boolean errorForced, boolean deleteForced, String key) {
        WizardDisplayInfoDTO result = null;
        try {
            UpdateResultDTO updateResultDTO = this.engine.update(this.dataModel, newValues, errorForced, deleteForced, key, true, false);
            result = updateResultDTO.getWizardDisplayInfoDTO();
        }
        catch (InvalidModelItemKeyException imike) {
            imike.printStackTrace();
        }
        return result;
    }

    public int touchCompleteModel() {
        int result = 1;
        try {
            int tmoState = this.getTmoSessionState().getState();
            if (tmoState != 3) {
                throw new ApplicationException("invalid session state: " + tmoState);
            }
            UpdateResultDTO urDTO = this.engine.touchCompleteModel(this.dataModel);
            ExpertDisplayInfoDTO ediDTO = urDTO.getExpertDisplayInfoDTO();
            if (ediDTO != null) {
                result = ediDTO.getState();
            }
        }
        catch (InvalidModelItemKeyException imike) {
            imike.printStackTrace();
        }
        return result;
    }

    public void update(Map newValues, boolean allowDelete) {
        this.engine.update(this.dataModel, newValues, allowDelete);
    }

    public void importData(Map newValues, boolean allowDelete) {
        this.engine.importData(this.dataModel, newValues, allowDelete);
    }

    public WizardDisplayInfoDTO release(String key, Locale userLocale) {
        return null;
    }

    public void logout() {
    }

    public void completeReset() {
    }

    public ExpertDisplayInfoDTO getExpertDisplayInfo(String key, Locale locale, int mode) {
        return null;
    }

    public List getExpertDisplayInfos(List keys, Locale locale, int mode) {
        return null;
    }

    public List getExpertNavigationItems() {
        try {
            return this.engine.getExpertNavigationItems(this.dataModel);
        }
        catch (InvalidModelItemKeyException imk) {
            imk.printStackTrace();
            return null;
        }
    }

    public ExpertDisplayInfoDTO expertUpdate(Map newValues, boolean errorForced, boolean deleteForced, String key, Locale locale, boolean touchItems) {
        throw new RuntimeException("feature not yet implemented");
    }

    public Map getOptions(String code, Object arg2) {
        return null;
    }

    public Map getOptionsLocalized(String code, Object arg2) {
        return null;
    }

    public boolean isImportable(String dataModelKey) {
        return true;
    }

    public TmoIdentification getTmoIdentification() {
        return null;
    }

    public Map getDataModel() {
        return this.dataModel;
    }

    public synchronized ModelItemDTO getModelItem(String dmk) {
        return (ModelItemDTO)this.dataModel.get(dmk);
    }

    public void completeReset(Map dataModel) {
    }

    public void recalculate() {
        this.engine.recalculate(this.dataModel);
    }

    public byte[] generateBarcode(Barcode2DGenerator generator) {
        return this.engine.generateBarcode(this.dataModel, generator, "test", null);
    }

    public String getImageVariant() {
        return null;
    }

    public void exitForm() {
    }

    public TmoIdentification createDossierIfNotExisting(TmoIdentification id) {
        return null;
    }

    public void loginWithoutAuthentification(TmoIdentification id) throws InvalidAuthenticationException {
    }

    public List getBelegInfo(TmoIdentification id, String dataModelKey) {
        return null;
    }

    public void setBelegInfo(TmoIdentification id, List belegDTOs) {
    }

    public Map getDataToImportDataFromDossier(TmoIdentification id, String dataModelKey) {
        return null;
    }

    public void printPdf(TmoIdentification id, String dataModelKey) {
    }

    public byte[] readBelegContent(Integer belegId) {
        return null;
    }

    public void deleteBeleg(Integer belegId) {
    }

    public Map getMappingData() {
        return null;
    }

    public Map importFromDossierMapped(Object keyFrom, Object keyTo, List persistenceReadDTOs) {
        return null;
    }

    public List getExpertNavigationItemAccessKeys() throws InvalidModelItemKeyException {
        ArrayList expNavItems = new ArrayList();
        List l = this.engine.getExpertNavigationItems(this.dataModel);
        Iterator i = l.iterator();
        while (i.hasNext()) {
            this.addSubItems((ExpertDisplayInfoDTO.NavigationDTO)i.next(), expNavItems);
        }
        return expNavItems;
    }

    private void addSubItems(ExpertDisplayInfoDTO.NavigationDTO navigationDTO, List items) {
        if (navigationDTO.getSubItems() != null) {
            Iterator iter = navigationDTO.getSubItems().iterator();
            while (iter.hasNext()) {
                ExpertDisplayInfoDTO.NavigationDTO childDTO = (ExpertDisplayInfoDTO.NavigationDTO)iter.next();
                this.addSubItems(childDTO, items);
            }
        } else {
            items.add(navigationDTO.getAccessKey());
        }
    }

    public List getPersistenceReadDTOs() {
        return this.engine.getPersistenceReadDTOs();
    }
}

