/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.bd.cd;

import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class UndoRedoSnapshot {
    private static final Logger log = Logger.getLogger((Class)UndoRedoSnapshot.class);
    private UndoRedoStack undoStack;
    private UndoRedoStack redoStack;
    private UndoRedoStack snapshots;
    private List listeners = new ArrayList();

    public UndoRedoSnapshot() {
        this.undoStack = new UndoRedoStack(100);
        this.redoStack = new UndoRedoStack(100);
        this.snapshots = new UndoRedoStack(100);
    }

    public void addUndoRedoStateListener(UndoRedoStateListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeUndoRedoStateListener(UndoRedoStateListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    private void notifyListeners() {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            UndoRedoStateListener listener = (UndoRedoStateListener)iter.next();
            listener.undoRedoStateChanged(this.isUndoable(), this.isRedoable());
        }
    }

    public void update(Map undoMap, String dmk) {
        if (undoMap.size() > 0) {
            this.undoStack.push(new UndoRedoDTO(undoMap, dmk));
            this.redoStack.clear();
        }
        this.notifyListeners();
    }

    public boolean isUndoable() {
        return !this.undoStack.isEmpty();
    }

    public boolean isRedoable() {
        return !this.redoStack.isEmpty();
    }

    public void clear() {
        this.redoStack.clear();
        this.undoStack.clear();
        this.snapshots.clear();
        this.notifyListeners();
    }

    public UndoRedoSnapshotDTO undo(Map dataModel, String dmk) {
        if (this.undoStack.isEmpty()) {
            return null;
        }
        UndoRedoSnapshotDTO undoInfo = (UndoRedoSnapshotDTO)this.undoStack.pop();
        if (undoInfo instanceof CreateSnapshotDTO) {
            if (!this.snapshots.isEmpty()) {
                this.snapshots.pop();
            } else {
                log.debug((Object)"Snapshot Stack is empty!");
            }
            this.redoStack.push(new CreateSnapshotDTO(dataModel, dmk));
        }
        if (undoInfo instanceof BacktoSnapshotDTO) {
            BacktoSnapshotDTO bsDTO = new BacktoSnapshotDTO(dataModel, dmk);
            this.snapshots.push(bsDTO);
            this.redoStack.push(bsDTO);
        }
        if (undoInfo instanceof UndoRedoDTO) {
            Map undoMap = undoInfo.getDataModel();
            HashMap redoMap = new HashMap();
            Iterator iter = undoMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry me = iter.next();
                Object key = me.getKey();
                Object value = me.getValue();
                Object oldValue = dataModel.get(key);
                if (value instanceof ModelItemDTO) {
                    dataModel.put(key, value);
                } else {
                    dataModel.remove(key);
                }
                redoMap.put(key, oldValue);
            }
            this.redoStack.push(new UndoRedoDTO(redoMap, dmk));
            undoInfo = new UndoRedoDTO(dataModel, undoInfo.getDmk());
        }
        this.notifyListeners();
        return undoInfo;
    }

    public UndoRedoSnapshotDTO redo(Map dataModel, String dmk) {
        if (this.redoStack.isEmpty()) {
            return null;
        }
        UndoRedoSnapshotDTO redoInfo = (UndoRedoSnapshotDTO)this.redoStack.pop();
        if (redoInfo instanceof CreateSnapshotDTO) {
            CreateSnapshotDTO csDTO = new CreateSnapshotDTO(dataModel, dmk);
            this.snapshots.push(csDTO);
            this.undoStack.push(csDTO);
        }
        if (redoInfo instanceof BacktoSnapshotDTO) {
            if (!this.snapshots.isEmpty()) {
                this.snapshots.pop();
            } else {
                log.debug((Object)"Snapshot Stack is empty!");
            }
            this.redoStack.push(new BacktoSnapshotDTO(dataModel, dmk));
        }
        if (redoInfo instanceof UndoRedoDTO) {
            Map redoMap = redoInfo.getDataModel();
            HashMap undoMap = new HashMap();
            Iterator iter = redoMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry me = iter.next();
                Object key = me.getKey();
                Object value = me.getValue();
                Object newValue = dataModel.get(key);
                if (value instanceof ModelItemDTO) {
                    dataModel.put(key, value);
                } else {
                    dataModel.remove(key);
                }
                undoMap.put(key, newValue);
            }
            this.undoStack.push(new UndoRedoDTO(undoMap, dmk));
            redoInfo = new UndoRedoDTO(dataModel, redoInfo.getDmk());
        }
        this.notifyListeners();
        return redoInfo;
    }

    public void createModelSnapshot(Map dataModel, String dmk) {
        this.snapshots.push(new CreateSnapshotDTO(new HashMap(dataModel), dmk));
        this.undoStack.push(new CreateSnapshotDTO(dataModel, dmk));
        this.redoStack.clear();
        this.notifyListeners();
    }

    public UndoRedoSnapshotDTO backtoModelSnapshot(Map dataModel, String dmk) {
        if (this.snapshots.isEmpty()) {
            return null;
        }
        UndoRedoSnapshotDTO ursDTO = (UndoRedoSnapshotDTO)this.snapshots.pop();
        this.undoStack.push(new BacktoSnapshotDTO(dataModel, dmk));
        this.redoStack.clear();
        this.notifyListeners();
        return ursDTO;
    }

    private static class UndoRedoStack {
        private LinkedList list = new LinkedList();
        private int maxSize;

        public UndoRedoStack(int maxSize) {
            this.maxSize = maxSize;
        }

        public void push(Object obj) {
            this.list.addLast(obj);
            if (this.list.size() > this.maxSize) {
                this.list.removeFirst();
            }
        }

        public Object pop() {
            if (this.isEmpty()) {
                return null;
            }
            return this.list.removeLast();
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public void clear() {
            this.list.clear();
        }
    }

    public static interface UndoRedoStateListener {
        public void undoRedoStateChanged(boolean var1, boolean var2);
    }

    private static class BacktoSnapshotDTO
    extends UndoRedoSnapshotDTO {
        public BacktoSnapshotDTO(Map dataModel, String dmk) {
            super(dataModel, dmk);
        }
    }

    private static class CreateSnapshotDTO
    extends UndoRedoSnapshotDTO {
        public CreateSnapshotDTO(Map dataModel, String dmk) {
            super(dataModel, dmk);
        }
    }

    private static class UndoRedoDTO
    extends UndoRedoSnapshotDTO {
        public UndoRedoDTO(Map dataModel, String dmk) {
            super(dataModel, dmk);
        }
    }

    public static class UndoRedoSnapshotDTO {
        private Map dataModel;
        private String dmk;

        public UndoRedoSnapshotDTO(Map dataModel, String dmk) {
            this.dataModel = dataModel;
            this.dmk = dmk;
        }

        public Map getDataModel() {
            return this.dataModel;
        }

        public String getDmk() {
            return this.dmk;
        }
    }
}

