/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.integration.util;

import ch.dvbern.tax.common.integration.util.ConfigHelper;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.apache.log4j.Logger;

public class MailHelper {
    private static final Logger log = Logger.getLogger((Class)MailHelper.class);
    public static final String MAIL_TRANSPORT_PROTOCOL_PROPERTY_KEY = "mail.transport.protocol";
    public static final String MAIL_SMTP_HOST_PROPERTY_KEY = "mail.smtp.host";
    public static final String MAIL_SMTP_PORT_PROPERTY_KEY = "mail.smtp.port";
    public static final String MAIL_SMTP_USER_PROPERTY_KEY = "mail.smtp.user";
    public static final String MAIL_SMTP_PASSWORD_PROPERTY_KEY = "mail.smtp.password";
    private String protocol;
    private String host;
    private String port;
    private String user;
    private String password;

    public MailHelper() {
        this.protocol = ConfigHelper.getStringEntry(MAIL_TRANSPORT_PROTOCOL_PROPERTY_KEY);
        this.host = ConfigHelper.getStringEntry(MAIL_SMTP_HOST_PROPERTY_KEY);
        this.port = ConfigHelper.getStringEntry(MAIL_SMTP_PORT_PROPERTY_KEY);
        this.user = ConfigHelper.getStringEntry(MAIL_SMTP_USER_PROPERTY_KEY);
        this.password = ConfigHelper.getStringEntry(MAIL_SMTP_PASSWORD_PROPERTY_KEY);
    }

    public MailHelper(String protocol, String host, String port) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
    }

    public MailHelper(String protocol, String host, String port, String user, String password) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
    }

    public int sendMail(String fromAddress, String toAddress, String subject, String content) {
        return this.sendMail(fromAddress, toAddress, null, null, subject, content);
    }

    public int sendMail(String fromAddress, String toAddress, String ccAddress, String bccAddress, String subject, String content) {
        try {
            Session session = this.createSession();
            if (session == null) {
                log.warn((Object)"could not create session to send mail");
                return 2;
            }
            MimeMessage msg = new MimeMessage(session);
            if (fromAddress != null) {
                msg.setFrom((Address)new InternetAddress(fromAddress));
            } else {
                msg.setFrom();
            }
            try {
                msg.addRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)toAddress, (boolean)false));
            }
            catch (AddressException ae) {
                log.warn((Object)"mail recipients could not be set", (Throwable)ae);
                return 2;
            }
            if (ccAddress != null) {
                msg.addRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)ccAddress, (boolean)false));
            }
            if (bccAddress != null) {
                msg.addRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)bccAddress, (boolean)false));
            }
            msg.setSubject(MailHelper.encodeMailString(subject));
            msg.setContent((Object)content, "text/plain;charset=iso-8859-1");
            msg.setSentDate(new Date());
            try {
                Transport.send((Message)msg);
                return 1;
            }
            catch (SendFailedException sfe) {
                log.warn((Object)("Invalid receiver address specified '" + sfe.getInvalidAddresses() + "'"), (Throwable)sfe);
                return 2;
            }
        }
        catch (MessagingException ex) {
            log.warn((Object)"error in sending mail", (Throwable)ex);
            return 2;
        }
    }

    private Session createSession() {
        Session session;
        Properties props = new Properties();
        if (this.protocol != null) {
            props.put(MAIL_TRANSPORT_PROTOCOL_PROPERTY_KEY, this.protocol);
        }
        if (this.host == null) {
            log.warn((Object)"Unable to send mail, because mail host not specified.");
            return null;
        }
        props.put(MAIL_SMTP_HOST_PROPERTY_KEY, this.host);
        if (this.port != null) {
            props.put(MAIL_SMTP_PORT_PROPERTY_KEY, this.port);
        }
        if (this.user != null) {
            props.put(MAIL_SMTP_USER_PROPERTY_KEY, this.user);
        }
        if (this.password != null) {
            props.put(MAIL_SMTP_PASSWORD_PROPERTY_KEY, this.password);
        }
        if ((session = Session.getInstance((Properties)props, null)) == null) {
            log.warn((Object)"Unable to send mail, because of invalid session object.");
            return null;
        }
        session.setDebug(false);
        return session;
    }

    private static String encodeMailString(String text) {
        if (text != null) {
            try {
                text = MimeUtility.encodeText((String)text, (String)"iso-8859-1", null);
            }
            catch (UnsupportedEncodingException uex) {
                log.warn((Object)"could not encode mail string", (Throwable)uex);
            }
        }
        return text;
    }
}

