/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.integration.util;

import ch.dvbern.tax.common.integration.util.SQLCall;
import ch.dvbern.tax.common.integration.util.failure.StorageException;
import com.jamonapi.proxy.MonProxyFactory;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public abstract class DAOBase {
    private static final Logger log = Logger.getLogger((Class)DAOBase.class);
    protected DataSource ds;
    protected Connection con;

    public DAOBase(DataSource ds) {
        this.ds = ds;
    }

    public DAOBase(Connection con) {
        this.con = con;
    }

    protected SQLCall getSQLCall(String statement) throws StorageException {
        try {
            if (this.con != null) {
                return new SQLCall(this.con, statement);
            }
            this.con = MonProxyFactory.monitor((Connection)this.ds.getConnection());
            return new SQLCall(this.con, statement);
        }
        catch (SQLException e) {
            throw new StorageException("SQL Exception while fetching the database connection", e);
        }
    }

    protected Connection getConnection() {
        if (this.con != null) {
            return this.con;
        }
        try {
            return MonProxyFactory.monitor((Connection)this.ds.getConnection());
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void closeConnection() {
        try {
            if (this.con != null && this.ds != null) {
                this.con.close();
                this.con = null;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    protected void finalize() {
        if (this.con != null) {
            log.warn((Object)(this + ": Closing a connection for you. Please ensure to close them yourself!"));
            this.closeConnection();
        }
    }

    protected DataSource getDataSource() {
        return this.ds;
    }
}

