/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay.items;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.ColDef;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Header;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Help;
import ch.dvbern.tax.common.engine.wizarddisplay.items.LabelAddOn;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Row;
import ch.dvbern.tax.common.engine.wizarddisplay.items.RowIterator;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Section
extends WizardDisplayModelItem {
    private List coldefs;
    private List headers;
    private Help help;
    private List rows;
    private String stateKey;
    private Boolean readonly;
    private String readonlyItemKey;
    private String viewId;
    private String dmkDossier;
    private String header;
    private List headerAddOns;
    private String styleClass;
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$wizarddisplay$items$Section;

    public Section(List coldefs, List headers, Help help, List rows, String stateKey, String readonly, String viewId, String dmkDossier, String header, List headerAddOns, String styleClass) {
        this.coldefs = coldefs;
        this.headers = headers;
        this.help = help;
        this.rows = rows;
        this.stateKey = stateKey;
        this.viewId = viewId;
        this.header = header;
        this.headerAddOns = headerAddOns;
        if (readonly == null || readonly.length() == 0 || readonly.equalsIgnoreCase("false")) {
            this.readonly = Boolean.FALSE;
        } else if (readonly.equalsIgnoreCase("true")) {
            this.readonly = Boolean.TRUE;
        } else {
            this.readonlyItemKey = readonly;
        }
        this.dmkDossier = dmkDossier;
        this.styleClass = styleClass;
        this.initializeParent();
    }

    public List getChildren() {
        ArrayList<Help> children = new ArrayList<Help>();
        if (this.coldefs != null) {
            children.addAll(this.coldefs);
        }
        if (this.headers != null) {
            children.addAll(this.headers);
        }
        if (this.help != null) {
            children.add(this.help);
        }
        if (this.rows != null) {
            children.addAll(this.rows);
        }
        if (children.size() == 0) {
            children = null;
        }
        return children;
    }

    public List getColdefs() {
        return this.coldefs;
    }

    public List getHeaders() {
        return this.headers;
    }

    public String getHeader() {
        return this.header;
    }

    public List getRows() {
        return this.rows;
    }

    public void additionalInitializeWizardDisplayModel(Map logicModelItems) throws InvalidModelException {
        if (this.stateKey != null && logicModelItems.get(this.stateKey) == null) {
            throw new InvalidModelException("invalid state-reference in Section " + this.getParent());
        }
        if (this.readonlyItemKey != null && logicModelItems.get(this.readonlyItemKey) == null) {
            throw new InvalidModelException("invalid readonly-reference in Section " + this.getParent() + " : " + this.readonlyItemKey);
        }
    }

    public Object getFormInfo(WizardDisplayModelItem.ProtectedMap dataModel, String key) {
        ModelItemDTO roMi;
        ModelItemDTO stateMi;
        Object formInfo;
        ArrayList<Object> headerAddOnDTOs = new ArrayList<Object>();
        if (this.headerAddOns != null) {
            Iterator iter = this.headerAddOns.iterator();
            while (iter.hasNext()) {
                LabelAddOn element = (LabelAddOn)iter.next();
                Object formInfo2 = element.getFormInfo(dataModel, key);
                if (formInfo2 == null) continue;
                headerAddOnDTOs.add(formInfo2);
            }
        }
        if (headerAddOnDTOs.size() == 0) {
            headerAddOnDTOs = null;
        }
        ArrayList<Object> coldefsDTO = null;
        if (this.getColdefs() != null) {
            coldefsDTO = new ArrayList<Object>();
            Iterator iter = this.getColdefs().iterator();
            while (iter.hasNext()) {
                ColDef element = (ColDef)iter.next();
                Object formInfo3 = element.getFormInfo(dataModel, key);
                if (formInfo3 == null || ((WizardDisplayInfoDTO.ColDefItemDTO)formInfo3).getState() == 12) continue;
                coldefsDTO.add(formInfo3);
            }
            if (coldefsDTO.size() == 0) {
                coldefsDTO = null;
            }
        }
        ArrayList<Object> headerDTOs = null;
        if (this.getHeaders() != null) {
            headerDTOs = new ArrayList<Object>();
            Iterator iter = this.getHeaders().iterator();
            while (iter.hasNext()) {
                Header element = (Header)iter.next();
                formInfo = element.getFormInfo(dataModel, key);
                if (formInfo == null) continue;
                headerDTOs.add(formInfo);
            }
            if (headerDTOs.size() == 0) {
                headerDTOs = null;
            }
        }
        ArrayList<Object> rowDTOs = null;
        if (this.getRows() != null) {
            rowDTOs = new ArrayList<Object>();
            Iterator iter = this.getRows().iterator();
            while (iter.hasNext()) {
                Object formInfo4;
                Object element = iter.next();
                if (element instanceof Row && (formInfo4 = ((Row)element).getFormInfo(dataModel, key)) != null) {
                    rowDTOs.add(formInfo4);
                }
                if (!(element instanceof RowIterator) || !((formInfo4 = ((RowIterator)element).getFormInfo(dataModel, key)) instanceof List)) continue;
                rowDTOs.addAll((List)formInfo4);
            }
            if (rowDTOs.size() == 0) {
                rowDTOs = null;
            }
        }
        WizardDisplayInfoDTO.HelpItemDTO helpDTO = null;
        if (this.help != null && (formInfo = this.help.getFormInfo(dataModel, key)) != null) {
            helpDTO = (WizardDisplayInfoDTO.HelpItemDTO)formInfo;
        }
        WizardDisplayInfoDTO.SectionItemDTO result = null;
        int state = dataModel.getWithoutTouch(key).getState();
        if (this.stateKey != null && (state = (stateMi = dataModel.get(EngineUtil.mergeModelKey(this.stateKey, key))) == null ? 12 : stateMi.getState()) == 12) {
            return null;
        }
        boolean ro = false;
        if (this.readonly != null) {
            ro = this.readonly;
        } else if (this.readonlyItemKey != null && (roMi = dataModel.get(EngineUtil.mergeModelKey(this.readonlyItemKey, key))) != null && roMi.getValue() != null) {
            Object roValue = roMi.getValue();
            ro = roValue instanceof Boolean ? ((Boolean)roValue).booleanValue() : Boolean.valueOf(roValue.toString()).booleanValue();
        }
        result = new WizardDisplayInfoDTO.SectionItemDTO(this.getUniqueItemIdentifier(), state, coldefsDTO, headerDTOs, helpDTO, rowDTOs, ro, this.viewId, this.dmkDossier, this.header, headerAddOnDTOs, this.styleClass);
        return result;
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<Object> coldefs = elements.size() > 0 ? new ArrayList<Object>() : null;
            ArrayList<Object> headers = elements.size() > 0 ? new ArrayList<Object>() : null;
            ArrayList<Object> rows = elements.size() > 0 ? new ArrayList<Object>() : null;
            ArrayList<Object> labelAddOns = new ArrayList<Object>();
            Help help = null;
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                Element subElement = (Element)i.next();
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof ColDef) {
                        coldefs.add(ref);
                        continue;
                    }
                    if (ref instanceof LabelAddOn) {
                        labelAddOns.add(ref);
                        continue;
                    }
                    if (ref instanceof Header) {
                        headers.add(ref);
                        continue;
                    }
                    if (ref instanceof Help) {
                        help = (Help)ref;
                        continue;
                    }
                    if (ref instanceof Row || ref instanceof RowIterator) {
                        rows.add(ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), pnre);
                }
            }
            if (labelAddOns.size() == 0 && element.getAttribute("header-add-on") != null) {
                labelAddOns.add(new LabelAddOn(element.getAttributeValue("header-add-on")));
            }
            if (labelAddOns.size() == 0) {
                labelAddOns = null;
            }
            if (element.getAttribute("help") != null) {
                help = new Help(element.getAttributeValue("help"));
            }
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$wizarddisplay$items$Section == null ? (class$ch$dvbern$tax$common$engine$wizarddisplay$items$Section = Section.class$("ch.dvbern.tax.common.engine.wizarddisplay.items.Section")) : class$ch$dvbern$tax$common$engine$wizarddisplay$items$Section, new Section(coldefs, headers, help, rows, element.getAttributeValue("state"), element.getAttributeValue("readonly"), element.getAttributeValue("viewId"), element.getAttributeValue("dmkDossier"), element.getAttributeValue("header"), labelAddOns, element.getAttributeValue("styleClass")));
        }
    }
}

