/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay.items;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Button;
import ch.dvbern.tax.common.engine.wizarddisplay.items.ColDef;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Help;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Item;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Label;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Link;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Section;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Table;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class Row
extends WizardDisplayModelItem {
    private Help help;
    private List cols;
    private List stateKeyList;
    private List invisibleIfTrueList;
    private List invisibleIfFalseList;
    private String viewId;
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$wizarddisplay$items$Row;

    public Row(Help help, List cols, String stateKeys, String invisibleIfTrueKey, String invisibleIfFalseKey, String viewId) {
        this.help = help;
        this.cols = cols;
        if (stateKeys != null && stateKeys.length() > 0) {
            this.stateKeyList = new ArrayList();
            StringTokenizer st = new StringTokenizer(stateKeys, ",");
            while (st.hasMoreTokens()) {
                this.stateKeyList.add(st.nextToken().trim());
            }
        }
        if (invisibleIfTrueKey != null) {
            this.invisibleIfTrueList = new ArrayList();
            StringTokenizer invisibleIfTrueTokenizer = new StringTokenizer(invisibleIfTrueKey, ",");
            while (invisibleIfTrueTokenizer.hasMoreTokens()) {
                this.invisibleIfTrueList.add(invisibleIfTrueTokenizer.nextToken().trim());
            }
        }
        if (invisibleIfFalseKey != null) {
            this.invisibleIfFalseList = new ArrayList();
            StringTokenizer invisibleIfFalseTokenizer = new StringTokenizer(invisibleIfFalseKey, ",");
            while (invisibleIfFalseTokenizer.hasMoreTokens()) {
                this.invisibleIfFalseList.add(invisibleIfFalseTokenizer.nextToken().trim());
            }
        }
        this.viewId = viewId;
        this.initializeParent();
    }

    public List getCols() {
        return this.cols;
    }

    public List getChildren() {
        ArrayList<Help> result = new ArrayList<Help>();
        if (this.help != null) {
            result.add(this.help);
        }
        if (this.cols != null) {
            result.addAll(this.cols);
        }
        if (result.size() == 0) {
            result = null;
        }
        return result;
    }

    public void additionalInitializeWizardDisplayModel(Map logicModelItems) throws InvalidModelException {
        Object key;
        if (this.stateKeyList != null) {
            Iterator i = this.stateKeyList.iterator();
            while (i.hasNext()) {
                key = i.next();
                if (logicModelItems.get(key) != null) continue;
                throw new InvalidModelException("invalid state-reference in Row (key=" + key + ")");
            }
        }
        if (this.invisibleIfTrueList != null) {
            Iterator invisibleIfTrueIterator = this.invisibleIfTrueList.iterator();
            while (invisibleIfTrueIterator.hasNext()) {
                key = (String)invisibleIfTrueIterator.next();
                if (logicModelItems.get(key) != null) continue;
                throw new InvalidModelException("invalid invisibleIfTrueKey-reference in Row (key=" + key + ")");
            }
        }
        if (this.invisibleIfFalseList != null) {
            Iterator invisibleIfFalseIterator = this.invisibleIfFalseList.iterator();
            while (invisibleIfFalseIterator.hasNext()) {
                key = (String)invisibleIfFalseIterator.next();
                if (logicModelItems.get(key) != null) continue;
                throw new InvalidModelException("invalid invisibleIfFalseKey-reference in Row (key=" + key + ")");
            }
        }
    }

    public Object getFormInfo(WizardDisplayModelItem.ProtectedMap dataModel, String key) {
        ModelItemDTO miDTO;
        Object formInfo;
        if (this.getChildren() == null) {
            return new WizardDisplayInfoDTO.RowItemDTO(new Long(this.getUniqueItemIdentifier()), 1, null, null, null, false, this.viewId);
        }
        int[] coldefs = new int[((Section)this.getParent()).getColdefs().size()];
        for (int i = 0; i < ((Section)this.getParent()).getColdefs().size(); ++i) {
            ColDef element = (ColDef)((Section)this.getParent()).getColdefs().get(i);
            coldefs[i] = element.getFormInfo(dataModel, key) == null ? 0 : 1;
        }
        WizardDisplayInfoDTO.HelpItemDTO helpDTO = null;
        if (this.help != null && (formInfo = this.help.getFormInfo(dataModel, key)) != null) {
            helpDTO = (WizardDisplayInfoDTO.HelpItemDTO)formInfo;
        }
        int state = 1;
        if (this.stateKeyList != null) {
            Iterator i = this.stateKeyList.iterator();
            while (i.hasNext()) {
                ModelItemDTO miDTO2 = dataModel.get(EngineUtil.mergeModelKey(i.next().toString(), key));
                if (miDTO2 == null) {
                    state = 12;
                    continue;
                }
                if (!miDTO2.hasMoreImportantState(state)) continue;
                state = miDTO2.getState();
            }
        }
        if (this.invisibleIfTrueList != null && !this.invisibleIfTrueList.isEmpty()) {
            Iterator invisibleIfTrueIterator = this.invisibleIfTrueList.iterator();
            while (invisibleIfTrueIterator.hasNext()) {
                String invisibleIfTrueKey = (String)invisibleIfTrueIterator.next();
                miDTO = dataModel.get(EngineUtil.mergeModelKey(invisibleIfTrueKey, key));
                if (miDTO == null || miDTO.getValue() == null) {
                    state = 12;
                    continue;
                }
                if (miDTO.getValue() instanceof Number && ((Number)miDTO.getValue()).intValue() != 0) {
                    state = 12;
                }
                if (!(miDTO.getValue() instanceof Boolean) || !((Boolean)miDTO.getValue()).booleanValue()) continue;
                state = 12;
            }
        }
        if (this.invisibleIfFalseList != null && !this.invisibleIfFalseList.isEmpty()) {
            Iterator invisibleIfFalseIterator = this.invisibleIfFalseList.iterator();
            while (invisibleIfFalseIterator.hasNext()) {
                String invisibleIfFalseKey = (String)invisibleIfFalseIterator.next();
                miDTO = dataModel.get(EngineUtil.mergeModelKey(invisibleIfFalseKey, key));
                if (miDTO == null || miDTO.getValue() == null) {
                    state = 12;
                    continue;
                }
                if (miDTO.getValue() instanceof Number && ((Number)miDTO.getValue()).intValue() == 0) {
                    state = 12;
                }
                if (!(miDTO.getValue() instanceof Boolean) || ((Boolean)miDTO.getValue()).booleanValue()) continue;
                state = 12;
            }
        }
        ArrayList<Object> colsDTO = new ArrayList<Object>();
        for (int i = 0; i < this.cols.size(); ++i) {
            Item item;
            ModelItemDTO miDTO3;
            WizardDisplayModelItem element;
            Object formInfo2;
            if (coldefs[i] != 1 || (formInfo2 = (element = (WizardDisplayModelItem)this.cols.get(i)).getFormInfo(dataModel, key)) == null) continue;
            colsDTO.add(formInfo2);
            if (!(element instanceof Item) || (miDTO3 = dataModel.get(EngineUtil.mergeModelKey((item = (Item)element).getValueKey(), key))) == null || !ModelItemDTO.isPropagatableState(miDTO3.getState()) || !miDTO3.hasMoreImportantState(state)) continue;
            state = miDTO3.getState();
        }
        return new WizardDisplayInfoDTO.RowItemDTO(new Long(this.getUniqueItemIdentifier()), state, key, colsDTO, helpDTO, false, this.viewId);
    }

    protected void print() {
        System.out.println("Row - state=" + this.stateKeyList);
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<Object> childItems = elements.size() > 0 ? new ArrayList<Object>() : null;
            Help help = null;
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                Element subElement = (Element)i.next();
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof Help) {
                        help = (Help)ref;
                        continue;
                    }
                    if (ref instanceof Label || ref instanceof Item || ref instanceof Button || ref instanceof Link || ref instanceof Table) {
                        childItems.add(ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), pnre);
                }
            }
            if (element.getAttribute("help") != null) {
                help = new Help(element.getAttributeValue("help"));
            }
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$wizarddisplay$items$Row == null ? (class$ch$dvbern$tax$common$engine$wizarddisplay$items$Row = Row.class$("ch.dvbern.tax.common.engine.wizarddisplay.items.Row")) : class$ch$dvbern$tax$common$engine$wizarddisplay$items$Row, new Row(help, childItems, element.getAttributeValue("state"), element.getAttributeValue("invisible-if-true"), element.getAttributeValue("invisible-if-false"), element.getAttributeValue("viewId")));
        }
    }
}

