/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay.items;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.ColDef;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Form;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Item;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Label;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Row;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Section;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.util.List;
import org.apache.log4j.Logger;

public class Link
extends WizardDisplayModelItem {
    private static final Logger logger = Logger.getLogger((Class)Link.class);
    private int colspan;
    private String uri;
    private String name;
    private String target;
    private String styleClass;
    private boolean transparentIfView;

    public Link(String uri, String name, String target, int colspan, boolean transparentIfView, String styleClass) {
        this.initializeParent();
        this.uri = uri;
        this.name = name;
        this.target = target;
        this.colspan = colspan;
        this.transparentIfView = transparentIfView;
        this.styleClass = styleClass;
        logger.debug((Object)("LINK: uri=" + uri + ", label=" + name + ", target=" + target + ", styleClass=" + styleClass));
    }

    public List getChildren() {
        return null;
    }

    public int getColspan() {
        return this.colspan;
    }

    public Object getFormInfo(WizardDisplayModelItem.ProtectedMap dataModel, String key) {
        if (this.getParent() instanceof Form) {
            return new WizardDisplayInfoDTO.LinkItemDTO(this.getUniqueItemIdentifier(), this.uri, this.name, this.target, this.colspan, this.transparentIfView, this.styleClass);
        }
        int index = 0;
        for (int i = 0; i < ((Row)this.getParent()).getCols().size(); ++i) {
            WizardDisplayModelItem element = (WizardDisplayModelItem)((Row)this.getParent()).getCols().get(i);
            if (element == this) {
                index += i;
                break;
            }
            if (element instanceof Label && ((Label)element).getColspan() > 1) {
                index = index + ((Label)element).getColspan() - 1;
            }
            if (element instanceof Link && ((Link)element).getColspan() > 1) {
                index = index + ((Link)element).getColspan() - 1;
            }
            if (!(element instanceof Item) || ((Item)element).getColspan() <= 1) continue;
            index = index + ((Item)element).getColspan() - 1;
        }
        int corrColspan = this.colspan;
        for (int i = 0; i < this.colspan; ++i) {
            ColDef coldef = (ColDef)((Section)this.getParent().getParent()).getColdefs().get(index + i);
            WizardDisplayInfoDTO.ColDefItemDTO cdiDTO = (WizardDisplayInfoDTO.ColDefItemDTO)coldef.getFormInfo(dataModel, key);
            if (cdiDTO.getState() != 12) continue;
            --corrColspan;
        }
        if (corrColspan <= 0) {
            return null;
        }
        return new WizardDisplayInfoDTO.LinkItemDTO(this.getUniqueItemIdentifier(), this.uri, this.name, this.target, corrColspan, this.transparentIfView, this.styleClass);
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            if (elements.size() > 0) {
                throw new ElementParserException("invalid child type for " + element);
            }
            String uri = element.getAttributeValue("URI");
            if (uri == null || uri.length() == 0) {
                throw new ElementParserException("missing URI argument for " + element);
            }
            int colspan = element.getAttribute("colspan") != null ? Integer.parseInt(element.getAttributeValue("colspan")) : 1;
            boolean transparentIfEdit = false;
            if (element.getAttribute("transparent-if-view") != null) {
                transparentIfEdit = Boolean.valueOf(element.getAttributeValue("transparent-if-view"));
            }
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$wizarddisplay$items$Link == null ? (class$ch$dvbern$tax$common$engine$wizarddisplay$items$Link = Link.class$("ch.dvbern.tax.common.engine.wizarddisplay.items.Link")) : class$ch$dvbern$tax$common$engine$wizarddisplay$items$Link, new Link(uri, element.getAttributeValue("name"), element.getAttributeValue("target"), colspan, transparentIfEdit, element.getAttributeValue("styleClass")));
        }
    }
}

