/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay.items;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Button;
import ch.dvbern.tax.common.engine.wizarddisplay.items.ColDef;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Form;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Item;
import ch.dvbern.tax.common.engine.wizarddisplay.items.LabelAddOn;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Row;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Section;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.util.ColorConstants;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class Label
extends WizardDisplayModelItem {
    private int colspan;
    private String name;
    private List stateKeyList;
    private String align;
    private String style;
    private String styleClass;
    private List labelAddOns;
    private String fgColor;
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$wizarddisplay$items$Label;

    public Label(String name, int colspan, String stateKeys, String align, String style, String styleClass, List labelAddOns, String fgColor) {
        this.name = name;
        this.colspan = colspan;
        if (stateKeys != null && stateKeys.length() > 0) {
            this.stateKeyList = new ArrayList();
            StringTokenizer st = new StringTokenizer(stateKeys, ",");
            while (st.hasMoreTokens()) {
                this.stateKeyList.add(st.nextToken().trim());
            }
        }
        this.align = align;
        this.style = style;
        this.styleClass = styleClass;
        this.labelAddOns = labelAddOns;
        this.fgColor = fgColor;
        this.initializeParent();
    }

    public List getChildren() {
        return null;
    }

    public int getColspan() {
        return this.colspan;
    }

    public void additionalInitializeWizardDisplayModel(Map logicModelItems) throws InvalidModelException {
        if (this.stateKeyList != null) {
            Iterator i = this.stateKeyList.iterator();
            while (i.hasNext()) {
                Object key = i.next();
                if (logicModelItems.get(key) != null) continue;
                throw new InvalidModelException("invalid state-reference in label (key=" + key + ")");
            }
        }
        if (this.labelAddOns != null) {
            Iterator iter = this.labelAddOns.iterator();
            while (iter.hasNext()) {
                LabelAddOn element = (LabelAddOn)iter.next();
                element.additionalInitializeWizardDisplayModel(logicModelItems);
            }
        }
    }

    public Object getFormInfo(WizardDisplayModelItem.ProtectedMap dataModel, String key) {
        ArrayList<Object> labelAddOnDTOs = new ArrayList<Object>();
        if (this.labelAddOns != null) {
            Iterator iter = this.labelAddOns.iterator();
            while (iter.hasNext()) {
                LabelAddOn element = (LabelAddOn)iter.next();
                Object formInfo = element.getFormInfo(dataModel, key);
                if (formInfo == null) continue;
                labelAddOnDTOs.add(formInfo);
            }
        }
        if (labelAddOnDTOs.size() == 0) {
            labelAddOnDTOs = null;
        }
        if (this.getParent() instanceof Form) {
            int state = 1;
            if (this.stateKeyList != null) {
                Iterator i = this.stateKeyList.iterator();
                while (i.hasNext()) {
                    ModelItemDTO miDTO = dataModel.get(EngineUtil.mergeModelKey(i.next().toString(), key));
                    if (miDTO == null) {
                        state = 12;
                        continue;
                    }
                    if (!miDTO.hasMoreImportantState(state)) continue;
                    state = miDTO.getState();
                }
            }
            return new WizardDisplayInfoDTO.LabelItemDTO(this.getUniqueItemIdentifier(), state, this.name, this.colspan, this.align, this.style, this.styleClass, labelAddOnDTOs, this.fgColor);
        }
        int index = 0;
        for (int i = 0; i < ((Row)this.getParent()).getCols().size(); ++i) {
            WizardDisplayModelItem element = (WizardDisplayModelItem)((Row)this.getParent()).getCols().get(i);
            if (element == this) {
                index += i;
                break;
            }
            if (element instanceof Label && ((Label)element).getColspan() > 1) {
                index = index + ((Label)element).getColspan() - 1;
            }
            if (element instanceof Button && ((Button)element).getColspan() > 1) {
                index = index + ((Button)element).getColspan() - 1;
            }
            if (!(element instanceof Item) || ((Item)element).getColspan() <= 1) continue;
            index = index + ((Item)element).getColspan() - 1;
        }
        int state = 1;
        if (this.stateKeyList != null) {
            Iterator i = this.stateKeyList.iterator();
            while (i.hasNext()) {
                ModelItemDTO miDTO = dataModel.get(EngineUtil.mergeModelKey(i.next().toString(), key));
                if (miDTO == null) continue;
                switch (miDTO.getState()) {
                    case 12: {
                        state = 11;
                        break;
                    }
                    case 11: {
                        state = 11;
                        break;
                    }
                }
            }
        }
        int width = 0;
        boolean isWidthUndefined = false;
        int corrColspan = this.colspan;
        int colDefState = 11;
        block12: for (int i = 0; i < this.colspan; ++i) {
            ColDef coldef = (ColDef)((Section)this.getParent().getParent()).getColdefs().get(index + i);
            WizardDisplayInfoDTO.ColDefItemDTO cdiDTO = (WizardDisplayInfoDTO.ColDefItemDTO)coldef.getFormInfo(dataModel, key);
            if (12 != cdiDTO.getState()) {
                if (!"*".equals(cdiDTO.getWidth()) && !isWidthUndefined) {
                    width += Integer.parseInt(cdiDTO.getWidth());
                } else {
                    width = 0;
                    isWidthUndefined = true;
                }
            }
            switch (cdiDTO.getState()) {
                case 12: {
                    --corrColspan;
                    continue block12;
                }
                case 11: {
                    continue block12;
                }
                default: {
                    colDefState = 1;
                }
            }
        }
        if (colDefState == 11) {
            state = colDefState;
        }
        if (corrColspan <= 0) {
            return null;
        }
        return new WizardDisplayInfoDTO.LabelItemDTO(this.getUniqueItemIdentifier(), state, this.name, corrColspan, width, this.align, this.style, this.styleClass, labelAddOnDTOs, this.fgColor);
    }

    protected void print() {
        System.out.println("Label - name=" + this.name);
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            String fgColor;
            List elements = element.getChildren();
            ArrayList<Object> labelAddOns = new ArrayList<Object>();
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                Element subElement = (Element)i.next();
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof LabelAddOn) {
                        labelAddOns.add(ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), pnre);
                }
            }
            if (labelAddOns.size() == 0 && element.getAttribute("label-add-on") != null) {
                labelAddOns.add(new LabelAddOn(element.getAttributeValue("label-add-on")));
            }
            if (labelAddOns.size() == 0) {
                labelAddOns = null;
            }
            String align = null;
            if (element.getAttribute("align") != null) {
                align = element.getAttributeValue("align");
            }
            if ((fgColor = element.getAttributeValue("fgColor")) != null && ColorConstants.getColors().get(fgColor) == null) {
                throw new ElementParserException("invalid color definition in element " + element.getName());
            }
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$wizarddisplay$items$Label == null ? (class$ch$dvbern$tax$common$engine$wizarddisplay$items$Label = Label.class$("ch.dvbern.tax.common.engine.wizarddisplay.items.Label")) : class$ch$dvbern$tax$common$engine$wizarddisplay$items$Label, new Label(element.getAttributeValue("name"), element.getAttribute("colspan") != null ? Integer.parseInt(element.getAttributeValue("colspan")) : 1, element.getAttributeValue("state"), align, element.getAttributeValue("style"), element.getAttributeValue("styleClass"), labelAddOns, fgColor));
        }
    }
}

