/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay.items;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.LabelAddOn;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.InvalidModelItemKeyException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class Form
extends WizardDisplayModelItem {
    private static final Logger logger = Logger.getLogger((Class)Form.class);
    private String name;
    private String header;
    private List headerAddOns;
    private List children;
    private List touchItemKeyList;
    private List printStateItems;

    public Form(String name, String header, List headerAddOns, String touchItemKey, String printStateItemKeys, List children) {
        StringTokenizer st;
        this.children = children;
        this.name = name;
        this.header = header;
        this.headerAddOns = headerAddOns;
        if (touchItemKey != null && touchItemKey.length() > 0) {
            this.touchItemKeyList = new ArrayList();
            st = new StringTokenizer(touchItemKey, ",");
            while (st.hasMoreTokens()) {
                this.touchItemKeyList.add(st.nextToken().trim());
            }
        }
        if (printStateItemKeys != null && printStateItemKeys.length() > 0) {
            this.printStateItems = new ArrayList();
            st = new StringTokenizer(printStateItemKeys, ",");
            while (st.hasMoreTokens()) {
                this.printStateItems.add(st.nextToken().trim());
            }
        }
        this.initializeParent();
    }

    public List getChildren() {
        return this.children;
    }

    public String getName() {
        return this.name;
    }

    public String getHeader() {
        return this.header;
    }

    public Object getFormInfo(WizardDisplayModelItem.ProtectedMap dataModel, String key) {
        dataModel.touch(key);
        if (this.touchItemKeyList != null) {
            Iterator i = this.touchItemKeyList.iterator();
            while (i.hasNext()) {
                String touchItem = i.next().toString();
                dataModel.touch(EngineUtil.mergeModelKey(touchItem, key));
            }
        }
        int printState = 1;
        try {
            printState = this.calcState(this.printStateItems, dataModel, key);
        }
        catch (InvalidModelItemKeyException e) {
            logger.warn((Object)("invalid printStateItem in " + this.getName()));
            throw new RuntimeException(e);
        }
        ArrayList<Object> labelAddOnDTOs = new ArrayList<Object>();
        if (this.headerAddOns != null) {
            Iterator iter = this.headerAddOns.iterator();
            while (iter.hasNext()) {
                LabelAddOn element = (LabelAddOn)iter.next();
                Object formInfo = element.getFormInfo(dataModel, key);
                if (formInfo == null) continue;
                labelAddOnDTOs.add(formInfo);
            }
        }
        if (labelAddOnDTOs.size() == 0) {
            labelAddOnDTOs = null;
        }
        ArrayList<Object> childrenDTO = null;
        if (this.getChildren() != null) {
            childrenDTO = new ArrayList<Object>();
            Iterator iter = this.getChildren().iterator();
            while (iter.hasNext()) {
                WizardDisplayModelItem element = (WizardDisplayModelItem)iter.next();
                Object childDTO = element.getFormInfo(dataModel, key);
                if (childDTO == null) continue;
                childrenDTO.add(childDTO);
            }
            if (childrenDTO.size() == 0) {
                childrenDTO = null;
            }
        }
        String editOut = key;
        if (EngineUtil.endsWithTableIndex(key)) {
            editOut = EngineUtil.removeLastKeyPart(editOut);
            editOut = EngineUtil.removeLastKeyPart(editOut);
        }
        WizardDisplayInfoDTO.FormItemDTO result = new WizardDisplayInfoDTO.FormItemDTO(this.getUniqueItemIdentifier(), 1, printState, this.name, this.header, labelAddOnDTOs, childrenDTO, editOut);
        return result;
    }

    public void additionalInitializeWizardDisplayModel(Map logicModelItems) throws InvalidModelException {
        if (this.touchItemKeyList != null) {
            Iterator i = this.touchItemKeyList.iterator();
            while (i.hasNext()) {
                Object key = i.next();
                if (logicModelItems.get(key) != null) continue;
                throw new InvalidModelException("invalid touch-reference in label (key=" + key + ")");
            }
        }
        if (this.headerAddOns != null) {
            Iterator iter = this.headerAddOns.iterator();
            while (iter.hasNext()) {
                LabelAddOn element = (LabelAddOn)iter.next();
                element.additionalInitializeWizardDisplayModel(logicModelItems);
            }
        }
    }

    private int calcState(List items, WizardDisplayModelItem.ProtectedMap dataModel, String tableKey) throws InvalidModelItemKeyException {
        int state = 1;
        if (items != null && !items.isEmpty()) {
            int maxPropagateableState = 1;
            int minState = 12;
            Iterator i = items.iterator();
            while (i.hasNext()) {
                int newState;
                String name = (String)i.next();
                ModelItemDTO miDTO = dataModel.getWithoutTouch(name);
                int n = newState = miDTO != null ? miDTO.getState() : 3;
                if (ModelItemDTO.isPropagatableState(newState) && ModelItemDTO.isMoreImportantState(newState, maxPropagateableState)) {
                    maxPropagateableState = newState;
                }
                if (ModelItemDTO.isMoreImportantState(newState, minState)) continue;
                minState = newState;
            }
            state = !ModelItemDTO.isPropagatableState(minState) ? minState : maxPropagateableState;
        }
        return state;
    }

    protected void print() {
        System.out.println("Form - Name=" + this.name + " header=" + this.header);
    }

    public String toString() {
        return "Form [" + this.name + "] " + this.header;
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<Object> childItems = elements.size() > 0 ? new ArrayList<Object>() : null;
            ArrayList<Object> labelAddOns = new ArrayList<Object>();
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                Element subElement = (Element)i.next();
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof LabelAddOn) {
                        labelAddOns.add(ref);
                        continue;
                    }
                    if (ref instanceof WizardDisplayModelItem) {
                        childItems.add(ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), pnre);
                }
            }
            if (labelAddOns.size() == 0 && element.getAttribute("header-add-on") != null) {
                labelAddOns.add(new LabelAddOn(element.getAttributeValue("header-add-on")));
            }
            if (labelAddOns.size() == 0) {
                labelAddOns = null;
            }
            if (element.getAttributeValue("viewId") != null) {
                throw new ElementParserException("viewId of Form can't be defined, it's always the 'nav_' + DMK.replaceAll('.', '_').toLowerCase(); " + element.getAttributeValue("name"));
            }
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$wizarddisplay$items$Form == null ? (class$ch$dvbern$tax$common$engine$wizarddisplay$items$Form = Form.class$("ch.dvbern.tax.common.engine.wizarddisplay.items.Form")) : class$ch$dvbern$tax$common$engine$wizarddisplay$items$Form, new Form(element.getAttributeValue("name"), element.getAttributeValue("header"), labelAddOns, element.getAttributeValue("touch"), element.getAttributeValue("printStateItems"), childItems));
        }
    }
}

