/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay.items;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.ColDef;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Form;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Item;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Label;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Row;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Section;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.util.List;
import org.apache.log4j.Logger;

public class Button
extends WizardDisplayModelItem {
    private static final Logger logger = Logger.getLogger((Class)Button.class);
    private int colspan;
    private String uri;
    private String name;
    private String dmk;
    private String dmkValue;
    private String target;
    private Integer width;
    private Integer height;
    private boolean transparentIfView;
    private String reRender;

    public Button(String uri, String name, String dmk, String dmkValue, String target, int colspan, boolean transparentIfView, Integer width, Integer height, String reRender) {
        this.initializeParent();
        this.uri = uri;
        this.name = name;
        this.dmk = dmk;
        this.target = target;
        this.colspan = colspan;
        this.transparentIfView = transparentIfView;
        this.width = width;
        this.height = height;
        this.dmkValue = dmkValue;
        this.reRender = reRender;
        logger.debug((Object)("BUTTON: uri=" + uri + ", name=" + name + ", dmk=" + dmk + ", dmkValue=" + dmkValue + ", target=" + target + ", reRender=" + reRender));
    }

    public List getChildren() {
        return null;
    }

    public int getColspan() {
        return this.colspan;
    }

    public Object getFormInfo(WizardDisplayModelItem.ProtectedMap dataModel, String key) {
        String s2;
        String s = this.dmk;
        if (s != null && s.length() > 0) {
            s = EngineUtil.mergeModelKey(s, key);
        }
        if ((s2 = this.dmkValue) != null && s2.length() > 0) {
            s2 = EngineUtil.mergeModelKey(s2, key);
        }
        if (this.getParent() instanceof Form) {
            return new WizardDisplayInfoDTO.ButtonDTO(this.getUniqueItemIdentifier(), this.uri, this.name, s, s2, this.target, this.colspan, this.transparentIfView, this.width, this.height, this.reRender);
        }
        int index = 0;
        for (int i = 0; i < ((Row)this.getParent()).getCols().size(); ++i) {
            WizardDisplayModelItem element = (WizardDisplayModelItem)((Row)this.getParent()).getCols().get(i);
            if (element == this) {
                index += i;
                break;
            }
            if (element instanceof Label && ((Label)element).getColspan() > 1) {
                index = index + ((Label)element).getColspan() - 1;
            }
            if (element instanceof Button && ((Button)element).getColspan() > 1) {
                index = index + ((Button)element).getColspan() - 1;
            }
            if (!(element instanceof Item) || ((Item)element).getColspan() <= 1) continue;
            index = index + ((Item)element).getColspan() - 1;
        }
        int corrColspan = this.colspan;
        for (int i = 0; i < this.colspan; ++i) {
            ColDef coldef = (ColDef)((Section)this.getParent().getParent()).getColdefs().get(index + i);
            WizardDisplayInfoDTO.ColDefItemDTO cdiDTO = (WizardDisplayInfoDTO.ColDefItemDTO)coldef.getFormInfo(dataModel, key);
            if (cdiDTO.getState() != 12) continue;
            --corrColspan;
        }
        if (corrColspan <= 0) {
            return null;
        }
        return new WizardDisplayInfoDTO.ButtonDTO(this.getUniqueItemIdentifier(), this.uri, this.name, s, s2, this.target, corrColspan, this.transparentIfView, this.width, this.height, this.reRender);
    }

    protected void print() {
        System.out.println("Button");
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            if (elements.size() > 0) {
                throw new ElementParserException("invalid child type for " + element);
            }
            String uri = element.getAttributeValue("URI");
            if (uri == null || uri.length() == 0) {
                throw new ElementParserException("missing URI argument for " + element);
            }
            String name = element.getAttributeValue("name");
            if (name == null || name.length() == 0) {
                throw new ElementParserException("missing name argument for " + element);
            }
            int colspan = element.getAttribute("colspan") != null ? Integer.parseInt(element.getAttributeValue("colspan")) : 1;
            boolean transparentIfEdit = false;
            if (element.getAttribute("transparent-if-view") != null) {
                transparentIfEdit = Boolean.valueOf(element.getAttributeValue("transparent-if-view"));
            }
            Integer width = null;
            Integer height = null;
            if (element.getAttribute("width") != null) {
                width = Integer.valueOf(element.getAttributeValue("width"));
            }
            if (element.getAttribute("height") != null) {
                width = Integer.valueOf(element.getAttributeValue("height"));
            }
            String reRender = element.getAttributeValue("reRender");
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$wizarddisplay$items$Button == null ? (class$ch$dvbern$tax$common$engine$wizarddisplay$items$Button = Button.class$("ch.dvbern.tax.common.engine.wizarddisplay.items.Button")) : class$ch$dvbern$tax$common$engine$wizarddisplay$items$Button, new Button(uri, name, element.getAttributeValue("dmk"), element.getAttributeValue("dmkValue"), element.getAttributeValue("target"), colspan, transparentIfEdit, width, height, reRender));
        }
    }
}

