/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay;

import ch.dvbern.tax.common.engine.Engine;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class WizardDisplayModelItem {
    private static long uiid_incrementer = 0L;
    private WizardDisplayModelItem parent;
    private long uniqueItemIdentifier;

    protected void initializeParent() {
        if (this.getChildren() != null) {
            Iterator i = this.getChildren().iterator();
            while (i.hasNext()) {
                ((WizardDisplayModelItem)i.next()).setParent(this);
            }
        }
    }

    public abstract Object getFormInfo(ProtectedMap var1, String var2);

    public WizardDisplayModelItem getParent() {
        return this.parent;
    }

    public void setParent(WizardDisplayModelItem parent) {
        this.parent = parent;
    }

    public abstract List getChildren();

    protected long getUniqueItemIdentifier() {
        return this.uniqueItemIdentifier;
    }

    public final void initializeWizardDisplayModel(Map logicModel, Map wizardDisplayModel) throws InvalidModelException {
        this.uniqueItemIdentifier = ++uiid_incrementer;
        if (this.getChildren() != null) {
            Iterator i = this.getChildren().iterator();
            while (i.hasNext()) {
                ((WizardDisplayModelItem)i.next()).initializeWizardDisplayModel(logicModel, wizardDisplayModel);
            }
        }
        this.additionalInitializeWizardDisplayModel(logicModel);
    }

    protected void additionalInitializeWizardDisplayModel(Map logicModel) throws InvalidModelException {
    }

    public static class ProtectedMap
    extends LogicModelItem.ProtectedMap {
        private Engine e;
        private boolean writeOnView;

        public ProtectedMap(Map nestedMap, boolean writeOnView, Engine e) {
            super(nestedMap, true);
            this.writeOnView = writeOnView;
            this.e = e;
        }

        public ModelItemDTO getModelItem(Object key) {
            ModelItemDTO modelItemDTO = (ModelItemDTO)this.nestedMap.get(key);
            if (modelItemDTO == null) {
                modelItemDTO = new ModelItemDTO(null, 3);
            }
            if (!modelItemDTO.isTouched() && this.writeOnView) {
                modelItemDTO = modelItemDTO.clone(modelItemDTO.getValue());
                modelItemDTO.setTouched();
                HashMap<Object, ModelItemDTO> changes = new HashMap<Object, ModelItemDTO>();
                changes.put(key, modelItemDTO);
                Map result = this.e.update(this.nestedMap, changes, true).getPersistenceWriteDTOs();
                this.getChangedMap().putAll(result);
            }
            return modelItemDTO;
        }

        public void touch(Object key) {
            ModelItemDTO modelItemDTO = (ModelItemDTO)this.nestedMap.get(key);
            if (modelItemDTO == null) {
                modelItemDTO = new ModelItemDTO(null, 1);
            }
            if (!modelItemDTO.isTouched()) {
                modelItemDTO = modelItemDTO.clone(modelItemDTO.getValue());
                modelItemDTO.setTouched();
                HashMap<Object, ModelItemDTO> changes = new HashMap<Object, ModelItemDTO>();
                changes.put(key, modelItemDTO);
                Map result = this.e.update(this.nestedMap, changes, true).getPersistenceWriteDTOs();
                this.getChangedMap().putAll(result);
            }
        }

        public ModelItemDTO getTable(Object key) {
            Map result;
            HashMap<Object, ModelItemDTO> changes;
            ModelItemDTO modelItemDTO = (ModelItemDTO)this.nestedMap.get(key);
            if (modelItemDTO == null) {
                modelItemDTO = new ModelItemDTO(new HashSet(), 1);
                modelItemDTO.setTouched();
                changes = new HashMap();
                changes.put(key, modelItemDTO);
                result = this.e.update(this.nestedMap, changes, true).getPersistenceWriteDTOs();
                this.getChangedMap().putAll(result);
            }
            if (modelItemDTO.getValue() == null || !modelItemDTO.isTouched()) {
                if (!modelItemDTO.isTouched()) {
                    modelItemDTO = modelItemDTO.clone(modelItemDTO.getValue());
                    modelItemDTO.setTouched();
                }
                changes = new HashMap<Object, ModelItemDTO>();
                changes.put(key, modelItemDTO);
                result = this.e.update(this.nestedMap, changes, true).getPersistenceWriteDTOs();
                this.getChangedMap().putAll(result);
            }
            return modelItemDTO;
        }

        public ModelItemDTO getWithoutTouch(Object key) {
            ModelItemDTO modelItemDTO = (ModelItemDTO)this.nestedMap.get(key);
            if (modelItemDTO == null) {
                modelItemDTO = new ModelItemDTO(null, 3);
            }
            return modelItemDTO;
        }
    }
}

