/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.ModelRoot;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Form;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class WizardDisplayModel {
    public static final int TMO_STATE_RELEASED = 100;
    private List forms = null;
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$wizarddisplay$WizardDisplayModel;

    public WizardDisplayModel(List forms) {
        this.forms = forms;
    }

    public void initializeWizardDisplayModel(Map logicModelItems, Map wizardDisplayModelItems) throws InvalidModelException {
        if (this.forms != null) {
            Iterator i = this.forms.iterator();
            while (i.hasNext()) {
                Form element = (Form)i.next();
                wizardDisplayModelItems.put(element.getName(), element);
                element.initializeWizardDisplayModel(logicModelItems, wizardDisplayModelItems);
            }
        }
    }

    public List getNavigationsInfo(Map logicModelItems, WizardDisplayModelItem.ProtectedMap dataModel, ModelRoot tmoRoot, String key, int tmoState, int caller) {
        List result = null;
        LogicModelItem current = (LogicModelItem)logicModelItems.get(EngineUtil.removeTableIndices(key));
        if (!(current instanceof LogicModelItem.ModuleItem) && !(current instanceof LogicModelItem.TableItem)) {
            current = (LogicModelItem)logicModelItems.get(EngineUtil.removeLastKeyPart(EngineUtil.removeTableIndices(key)));
        }
        if (current instanceof LogicModelItem.ModuleItem || current instanceof LogicModelItem.TableItem) {
            List topLMIs = null;
            LogicModelItem parent = current.getParent();
            while (parent instanceof LogicModelItem.ModuleItem) {
                parent = parent.getParent();
            }
            if (parent == null) {
                topLMIs = tmoRoot.getLogicModel().getModuls();
            }
            if (parent instanceof LogicModelItem.TableItem) {
                topLMIs = parent.getChildren();
            }
            if (topLMIs != null) {
                result = this.getChildNavigationItems(dataModel, topLMIs, current, key, tmoState, caller);
            }
        }
        return result;
    }

    private List getChildNavigationItems(WizardDisplayModelItem.ProtectedMap dataModel, List childLMIs, LogicModelItem current, String dataModelKey, int tmoState, int caller) {
        ArrayList<WizardDisplayInfoDTO.NavigationsItemDTO> result = new ArrayList<WizardDisplayInfoDTO.NavigationsItemDTO>();
        if (childLMIs != null) {
            Iterator i = childLMIs.iterator();
            while (i.hasNext()) {
                String navItemDMK;
                ModelItemDTO dto;
                LogicModelItem lmi = (LogicModelItem)i.next();
                if (!(lmi instanceof LogicModelItem.ModuleItem) || (dto = dataModel.getWithoutTouch(navItemDMK = EngineUtil.mergeModelKey(lmi.getName(), dataModelKey))) == null || dto.getState() == 12) continue;
                List childNavItems = null;
                if (current.getName().startsWith(lmi.getName())) {
                    childNavItems = this.getChildNavigationItems(dataModel, lmi.getChildren(), current, dataModelKey, tmoState, caller);
                }
                int state = dto.getState();
                if (this.isTransparentModule(lmi, tmoState)) {
                    state = 11;
                }
                if (this.isDisabledModule(lmi, caller)) continue;
                WizardDisplayInfoDTO.NavigationsItemDTO navigationItem = new WizardDisplayInfoDTO.NavigationsItemDTO(navItemDMK, ((LogicModelItem.ModuleItem)((Object)lmi)).getTitle(), state, current.getName().equals(lmi.getName()), childNavItems);
                result.add(navigationItem);
            }
        }
        return result;
    }

    private boolean isDisabledModule(LogicModelItem lmi, int caller) {
        boolean result = false;
        if (lmi instanceof LogicModelItem.ModuleItem) {
            LogicModelItem.ModuleItem module = (LogicModelItem.ModuleItem)((Object)lmi);
            if (module.isDisabledIfCd() && caller == 1) {
                result = true;
            }
            if (module.isDisabledIfOnline() && caller == 2) {
                result = true;
            }
        }
        return result;
    }

    private boolean isTransparentModule(LogicModelItem lmi, int tmoState) {
        boolean result = false;
        if (lmi instanceof LogicModelItem.ModuleItem) {
            LogicModelItem.ModuleItem module = (LogicModelItem.ModuleItem)((Object)lmi);
            if (module.isTransparentIfNotReleasable() && ModelItemDTO.isMoreImportantState(tmoState, 2)) {
                result = true;
            }
            if (module.isTransparentIfNotReleased() && tmoState != 100) {
                result = true;
            }
            if (module.isTransparentIfReleased() && tmoState == 100) {
                result = true;
            }
        }
        return result;
    }

    public String getBack(String key, Map logicModelItems) {
        LogicModelItem logicModelItem = (LogicModelItem)logicModelItems.get(EngineUtil.removeTableIndices(key));
        if (!(logicModelItem instanceof LogicModelItem.ModuleItem)) {
            return null;
        }
        LogicModelItem current = logicModelItem;
        while (current.getParent() != null) {
            if (current.getParent() instanceof LogicModelItem.TableItem) {
                String modulName = current.getParent().getParent().getName();
                return EngineUtil.mergeModelKey(modulName, key);
            }
            current = current.getParent();
        }
        return null;
    }

    public String getPrev(String key, WizardDisplayModelItem.ProtectedMap dataModel, Map logicModelItems, int tmoState, int caller) {
        LogicModelItem previousItem;
        LogicModelItem logicModelItem = (LogicModelItem)logicModelItems.get(EngineUtil.removeTableIndices(key));
        if (!(logicModelItem instanceof LogicModelItem.ModuleItem)) {
            return null;
        }
        for (previousItem = logicModelItem.getPreviousItem(); previousItem != null && !this.isSelectableItem(dataModel, previousItem, key, tmoState, caller); previousItem = previousItem.getPreviousItem()) {
        }
        return previousItem != null ? EngineUtil.mergeModelKey(previousItem.getName(), key) : null;
    }

    public String getNext(String key, WizardDisplayModelItem.ProtectedMap dataModel, Map logicModelItems, int tmoState, int caller) {
        LogicModelItem nextItem;
        LogicModelItem logicModelItem = (LogicModelItem)logicModelItems.get(EngineUtil.removeTableIndices(key));
        if (!(logicModelItem instanceof LogicModelItem.ModuleItem)) {
            return null;
        }
        for (nextItem = logicModelItem.getNextItem(); nextItem != null && !this.isSelectableItem(dataModel, nextItem, key, tmoState, caller); nextItem = nextItem.getNextItem()) {
        }
        return nextItem != null ? EngineUtil.mergeModelKey(nextItem.getName(), key) : null;
    }

    private boolean isSelectableItem(WizardDisplayModelItem.ProtectedMap dataModel, LogicModelItem lmi, String key, int tmoState, int caller) {
        if (this.isTransparentModule(lmi, tmoState) || this.isDisabledModule(lmi, caller)) {
            return false;
        }
        while (lmi != null) {
            String dmk = EngineUtil.mergeModelKey(lmi.getName(), key);
            ModelItemDTO miDTO = dataModel.getWithoutTouch(dmk);
            int state = miDTO.getState();
            if (state == 11 || state == 12) {
                return false;
            }
            lmi = lmi.getParent();
        }
        return true;
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<Object> childItems = elements.size() > 0 ? new ArrayList<Object>() : null;
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                Element subElement = (Element)i.next();
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof Form) {
                        childItems.add(ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), pnre);
                }
            }
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$wizarddisplay$WizardDisplayModel == null ? (class$ch$dvbern$tax$common$engine$wizarddisplay$WizardDisplayModel = WizardDisplayModel.class$("ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModel")) : class$ch$dvbern$tax$common$engine$wizarddisplay$WizardDisplayModel, new WizardDisplayModel(childItems));
        }
    }
}

