/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.validators;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;

public class NotNegative
implements Validator {
    private boolean autoCorrect = true;
    private boolean warning;
    private String messageKey;
    public static final String defaultErrorKey = "error.value.notnegative.default";
    public static final String defaultWarningKey = "warning.value.notnegative.default";
    public static final String defaultInfoKey = "info.value.notnegative.default";
    private boolean noMessage;
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$validators$NotNegative;

    public NotNegative(boolean autoCorrect, boolean warning, String messageKey, boolean noMessage) {
        this.autoCorrect = autoCorrect;
        this.warning = warning;
        this.messageKey = messageKey;
        this.noMessage = noMessage;
    }

    public NotNegative(boolean autoCorrect, boolean noMessage) {
        this.autoCorrect = autoCorrect;
        this.warning = false;
        this.messageKey = null;
        this.noMessage = noMessage;
    }

    public void initializeReferences(Map logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
    }

    public ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO) {
        ModelItemDTO result = modelItemDTO;
        if (result.getValue() instanceof Number && ((Number)result.getValue()).doubleValue() < 0.0) {
            if (this.noMessage) {
                result = result.clone(new Long(0L));
            } else if (this.autoCorrect) {
                String msg = this.messageKey == null ? defaultInfoKey : this.messageKey;
                result = result.clone(new Long(0L), 1, msg, null, 2);
            } else if (this.warning) {
                String msg = this.messageKey == null ? defaultWarningKey : this.messageKey;
                result = result.clone(2, msg, null, 2);
            } else {
                String msg = this.messageKey == null ? defaultErrorKey : this.messageKey;
                result = result.clone(4, msg, null, 4);
            }
        }
        return result;
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            boolean tmpCorrect = element.getAttribute("autocorrect") == null || !element.getAttributeValue("autocorrect").toLowerCase().equals("false");
            boolean noMessage = element.getAttribute("no-message") != null && element.getAttributeValue("no-message").toLowerCase().equals("true");
            boolean tmpWarning = Boolean.valueOf(element.getAttributeValue("warning"));
            String tmpMessageKey = element.getAttributeValue("message");
            NotNegative result = new NotNegative(tmpCorrect, tmpWarning, tmpMessageKey, noMessage);
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$validators$NotNegative == null ? (class$ch$dvbern$tax$common$engine$validators$NotNegative = NotNegative.class$("ch.dvbern.tax.common.engine.validators.NotNegative")) : class$ch$dvbern$tax$common$engine$validators$NotNegative, result);
        }
    }
}

