/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.validators;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NoInput
implements Validator {
    private List calcItems;
    private boolean autoCorrect;
    private boolean warning;
    private String messageKey;
    public static final String defaultErrorKey = "error.value.no.input.default";
    public static final String defaultWarningKey = "warning.value.no.input.default";
    public static final String defaultInfoKey = "info.value.no.input.default";
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$validators$NoInput;

    public NoInput(List calcItems, boolean autoCorrect, boolean warning, String messageKey) {
        this.calcItems = calcItems;
        this.autoCorrect = autoCorrect;
        this.warning = warning;
        this.messageKey = messageKey;
    }

    public void initializeReferences(Map logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        Iterator i = this.calcItems.iterator();
        while (i.hasNext()) {
            CalcItem ci = (CalcItem)i.next();
            if (!(ci instanceof Reference)) continue;
            ((Reference)((Object)ci)).registerListenerOnReference(logicModel, logicModelItem, false);
        }
    }

    public ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO) {
        Object value;
        ModelItemDTO result = modelItemDTO;
        FastStack stack = new FastStack();
        Iterator i = this.calcItems.iterator();
        while (i.hasNext()) {
            ((CalcItem)i.next()).evaluate(dataModel, stack, dataModelKey);
        }
        Object object = value = stack.size() > 0 ? stack.pop() : null;
        if (!(value instanceof Boolean) || !((Boolean)value).booleanValue()) {
            return result;
        }
        boolean no_input = false;
        if (result != null && result.getValue() != null && result.getValue() instanceof Boolean) {
            if (((Boolean)result.getValue()).booleanValue()) {
                no_input = true;
            }
        } else if (result != null && result.getValue() != null && result.getValue() instanceof Number) {
            if (((Number)result.getValue()).doubleValue() > 0.0) {
                no_input = true;
            }
        } else if (result != null && result.getValue() != null && result.getValue() instanceof String) {
            if (result.toString().length() > 0) {
                no_input = true;
            }
        } else if (result != null && result.getValue() != null) {
            no_input = true;
        }
        if (result != null && no_input) {
            if (this.autoCorrect) {
                String msg = this.messageKey == null ? defaultInfoKey : this.messageKey;
                result = result.clone(null, 1, msg, value, 2);
            } else if (this.warning) {
                String msg = this.messageKey == null ? defaultWarningKey : this.messageKey;
                result = result.clone(2, msg, value, 2);
            } else {
                String msg = this.messageKey == null ? defaultErrorKey : this.messageKey;
                result = result.clone(4, msg, value, 4);
            }
        }
        return result;
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            ArrayList<Object> calcItems = new ArrayList<Object>();
            List elements = element.getChildren();
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                Element subElement = (Element)i.next();
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof CalcItem) {
                        calcItems.add(ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), pnre);
                }
            }
            boolean tmpCorrect = element.getAttribute("autocorrect") != null && element.getAttributeValue("autocorrect").toLowerCase().equals("true");
            boolean tmpWarning = Boolean.valueOf(element.getAttributeValue("warning"));
            String tmpMessageKey = element.getAttributeValue("message");
            NoInput result = new NoInput(calcItems, tmpCorrect, tmpWarning, tmpMessageKey);
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$validators$NoInput == null ? (class$ch$dvbern$tax$common$engine$validators$NoInput = NoInput.class$("ch.dvbern.tax.common.engine.validators.NoInput")) : class$ch$dvbern$tax$common$engine$validators$NoInput, result);
        }
    }
}

