/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.validators;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Max
implements Validator {
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyyMMdd");
    private List calcItems;
    private Object constant;
    private boolean autoCorrect;
    private boolean warning;
    private String messageKey;
    public static final String defaultErrorKey = "error.value.max.default";
    public static final String defaultWarningKey = "warning.value.max.default";
    public static final String defaultInfoKey = "info.value.max.default";
    private boolean noMessage;
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$validators$Max;

    public Max(List calcItems, boolean autoCorrect, boolean warning, String messageKey, boolean noMessage) {
        this.calcItems = calcItems;
        this.autoCorrect = autoCorrect;
        this.warning = warning;
        this.messageKey = messageKey;
        this.noMessage = noMessage;
    }

    public Max(Object constant, boolean autoCorrect, boolean warning, String messageKey, boolean noMessage) {
        this.constant = constant;
        this.calcItems = new ArrayList();
        this.autoCorrect = autoCorrect;
        this.warning = warning;
        this.messageKey = messageKey;
        this.noMessage = noMessage;
    }

    public void initializeReferences(Map logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        Iterator i = this.calcItems.iterator();
        while (i.hasNext()) {
            CalcItem ci = (CalcItem)i.next();
            if (!(ci instanceof Reference)) continue;
            ((Reference)((Object)ci)).registerListenerOnReference(logicModel, logicModelItem, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO) {
        Serializable resultAsNumber;
        SimpleDateFormat simpleDateFormat;
        Object value;
        ModelItemDTO result = modelItemDTO;
        FastStack stack = new FastStack();
        Iterator i = this.calcItems.iterator();
        while (i.hasNext()) {
            ((CalcItem)i.next()).evaluate(dataModel, stack, dataModelKey);
        }
        Object object = value = stack.size() > 0 ? stack.pop() : null;
        if (value == null && this.constant == null) {
            return result;
        }
        value = value != null ? value : this.constant;
        boolean isDateType = result.getValue() instanceof Date;
        if (isDateType) {
            simpleDateFormat = SDF;
            synchronized (simpleDateFormat) {
                result = result.clone(new Long(SDF.format(result.getValue())));
            }
        }
        if (value instanceof Date) {
            simpleDateFormat = SDF;
            synchronized (simpleDateFormat) {
                value = new Long(SDF.format(value));
            }
            if (result.getValue() != null && result.getValue().toString().length() < 5) {
                value = new Long((Long)value / 10000L);
            }
        }
        if (value != null && result.getValue() instanceof Number) {
            resultAsNumber = (Number)result.getValue();
            if (isDateType && value.toString().length() == 4) {
                resultAsNumber = new Long(((Number)result.getValue()).longValue() / 10000L);
            }
            if (value instanceof Number && ((Number)resultAsNumber).doubleValue() > ((Number)value).doubleValue()) {
                if (this.noMessage) {
                    result = result.clone(value);
                } else if (this.autoCorrect && !isDateType) {
                    String msg = this.messageKey == null ? defaultInfoKey : this.messageKey;
                    result = result.clone(value, 1, msg, value, 2);
                } else if (this.warning) {
                    String msg = this.messageKey == null ? defaultWarningKey : this.messageKey;
                    result = result.clone(2, msg, value, 2);
                } else {
                    String msg = this.messageKey == null ? defaultErrorKey : this.messageKey;
                    result = result.clone(4, msg, value, 4);
                }
            }
        }
        try {
            resultAsNumber = SDF;
            synchronized (resultAsNumber) {
                if (isDateType) {
                    result = result.clone(SDF.parse(result.getValue().toString()));
                }
            }
        }
        catch (ParseException pe) {
            result = result.clone(null);
        }
        return result;
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            Max result;
            ArrayList<Object> calcItems = new ArrayList<Object>();
            List elements = element.getChildren();
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                Element subElement = (Element)i.next();
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof CalcItem) {
                        calcItems.add(ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), pnre);
                }
            }
            boolean tmpCorrect = element.getAttribute("autocorrect") != null && element.getAttributeValue("autocorrect").toLowerCase().equals("true");
            boolean noMessage = element.getAttribute("no-message") != null && element.getAttributeValue("no-message").toLowerCase().equals("true");
            boolean tmpWarning = Boolean.valueOf(element.getAttributeValue("warning"));
            String tmpMessageKey = element.getAttributeValue("message");
            if (calcItems.size() > 0) {
                result = new Max(calcItems, tmpCorrect, tmpWarning, tmpMessageKey, noMessage);
            } else {
                if (element.getAttributeValue("value") == null) {
                    throw new ElementParserException();
                }
                String sValue = element.getAttributeValue("value");
                Number tmpConstant = sValue.indexOf(".") != -1 ? (Number)Double.valueOf(sValue) : (Number)Long.valueOf(sValue);
                result = new Max(tmpConstant, tmpCorrect, tmpWarning, tmpMessageKey, noMessage);
            }
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$validators$Max == null ? (class$ch$dvbern$tax$common$engine$validators$Max = Max.class$("ch.dvbern.tax.common.engine.validators.Max")) : class$ch$dvbern$tax$common$engine$validators$Max, result);
        }
    }
}

