/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.validators;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CreateDefaultTableEntry
implements Validator {
    private static final Logger log = Logger.getLogger((Class)CreateDefaultTableEntry.class);
    private CalcItem[] calcItems;
    private Reference tableRef;

    public CreateDefaultTableEntry(CalcItem[] calcItems, Reference table) {
        this.calcItems = calcItems;
        this.tableRef = table;
    }

    public void initializeReferences(Map logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        for (int i = 0; i < this.calcItems.length; ++i) {
            CalcItem ci = this.calcItems[i];
            if (!(ci instanceof Reference)) continue;
            ((Reference)((Object)ci)).registerListenerOnReference(logicModel, logicModelItem, false);
        }
        this.tableRef.initializeReference(logicModel, logicModelItem, true);
    }

    public ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO) {
        Object value;
        FastStack stack = new FastStack();
        for (int i = 0; i < this.calcItems.length; ++i) {
            CalcItem ci = this.calcItems[i];
            ci.evaluate(dataModel, stack, dataModelKey);
        }
        Object object = value = stack.size() > 0 ? stack.pop() : null;
        if (value == null || !((Boolean)value).booleanValue()) {
            log.debug((Object)"no default table entry created because the condition is false");
            return modelItemDTO;
        }
        boolean tableIsEmpty = false;
        String tableDmk = EngineUtil.mergeModelKey(this.tableRef.getName(), dataModelKey);
        ModelItemDTO miDto = dataModel.get(tableDmk);
        if (miDto == null) {
            tableIsEmpty = true;
        } else {
            Set indizes = (Set)miDto.getValue();
            if (indizes.isEmpty()) {
                tableIsEmpty = true;
            }
        }
        if (!tableIsEmpty) {
            log.debug((Object)"no default table entry created because the table is not empty");
            return modelItemDTO;
        }
        LogicModelItem.TableItem table = (LogicModelItem.TableItem)((Object)this.tableRef.getReference());
        int index = EngineUtil.getNextTableItemIndex(dataModel, table, tableDmk);
        List childern = ((LogicModelItem)((Object)table)).getChildren();
        if (childern.isEmpty()) {
            log.debug((Object)"no default table entry created because the does not contain any childern");
            return modelItemDTO;
        }
        LogicModelItem firstChild = (LogicModelItem)childern.get(0);
        String itemDmk = EngineUtil.mergeModelKey(firstChild.getName(), tableDmk + "." + index);
        if (log.isDebugEnabled()) {
            log.debug((Object)("creating default table entry with dmk=" + itemDmk));
        }
        ModelItemDTO dummy = new ModelItemDTO();
        firstChild.setValue(dataModel, itemDmk, dummy, "true");
        log.debug((Object)"default table entry created");
        return modelItemDTO;
    }
}

