/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.validators;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;

public class CopyTableItemFromComboSelect
implements Validator {
    private Reference[] tableItemSources;
    private Reference selectChoosenItem;

    public CopyTableItemFromComboSelect(Reference[] tableItemSources, Reference selectChoosenItem) {
        this.tableItemSources = tableItemSources;
        this.selectChoosenItem = selectChoosenItem;
    }

    public void initializeReferences(Map logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        for (int i = 0; i < this.tableItemSources.length; ++i) {
            this.tableItemSources[i].registerListenerOnReference(logicModel, logicModelItem, true);
        }
        this.selectChoosenItem.registerListenerOnReference(logicModel, logicModelItem, false);
    }

    public ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO) {
        ModelItemDTO selectedItem = dataModel.get(EngineUtil.mergeModelKey(this.selectChoosenItem.getName(), dataModelKey));
        if (selectedItem == null || selectedItem.getValue() == null) {
            return modelItemDTO;
        }
        for (int i = 0; i < this.tableItemSources.length; ++i) {
            LogicModelItem lmi = this.tableItemSources[i].getReference();
            if (lmi == null) {
                throw new IllegalArgumentException(this.tableItemSources[i].getName() + " must be within a table item");
            }
            while (!(lmi instanceof LogicModelItem.TableItem)) {
                lmi = lmi.getParent();
            }
            String selectedTableItemKey = EngineUtil.mergeModelKey(lmi.getName(), dataModelKey) + "." + selectedItem.getValue();
            ModelItemDTO miDTO = dataModel.get(EngineUtil.mergeModelKey(this.tableItemSources[i].getName(), selectedTableItemKey));
            if (miDTO == null) continue;
            return miDTO;
        }
        return modelItemDTO;
    }
}

