/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.validators;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;

public class CalculateNewValueValidator
implements Validator {
    private CalcItem[] calcItems;
    private boolean alwaysTouch = false;
    private String noNewValueResult;

    public CalculateNewValueValidator(CalcItem[] calcItems) {
        this(calcItems, null);
    }

    public CalculateNewValueValidator(CalcItem[] calcItems, String noNewValueResult) {
        this.calcItems = calcItems;
        this.noNewValueResult = noNewValueResult;
    }

    public CalculateNewValueValidator(CalcItem[] calcItems, boolean alwaysTouch) {
        this(calcItems);
        this.alwaysTouch = alwaysTouch;
    }

    public void initializeReferences(Map logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        for (int i = 0; i < this.calcItems.length; ++i) {
            CalcItem ci = this.calcItems[i];
            if (!(ci instanceof Reference)) continue;
            ((Reference)((Object)ci)).registerListenerOnReference(logicModel, logicModelItem, false);
        }
    }

    public ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO) {
        ModelItemDTO result = modelItemDTO;
        FastStack stack = new FastStack();
        for (int i = 0; i < this.calcItems.length; ++i) {
            this.calcItems[i].evaluate(dataModel, stack, dataModelKey);
        }
        Object calcItemsResult = stack.size() > 0 ? stack.pop() : null;
        boolean newValue = false;
        if (this.noNewValueResult == null) {
            newValue = calcItemsResult != null;
        } else {
            boolean bl = newValue = !this.noNewValueResult.equals(calcItemsResult);
        }
        if (newValue) {
            result = result.clone(calcItemsResult);
            if (this.alwaysTouch) {
                result.setTouched();
            }
        }
        return result;
    }
}

