/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.util;

import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class EngineUtil {
    public static String mergeModelKey(String logicModelKey, String dataModelKey) {
        StringBuffer result = new StringBuffer("");
        StringTokenizer stLMK = new StringTokenizer(logicModelKey, ".");
        StringTokenizer stDMK = new StringTokenizer(dataModelKey, ".");
        boolean inSync = true;
        while (stDMK.hasMoreTokens() && inSync) {
            String dmkToken = stDMK.nextToken();
            if (dmkToken.charAt(0) >= '0' && dmkToken.charAt(0) <= '9') {
                if (result.length() > 0) {
                    result.append(".");
                }
                result.append(dmkToken);
                continue;
            }
            if (stLMK.hasMoreTokens()) {
                String lmkToken = stLMK.nextToken();
                inSync = dmkToken.equals(lmkToken);
                if (result.length() > 0) {
                    result.append(".");
                }
                result.append(lmkToken);
                continue;
            }
            inSync = false;
        }
        while (stLMK.hasMoreTokens()) {
            if (result.length() > 0) {
                result.append(".");
            }
            result.append(stLMK.nextToken());
        }
        return result.toString();
    }

    public static boolean endsWithTableIndex(String dataModelKey) {
        String s;
        if (dataModelKey == null) {
            return false;
        }
        int i = dataModelKey.lastIndexOf(46);
        String string = s = i < 0 ? dataModelKey : dataModelKey.substring(i + 1);
        if (s.length() == 0) {
            return false;
        }
        return s.charAt(0) >= '0' && s.charAt(0) <= '9';
    }

    public static String removeLastKeyPart(String dataModelKey) {
        int i = dataModelKey.lastIndexOf(46);
        return i < 0 ? "" : dataModelKey.substring(0, i);
    }

    public static String getLastKeyPart(String dataModelKey) {
        int i = dataModelKey.lastIndexOf(46);
        return i < 0 ? dataModelKey : dataModelKey.substring(i + 1);
    }

    public static String removeTableIndices(String modelKey) {
        StringBuffer result = new StringBuffer("");
        StringTokenizer st = new StringTokenizer(modelKey, ".");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.charAt(0) >= '0' && s.charAt(0) <= '9') continue;
            if (result.length() > 0) {
                result.append(".");
            }
            result.append(s);
        }
        return result.toString();
    }

    public static String convertPersistenceKey(String persistenceKeyTemplate, String dataModelKey) {
        String persistenceKey = persistenceKeyTemplate;
        StringTokenizer st = new StringTokenizer(dataModelKey, ".");
        int sharpPos = persistenceKey.indexOf("#");
        while (sharpPos > -1 && st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.charAt(0) >= '0' && s.charAt(0) <= '9') {
                persistenceKey = persistenceKey.substring(0, sharpPos) + s + persistenceKey.substring(sharpPos + 1);
            }
            sharpPos = persistenceKey.indexOf("#");
        }
        return persistenceKey;
    }

    public static int getNextTableItemIndex(LogicModelItem.ProtectedMap dataModel, LogicModelItem.TableItem tableItem, String dataModelKey) {
        int result = 90000;
        int index = EngineUtil.maxTableIndex(dataModel, (LogicModelItem)((Object)tableItem), dataModelKey);
        if (result <= index) {
            result = index + 1;
        }
        Iterator i = tableItem.getSharedTables().iterator();
        while (i.hasNext()) {
            LogicModelItem sharedTableItem = (LogicModelItem)i.next();
            index = EngineUtil.maxTableIndex(dataModel, sharedTableItem, dataModelKey);
            if (result > index) continue;
            result = index + 1;
        }
        return result;
    }

    private static int maxTableIndex(LogicModelItem.ProtectedMap dataModel, LogicModelItem tableItem, String dataModelKey) {
        int result = 0;
        String mergedName = EngineUtil.mergeModelKey(tableItem.getName(), dataModelKey);
        ModelItemDTO modelItemDTO = dataModel.get(mergedName);
        if (modelItemDTO != null && modelItemDTO.getValue() instanceof Set) {
            Set indices = (Set)modelItemDTO.getValue();
            Iterator i = indices.iterator();
            while (i.hasNext()) {
                int index = Integer.parseInt(i.next().toString());
                if (result >= index) continue;
                result = index;
            }
        }
        return result;
    }
}

