/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems.addons;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TableEntryItemSynchronizer
extends LogicModelItem
implements LogicModelItem.TableItem.TableEventListener {
    private Reference tableWithTheItems;
    private Reference[] theItems;
    private Map mapWithTheItems = new HashMap();

    public TableEntryItemSynchronizer(String name, Reference tableWithTheItems, Reference[] theItems) {
        super(name, null, null, true, "false", true);
        this.tableWithTheItems = tableWithTheItems;
        this.theItems = theItems;
    }

    protected void additionalInitializeReferences(Map logicModel) throws InvalidModelException {
        super.additionalInitializeReferences(logicModel);
        this.registerTableEventListener(this.getParent());
        for (int i = 0; i < this.theItems.length; ++i) {
            this.theItems[i].registerListenerOnReference(logicModel, this, false);
            this.mapWithTheItems.put(this.theItems[i].getName(), this.theItems[i]);
        }
    }

    private void registerTableEventListener(LogicModelItem lmi) throws InvalidModelException {
        if (lmi == null) {
            String s = "tableWithTheItems argument (" + this.tableWithTheItems.getName() + ") must be a superitem of " + this.getName() + " (class: " + this.getClass().getName() + ")";
            throw new InvalidModelException(s);
        }
        if (lmi instanceof LogicModelItem.TableItem) {
            ((LogicModelItem.TableItem)((Object)lmi)).addTableEventListener(this);
        }
        if (lmi.getName().equals(this.tableWithTheItems.getName())) {
            return;
        }
        this.registerTableEventListener(lmi.getParent());
    }

    public void onTableEntryAdd(LogicModelItem source, LogicModelItem.ProtectedMap dataModel, String tableDMK, String index) {
        if (!source.getName().equals(this.tableWithTheItems.getName())) {
            return;
        }
        ArrayList<LMIwithKeyAndValue> newItems = new ArrayList<LMIwithKeyAndValue>();
        Iterator i = dataModel.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry me = (Map.Entry)i.next();
            String dmk = me.getKey().toString();
            Reference r = (Reference)this.mapWithTheItems.get(EngineUtil.removeTableIndices(dmk));
            if (r == null) continue;
            String newDMK = this.replaceTableEntryIndex(dmk, tableDMK, index);
            newItems.add(new LMIwithKeyAndValue(r.getReference(), newDMK, (ModelItemDTO)me.getValue()));
        }
        i = newItems.iterator();
        while (i.hasNext()) {
            LMIwithKeyAndValue lmiwkav = (LMIwithKeyAndValue)i.next();
            lmiwkav.lmi.setValue(dataModel, lmiwkav.key, lmiwkav.value, null);
        }
    }

    public void onTableEntryRemove(LogicModelItem source, LogicModelItem.ProtectedMap dataModel, String tableDMK, String index) {
        if (source.getName().equals(this.tableWithTheItems.getName())) {
            return;
        }
        String mainTableDMK = EngineUtil.mergeModelKey(this.tableWithTheItems.getName(), tableDMK);
        mainTableDMK = EngineUtil.removeLastKeyPart(mainTableDMK);
        Set indices = (Set)dataModel.get(mainTableDMK).getValue();
        String currentDMK = tableDMK + "." + index;
        Iterator i = indices.iterator();
        while (i.hasNext()) {
            String newDMK = this.replaceTableEntryIndex(currentDMK, mainTableDMK, i.next().toString());
            if (newDMK.equals(currentDMK) || dataModel.get(newDMK) == null) continue;
            source.deleteValue(dataModel, newDMK);
        }
    }

    public void dataChanged(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO oldValue, ModelItemDTO newValue, String changedEventsOnlyOutsideOfThisTable) {
        if (newValue == null) {
            return;
        }
        if (changedEventsOnlyOutsideOfThisTable != null && dataModelKey.startsWith(changedEventsOnlyOutsideOfThisTable)) {
            return;
        }
        String tableDMK = EngineUtil.mergeModelKey(this.tableWithTheItems.getName(), dataModelKey);
        tableDMK = EngineUtil.removeLastKeyPart(tableDMK);
        Set tableIndices = (Set)dataModel.get(tableDMK).getValue();
        Iterator i = tableIndices.iterator();
        while (i.hasNext()) {
            String index = i.next().toString();
            String otherItemDMK = this.replaceTableEntryIndex(dataModelKey, tableDMK, index);
            Reference r = (Reference)this.mapWithTheItems.get(EngineUtil.removeTableIndices(otherItemDMK));
            if (r == null) continue;
            r.getReference().setValue(dataModel, otherItemDMK, newValue, changedEventsOnlyOutsideOfThisTable);
        }
    }

    private String replaceTableEntryIndex(String dataModelKey, String tableDMK, String index) {
        String subDMK = dataModelKey.substring(tableDMK.length() + 1);
        subDMK = subDMK.substring(subDMK.indexOf(46));
        return tableDMK + "." + index + subDMK;
    }

    private static class LMIwithKeyAndValue {
        LogicModelItem lmi;
        String key;
        ModelItemDTO value;

        LMIwithKeyAndValue(LogicModelItem lmi, String key, ModelItemDTO value) {
            this.lmi = lmi;
            this.key = key;
            this.value = value;
        }
    }
}

