/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems.addons;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;

public class TableEntryCounter
extends LogicModelItem
implements LogicModelItem.TableItem.TableEventListener {
    private Reference table;

    public TableEntryCounter(String name, Reference table) {
        super(name, null, null, true, "false", true);
        this.table = table;
    }

    protected void additionalInitializeReferences(Map logicModel) throws InvalidModelException {
        super.additionalInitializeReferences(logicModel);
        this.table.initializeReference(logicModel, this, false);
        ((LogicModelItem.TableItem)((Object)this.table.getReference())).addTableEventListener(this);
    }

    public void onTableEntryAdd(LogicModelItem source, LogicModelItem.ProtectedMap dataModel, String tableDMK, String index) {
        this.changeCounter(dataModel, tableDMK, 1L);
    }

    public void onTableEntryRemove(LogicModelItem source, LogicModelItem.ProtectedMap dataModel, String tableDMK, String index) {
        this.changeCounter(dataModel, tableDMK, -1L);
    }

    private void changeCounter(LogicModelItem.ProtectedMap dataModel, String tableDMK, long value) {
        String dmk = EngineUtil.mergeModelKey(this.getName(), tableDMK);
        ModelItemDTO miDTO = dataModel.get(dmk);
        if (miDTO == null || !(miDTO.getValue() instanceof Long)) {
            miDTO = new ModelItemDTO(new Long(0L));
        }
        long result = (Long)miDTO.getValue() + value;
        miDTO = miDTO.clone(new Long(result));
        super.setValue(dataModel, dmk, miDTO, null);
    }
}

