/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class Table
extends LogicModelItem
implements LogicModelItem.TableItem {
    private String sharedTableNames;
    private Set sharedTables = new HashSet();
    private Set tableEventListener;
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$modelitems$Table;

    public Table(String name, List children, String persistenceKeyTemplate, boolean readonly, boolean readonlyIfTransparent, String sharedTableNames) {
        super(name, children, persistenceKeyTemplate, readonly, "false", readonlyIfTransparent);
        this.sharedTableNames = sharedTableNames;
    }

    protected void additionalInitializeReferences(Map logicModel) throws InvalidModelException {
        super.additionalInitializeReferences(logicModel);
        if (this.sharedTableNames != null) {
            StringTokenizer st = new StringTokenizer(this.sharedTableNames, ",");
            while (st.hasMoreTokens()) {
                String sharedTableName = st.nextToken().trim();
                Object sharedTable = logicModel.get(sharedTableName);
                if (sharedTable instanceof LogicModelItem.TableItem) {
                    this.addSharedTable((LogicModelItem.TableItem)sharedTable);
                    continue;
                }
                throw new InvalidModelException("invalid sharedTable declaration (" + sharedTableName + ") in " + this.getName());
            }
        }
    }

    public void addSharedTable(LogicModelItem.TableItem otherTable) {
        if (this != otherTable && !this.sharedTables.contains(otherTable)) {
            this.sharedTables.add(otherTable);
            otherTable.addSharedTable(this);
            Iterator i = this.sharedTables.iterator();
            while (i.hasNext()) {
                LogicModelItem.TableItem ti = (LogicModelItem.TableItem)i.next();
                ti.addSharedTable(otherTable);
                otherTable.addSharedTable(ti);
            }
        }
    }

    public Collection getSharedTables() {
        return this.sharedTables;
    }

    public void addTableEventListener(LogicModelItem.TableItem.TableEventListener listener) {
        if (this.tableEventListener == null) {
            this.tableEventListener = new HashSet();
        }
        this.tableEventListener.add(listener);
    }

    public Collection getTableEventListeners() {
        return this.tableEventListener;
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<Object> childItems = elements.size() > 0 ? new ArrayList<Object>() : null;
            ArrayList<Object> validators = new ArrayList<Object>();
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                Element subElement = (Element)i.next();
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof LogicModelItem) {
                        childItems.add(ref);
                        continue;
                    }
                    if (ref instanceof Validator) {
                        validators.add(ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), pnre);
                }
            }
            Table result = new Table(element.getAttributeValue("name"), childItems, element.getAttributeValue("pKey"), (boolean)Boolean.valueOf(element.getAttributeValue("readonly")), Boolean.valueOf(element.getAttributeValue("readonly-if-transparent")), element.getAttributeValue("sharedTables"));
            Iterator i2 = validators.iterator();
            while (i2.hasNext()) {
                result.addValidator((Validator)i2.next());
            }
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$modelitems$Table == null ? (class$ch$dvbern$tax$common$engine$modelitems$Table = Table.class$("ch.dvbern.tax.common.engine.modelitems.Table")) : class$ch$dvbern$tax$common$engine$modelitems$Table, result);
        }
    }
}

