/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.Engine;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.modelitems.optionitems.TableOptionItem;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Select
extends LogicModelItem
implements LogicModelItem.SelectItem {
    private List optionItemFactories;
    private String defaultOptionName;
    private boolean autoSetDefault;
    private boolean blankItem = false;
    private boolean localized = false;
    private boolean hasInitialGreenState;
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$modelitems$Select;

    public Select(String name, String persistenceKeyTemplate, List optionItemFactories, boolean readonly, String importPrevious, boolean autoSetDefault, boolean blankItem, String defaultOptionName, boolean hasInitialGreenState, boolean readonlyIfTransparent) {
        super(name, null, persistenceKeyTemplate, readonly, importPrevious, readonlyIfTransparent);
        this.optionItemFactories = optionItemFactories;
        this.autoSetDefault = autoSetDefault;
        this.blankItem = blankItem;
        this.defaultOptionName = defaultOptionName;
        this.hasInitialGreenState = hasInitialGreenState;
    }

    public void additionalInitializeReferences(Map logicModel) throws InvalidModelException {
        super.additionalInitializeReferences(logicModel);
        Boolean lzd = null;
        Iterator i = this.optionItemFactories.iterator();
        while (i.hasNext()) {
            OptionItemFactory oif = (OptionItemFactory)i.next();
            oif.additionalInitializeReferences(logicModel, this);
            if (lzd == null) {
                lzd = oif.hasLocalizedOptions();
                continue;
            }
            if (!oif.hasLocalizedOptions() || lzd.booleanValue()) continue;
            throw new InvalidModelException(this.getName() + ": mixed localized and not localized options are not allowed");
        }
        if (lzd != null) {
            this.localized = lzd;
        }
    }

    public OptionItemsDTO getOptionItems(LogicModelItem.ProtectedMap dataModel, String dataModelKey) {
        try {
            OptionItemsDTO allOptionItems = null;
            Iterator iter = this.optionItemFactories.iterator();
            while (iter.hasNext()) {
                Map.Entry me;
                OptionItemFactory factory = (OptionItemFactory)iter.next();
                OptionItemsDTO options = factory.getOptionItems(dataModel, dataModelKey);
                if (options == null || options.getOptionItems() == null) continue;
                if (allOptionItems == null) {
                    if (this.localized) {
                        allOptionItems = new OptionItemsDTO(this.localized, new LinkedHashMap());
                        Iterator i1 = options.getOptionItems().entrySet().iterator();
                        while (i1.hasNext()) {
                            me = i1.next();
                            allOptionItems.getOptionItems().put(me.getKey(), new LinkedHashMap((Map)me.getValue()));
                        }
                        continue;
                    }
                    allOptionItems = new OptionItemsDTO(this.localized, new LinkedHashMap(options.getOptionItems()));
                    continue;
                }
                if (this.localized) {
                    Iterator i2 = allOptionItems.getOptionItems().entrySet().iterator();
                    while (i2.hasNext()) {
                        me = i2.next();
                        Object o = options.getOptionItems().get(me.getKey());
                        if (!(o instanceof Map) || !(me.getValue() instanceof Map)) continue;
                        ((Map)me.getValue()).putAll((Map)o);
                    }
                    continue;
                }
                allOptionItems.getOptionItems().putAll(options.getOptionItems());
            }
            if (this.blankItem) {
                LinkedHashMap lhm = new LinkedHashMap();
                lhm.put(null, new OptionItemDTO(null, "", "label.empty.selection", true));
                if (allOptionItems == null) {
                    allOptionItems = new OptionItemsDTO(false, lhm);
                } else if (allOptionItems.isLocalized()) {
                    Iterator i3 = allOptionItems.getOptionItems().entrySet().iterator();
                    while (i3.hasNext()) {
                        Map.Entry me = i3.next();
                        if (!(me.getValue() instanceof Map)) continue;
                        LinkedHashMap m = new LinkedHashMap((Map)me.getValue());
                        ((Map)me.getValue()).clear();
                        ((Map)me.getValue()).putAll(lhm);
                        ((Map)me.getValue()).putAll(m);
                    }
                } else {
                    lhm.putAll(allOptionItems.getOptionItems());
                    allOptionItems = new OptionItemsDTO(false, lhm);
                }
            }
            return allOptionItems;
        }
        catch (RuntimeException re) {
            throw new RuntimeException("OptionItems creation failed for select with dmk=" + dataModelKey, re);
        }
    }

    protected ModelItemDTO getDefaultValue(LogicModelItem.ProtectedMap dataModel, String dataModelKey) {
        OptionItemDTO option;
        if (!this.autoSetDefault && this.defaultOptionName == null) {
            return null;
        }
        OptionItemsDTO oisDTO = this.getOptionItems(dataModel, dataModelKey);
        if (oisDTO != null && oisDTO.getOptionKeys() != null && oisDTO.getOptionKeys().size() == 1 && this.autoSetDefault) {
            OptionItemDTO oiDTO = oisDTO.get(oisDTO.getOptionKeys().iterator().next());
            ModelItemDTO result = new ModelItemDTO(oiDTO.getValue());
            result.setTouched();
            return result;
        }
        if (this.defaultOptionName != null && oisDTO != null && (option = this.getOptionItems(dataModel, dataModelKey).get(this.defaultOptionName)) != null) {
            return new ModelItemDTO(option.getValue());
        }
        return null;
    }

    protected boolean hasAnInitialGreenState() {
        if (this.hasInitialGreenState) {
            return true;
        }
        return super.hasAnInitialGreenState();
    }

    public boolean hasTableOption() {
        Iterator iter = this.optionItemFactories.iterator();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof TableOptionItem)) continue;
            return true;
        }
        return false;
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            ArrayList<Object> optionItems = new ArrayList<Object>();
            ArrayList<Object> validators = new ArrayList<Object>();
            List elements = element.getChildren();
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                Element subElement = (Element)i.next();
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof OptionItemFactory) {
                        optionItems.add(ref);
                        continue;
                    }
                    if (ref instanceof Validator) {
                        validators.add(ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), pnre);
                }
            }
            Engine.setMandatory(element, validators);
            String defaultValue = null;
            if (element.getAttribute("default") != null) {
                defaultValue = element.getAttributeValue("default");
            }
            Select result = new Select(element.getAttributeValue("name"), element.getAttributeValue("pKey"), optionItems, Boolean.valueOf(element.getAttributeValue("readonly")), element.getAttributeValue("import"), Boolean.valueOf(element.getAttributeValue("auto-set-default")), Boolean.valueOf(element.getAttributeValue("blank-item")), defaultValue, Boolean.valueOf(element.getAttributeValue("has-initial-green-state")), Boolean.valueOf(element.getAttributeValue("readonly-if-transparent")));
            validators.add(new OptionValid(result));
            Iterator i2 = validators.iterator();
            while (i2.hasNext()) {
                result.addValidator((Validator)i2.next());
            }
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$modelitems$Select == null ? (class$ch$dvbern$tax$common$engine$modelitems$Select = Select.class$("ch.dvbern.tax.common.engine.modelitems.Select")) : class$ch$dvbern$tax$common$engine$modelitems$Select, result);
        }
    }

    public static class OptionValid
    implements Validator {
        private Select select;
        public static final String defaultErrorKey = "error.invalid.select.option";

        public OptionValid(Select select) {
            this.select = select;
        }

        public void initializeReferences(Map logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        }

        public ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO) {
            ModelItemDTO result = modelItemDTO;
            if (result.getValue() == null) {
                return result;
            }
            OptionItemsDTO items = this.select.getOptionItems(dataModel, dataModelKey);
            if (items != null && items.getOptionKeys().contains(result.getValue().toString())) {
                return result;
            }
            return result.clone(null, 4, defaultErrorKey, null, 4);
        }
    }

    public static interface OptionItemFactory {
        public OptionItemsDTO getOptionItems(LogicModelItem.ProtectedMap var1, String var2);

        public void additionalInitializeReferences(Map var1, LogicModelItem var2) throws InvalidModelException;

        public boolean hasLocalizedOptions();
    }
}

