/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertReadonlyHelper;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.failure.InvalidModelItemKeyException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ExpertValueItem
extends ExpertDisplayModelItem
implements ExpertFormItem.FormElement {
    private ExpertReadonlyHelper expertReadonlyHelper = new ExpertReadonlyHelper();
    private int x;
    private int y;
    private int width;
    private int height;
    private int type;
    private int alignment;
    private ExpertDisplayInfoDTO.FontDTO font;
    private ExpertDisplayInfoDTO.ColorDTO bgColor;
    private String logicModelItemName;
    private LogicModelItem logicModelItem;
    private AbstractConverter rendererAndInputValidator;
    private Map valuePositions;
    private Boolean readonly;
    private Boolean readOnlyIfTransparent;
    private boolean submitOnChange;
    private boolean blankItem = false;
    private boolean autoWidthOnFocus;
    private String reRender;
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$expertdisplay$ExpertFormItem$FormElement;

    public ExpertValueItem(int x, int y, int width, int height, int type, int alignment, ExpertDisplayInfoDTO.FontDTO font, ExpertDisplayInfoDTO.ColorDTO bgColor, String logicModelItemName, Boolean readonly, AbstractConverter rendererAndInputValidator, Map valuePositions, int printMode, boolean inputItem, Set languages, boolean submitOnChange, Boolean readOnlyIfTransparent, boolean blankItem, boolean autoWidthOnFocus, String reRender) {
        super(languages, printMode, inputItem);
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.type = type;
        this.alignment = alignment;
        this.font = font;
        this.bgColor = bgColor;
        this.logicModelItemName = logicModelItemName;
        this.readonly = readonly;
        this.rendererAndInputValidator = rendererAndInputValidator;
        this.valuePositions = valuePositions;
        this.submitOnChange = submitOnChange;
        this.readOnlyIfTransparent = readOnlyIfTransparent;
        this.blankItem = blankItem;
        this.autoWidthOnFocus = autoWidthOnFocus;
        this.reRender = reRender;
    }

    public List getChildren() {
        return null;
    }

    protected void additionalInitialization(Map logicModelItems, Map navigationItems) throws InvalidModelException {
        super.additionalInitialization(logicModelItems, navigationItems);
        this.logicModelItem = (LogicModelItem)logicModelItems.get(this.logicModelItemName);
        if (this.logicModelItem == null) {
            throw new InvalidModelException("invalid item reference (" + this.logicModelItemName + ") in " + this.getClass().getName());
        }
        if (this.readonly == null) {
            this.readonly = this.logicModelItem.isReadonly();
        }
        if (this.readOnlyIfTransparent == null) {
            this.readOnlyIfTransparent = this.logicModelItem.isReadonlyIfTransparent();
        }
        this.expertReadonlyHelper.init(logicModelItems, this.logicModelItem);
    }

    public ExpertDisplayInfoDTO.ItemDTO getItemDTO(ExpertDisplayModel.RequestContext requestContext) throws InvalidModelItemKeyException {
        int i;
        Integer parentState;
        String dmk = ExpertDisplayUtil.getModelItemKey(this.logicModelItem, requestContext.getFormAccessKey());
        OptionItemsDTO optionItems = null;
        if (this.logicModelItem instanceof LogicModelItem.SelectItem && ((optionItems = ((LogicModelItem.SelectItem)((Object)this.logicModelItem)).getOptionItems(requestContext.getDataModel(), dmk)) == null || optionItems.getOptionKeys() == null || optionItems.getOptionKeys().isEmpty())) {
            return null;
        }
        ModelItemDTO miDTO = requestContext.getDataModel().getModelItem(dmk);
        if (miDTO != null && miDTO.getState() != 12 && (parentState = ExpertDisplayUtil.getDisabledOrTransparentParentState(this.logicModelItem, requestContext.getDataModel(), dmk)) != null && ((i = parentState.intValue()) == 12 || i == 11)) {
            miDTO = miDTO.clone(i);
        }
        boolean ro = this.expertReadonlyHelper.evaluateReadonlyMode(this.readonly, this.readOnlyIfTransparent, this.logicModelItem, miDTO, dmk, requestContext.getDataModel());
        if (this.type == 2) {
            ExpertDisplayUtil.handleBlankItem(optionItems, this.blankItem);
        }
        return new ExpertDisplayInfoDTO.ValueItemDTO(this.x, this.y, this.width, this.height, this.font != null ? this.font : requestContext.getDefaultFont(), this.bgColor, this.alignment, this.type, dmk, miDTO, optionItems, ro, this.rendererAndInputValidator, this.valuePositions, this.getPrintMode(), this.submitOnChange, this.autoWidthOnFocus, requestContext.getFormAccessKey() + "." + this.getUniqueItemIdentifier(), this.logicModelItemName, this.reRender);
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            TreeMap<String, ExpertDisplayInfoDTO.ValuePositionDTO> valuePositions = null;
            ExpertDisplayInfoDTO.FontDTO font = null;
            AbstractConverter converter = null;
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                Element subElement = (Element)i.next();
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof ExpertDisplayInfoDTO.ValuePositionDTO) {
                        ExpertDisplayInfoDTO.ValuePositionDTO vp = (ExpertDisplayInfoDTO.ValuePositionDTO)ref;
                        if (valuePositions == null) {
                            valuePositions = new TreeMap<String, ExpertDisplayInfoDTO.ValuePositionDTO>();
                        }
                        valuePositions.put(vp.getValue(), vp);
                        continue;
                    }
                    if (ref instanceof ExpertDisplayInfoDTO.FontDTO) {
                        font = (ExpertDisplayInfoDTO.FontDTO)ref;
                        continue;
                    }
                    if (ref instanceof AbstractConverter) {
                        converter = (AbstractConverter)ref;
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), pnre);
                }
            }
            ExpertDisplayUtil.TypeAndConverter typeAndConverter = ExpertDisplayUtil.parseInputType(element, converter);
            Boolean readonly = null;
            if (element.getAttribute("readonly") != null) {
                readonly = Boolean.valueOf(element.getAttributeValue("readonly"));
            }
            Boolean readonlyIfTransparent = null;
            if (element.getAttribute("readonly-if-transparent") != null) {
                readonlyIfTransparent = Boolean.valueOf(element.getAttributeValue("readonly-if-transparent"));
            }
            boolean expand = false;
            int halign = ExpertDisplayUtil.parseHAlignment(element.getAttributeValue("halign"));
            expand = 2 == halign ? ExpertDisplayUtil.getBoolean(element.getAttributeValue("auto-width-on-focus"), true) : ExpertDisplayUtil.getBoolean(element.getAttributeValue("auto-width-on-focus"), false);
            String reRender = "self";
            if (element.getAttribute("reRender") != null) {
                reRender = element.getAttributeValue("reRender");
            }
            ExpertValueItem evi = new ExpertValueItem(ExpertDisplayUtil.toPixel(element.getAttributeValue("x")), ExpertDisplayUtil.toPixel(element.getAttributeValue("y")), ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.toPixel(element.getAttributeValue("height")), typeAndConverter.type, ExpertDisplayUtil.parseHAlignment(element.getAttributeValue("halign")), font, ExpertDisplayUtil.parseColor(element.getAttributeValue("bgColor")), element.getAttributeValue("value"), readonly, typeAndConverter.converter, valuePositions, ExpertDisplayUtil.parseOutputMode(element.getAttributeValue("printItem")), ExpertDisplayUtil.getBoolean(element.getAttributeValue("inputItem"), true), ExpertDisplayUtil.parseLanguages(element.getAttributeValue("lang")), ExpertDisplayUtil.getBoolean(element.getAttributeValue("submitOnChange"), false), readonlyIfTransparent, ExpertDisplayUtil.getBoolean(element.getAttributeValue("blank-item"), true), expand, reRender);
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$expertdisplay$ExpertFormItem$FormElement == null ? (class$ch$dvbern$tax$common$engine$expertdisplay$ExpertFormItem$FormElement = ExpertValueItem.class$("ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem$FormElement")) : class$ch$dvbern$tax$common$engine$expertdisplay$ExpertFormItem$FormElement, evi);
        }
    }
}

