/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertTableItem;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.failure.InvalidModelItemKeyException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExpertTableMerge
extends ExpertDisplayModelItem
implements ExpertFormItem.FormElement {
    private static final ExpertDisplayInfoDTO.ColorDTO BLACK = new ExpertDisplayInfoDTO.ColorDTO(0, 0, 0);
    private int x;
    private int y;
    private int width;
    private int height;
    private int headerHeight;
    private int formRows;
    private float rowHeight;
    private float colSpace;
    private float extraPagesRowPadding;
    private ExpertDisplayInfoDTO.FontDTO titleFont;
    private ExpertDisplayInfoDTO.PatternDTO titlePattern;
    private ExpertDisplayInfoDTO.ColorDTO bgColor;
    private boolean readonly;
    private String title;
    private List nestedTables;
    private boolean enhanced = false;
    private ExpertDisplayInfoDTO.ColorDTO borderColor;
    private boolean headerVisible;
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$expertdisplay$ExpertFormItem$FormElement;

    public ExpertTableMerge(int x, int y, int width, int height, int headerHeight, int formRows, ExpertDisplayInfoDTO.FontDTO titleFont, ExpertDisplayInfoDTO.PatternDTO titlePattern, ExpertDisplayInfoDTO.ColorDTO bgColor, boolean readonly, List nestedTables, int printMode, boolean inputItem, float rowHeight, float colSpace, String title, Set languages, ExpertDisplayInfoDTO.ColorDTO borderColor, float extraPagesRowPadding, boolean headerVisible) {
        super(languages, printMode, inputItem);
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.headerHeight = headerHeight;
        this.formRows = formRows;
        this.titleFont = titleFont;
        this.titlePattern = titlePattern;
        this.bgColor = bgColor;
        this.readonly = readonly;
        this.nestedTables = nestedTables;
        this.rowHeight = rowHeight;
        this.colSpace = colSpace;
        this.title = title;
        this.borderColor = borderColor;
        this.extraPagesRowPadding = extraPagesRowPadding;
        this.headerVisible = headerVisible;
    }

    public List getChildren() {
        return this.nestedTables;
    }

    protected void additionalInitialization(Map logicModelItems, Map navigationItems) throws InvalidModelException {
        super.additionalInitialization(logicModelItems, navigationItems);
        if (this.width <= 0) {
            throw new InvalidModelException("width must be greater than 0. in" + this.getClass().getName());
        }
        if (this.nestedTables == null || this.nestedTables.size() == 0) {
            throw new InvalidModelException("missing content in " + this.getClass().getName());
        }
        ExpertTableItem prevETI = null;
        Iterator i = this.nestedTables.iterator();
        while (i.hasNext()) {
            ExpertTableItem eti = (ExpertTableItem)i.next();
            if (prevETI != null) {
                if (prevETI.getColumnCount() != eti.getColumnCount()) {
                    throw new InvalidModelException("different nested tablestructures in " + this.getClass().getName());
                }
                if (prevETI.getFormElementCount() != eti.getFormElementCount()) {
                    throw new InvalidModelException("different nested tablestructures in " + this.getClass().getName());
                }
            }
            if (eti.getColumnCount() == 0) {
                this.enhanced = true;
            }
            prevETI = eti;
        }
    }

    public ExpertDisplayInfoDTO.ItemDTO getItemDTO(ExpertDisplayModel.RequestContext requestContext) throws InvalidModelItemKeyException {
        ArrayList columnDTOs = null;
        ArrayList rowDTOs = new ArrayList();
        int state = 1;
        String dmk = null;
        Iterator i = this.nestedTables.iterator();
        while (i.hasNext()) {
            ExpertTableItem eti = (ExpertTableItem)i.next();
            ExpertDisplayInfoDTO.TableDTO tDTO = (ExpertDisplayInfoDTO.TableDTO)eti.getItemDTO(requestContext);
            if (!this.enhanced) {
                columnDTOs = new ArrayList();
                columnDTOs.addAll(tDTO.getAllColumns());
            }
            rowDTOs.addAll(tDTO.getAllRows());
            if (ModelItemDTO.isMoreImportantState(tDTO.getState(), state)) {
                state = tDTO.getState();
            }
            dmk = tDTO.getDataModelKey();
        }
        return new ExpertDisplayInfoDTO.TableDTO(this.x, this.y, this.width, this.height, this.headerHeight, this.formRows, this.titleFont != null ? this.titleFont : requestContext.getDefaultTableTitleFont(), this.titlePattern != null ? this.titlePattern : requestContext.getDefaultTableTitlePattern(), this.bgColor, columnDTOs, rowDTOs, state, this.readonly, this.enhanced, this.getPrintMode(), this.rowHeight, this.colSpace, this.title, this.borderColor, this.extraPagesRowPadding, dmk, this.getUniqueItemIdentifier(), this.headerVisible, false, 0, Integer.MAX_VALUE);
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<Object> nestedTables = null;
            ExpertDisplayInfoDTO.FontDTO titleFont = null;
            ExpertDisplayInfoDTO.PatternDTO titlePattern = null;
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                Element subElement = (Element)i.next();
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof ExpertTableItem) {
                        if (nestedTables == null) {
                            nestedTables = new ArrayList<Object>();
                        }
                        nestedTables.add(ref);
                        continue;
                    }
                    if (ref instanceof ExpertDisplayInfoDTO.FontDTO) {
                        if (element.getName().equals("e-table-title-font")) {
                            titleFont = (ExpertDisplayInfoDTO.FontDTO)ref;
                            continue;
                        }
                        throw new ElementParserException("font is not supported for a table merge: " + ref);
                    }
                    if (ref instanceof ExpertDisplayInfoDTO.PatternDTO) {
                        titlePattern = (ExpertDisplayInfoDTO.PatternDTO)ref;
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), pnre);
                }
            }
            ExpertTableMerge etm = new ExpertTableMerge(ExpertDisplayUtil.toPixel(element.getAttributeValue("x")), ExpertDisplayUtil.toPixel(element.getAttributeValue("y")), ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.toPixel(element.getAttributeValue("height")), ExpertDisplayUtil.toPixel(element.getAttributeValue("headerHeight")), new Integer(element.getAttributeValue("rows")), titleFont, titlePattern, ExpertDisplayUtil.parseColor(element.getAttributeValue("bgColor")), Boolean.valueOf(element.getAttributeValue("readonly")), nestedTables, ExpertDisplayUtil.parseOutputMode(element.getAttributeValue("printItem")), ExpertDisplayUtil.getBoolean(element.getAttributeValue("inputItem"), true), ExpertDisplayUtil.toPixelFloat(element.getAttributeValue("rowHeight")), ExpertDisplayUtil.toPixelFloat(element.getAttributeValue("colSpace")), element.getAttributeValue("title"), ExpertDisplayUtil.parseLanguages(element.getAttributeValue("lang")), ExpertDisplayUtil.parseColor(element.getAttributeValue("borderColor"), BLACK), ExpertDisplayUtil.toPixelFloat(element.getAttributeValue("extraPagesRowPadding")), ExpertDisplayUtil.getBoolean(element.getAttributeValue("headerVisible"), true));
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$expertdisplay$ExpertFormItem$FormElement == null ? (class$ch$dvbern$tax$common$engine$expertdisplay$ExpertFormItem$FormElement = ExpertTableMerge.class$("ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem$FormElement")) : class$ch$dvbern$tax$common$engine$expertdisplay$ExpertFormItem$FormElement, etm);
        }
    }
}

