/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertReadonlyHelper;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertTableColumn;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.failure.InvalidModelItemKeyException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExpertTableItem
extends ExpertDisplayModelItem
implements ExpertFormItem.FormElement {
    private static final ExpertDisplayInfoDTO.ColorDTO BLACK = new ExpertDisplayInfoDTO.ColorDTO(0, 0, 0);
    private int x;
    private int y;
    private int width;
    private int height;
    private int headerHeight;
    private int formRows;
    private float rowHeight;
    private float colSpace;
    private float extraPagesRowPadding;
    private ExpertDisplayInfoDTO.FontDTO cellFont;
    private ExpertDisplayInfoDTO.FontDTO titleFont;
    private ExpertDisplayInfoDTO.FontDTO headerFont;
    private ExpertDisplayInfoDTO.PatternDTO titlePattern;
    private ExpertDisplayInfoDTO.ColorDTO bgColor;
    private String logicModelItemName;
    private LogicModelItem logicModelItem;
    private Boolean readonly;
    private Boolean readonlyIfTransparent;
    private List columns;
    private List formElements;
    private boolean enhanced;
    private boolean dummy;
    private String title;
    private String printRowStateItemName;
    private LogicModelItem printRowStateItem;
    private ExpertDisplayInfoDTO.ColorDTO borderColor;
    private ExpertReadonlyHelper expertReadonlyHelper = new ExpertReadonlyHelper();
    private boolean headerVisible;
    private int startRow;
    private int endRow;
    private static Comparator tableRowSorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                return new Integer((String)o1).compareTo(new Integer((String)o2));
            }
            return 0;
        }
    };
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$expertdisplay$ExpertFormItem$FormElement;

    public ExpertTableItem(int x, int y, int width, int height, int headerHeight, int formRows, ExpertDisplayInfoDTO.FontDTO font, ExpertDisplayInfoDTO.FontDTO titleFont, ExpertDisplayInfoDTO.FontDTO headerFont, ExpertDisplayInfoDTO.PatternDTO titlePattern, ExpertDisplayInfoDTO.ColorDTO bgColor, String logicModelItemName, Boolean readonly, List columns, List formElements, int printMode, boolean inputItem, float rowHeight, String title, float colSpace, Set languages, String printRowsItemName, ExpertDisplayInfoDTO.ColorDTO borderColor, float extraPagesRowPadding, Boolean readonlyIfTransparent, boolean headerVisible, int startRow, int endRow) {
        super(languages, printMode, inputItem);
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.headerHeight = headerHeight;
        this.formRows = formRows;
        this.cellFont = font;
        this.titleFont = titleFont;
        this.headerFont = headerFont;
        this.titlePattern = titlePattern;
        this.bgColor = bgColor;
        this.logicModelItemName = logicModelItemName;
        this.readonly = readonly;
        this.columns = columns;
        this.formElements = formElements;
        this.rowHeight = rowHeight;
        this.enhanced = formElements != null;
        this.title = title;
        this.colSpace = colSpace;
        this.printRowStateItemName = printRowsItemName;
        this.borderColor = borderColor;
        this.extraPagesRowPadding = extraPagesRowPadding;
        this.readonlyIfTransparent = readonlyIfTransparent;
        this.headerVisible = headerVisible;
        this.startRow = startRow;
        this.endRow = endRow;
    }

    public List getChildren() {
        if (this.formElements != null) {
            return this.formElements;
        }
        return this.columns;
    }

    protected void additionalInitialization(Map logicModelItems, Map navigationItems) throws InvalidModelException {
        super.additionalInitialization(logicModelItems, navigationItems);
        if (this.width <= 0) {
            throw new InvalidModelException("width must be greater than 0. in" + this.getClass().getName());
        }
        if (this.logicModelItemName == null) {
            this.dummy = true;
        } else {
            this.logicModelItem = (LogicModelItem)logicModelItems.get(this.logicModelItemName);
            if (!(this.logicModelItem instanceof LogicModelItem.TableItem)) {
                throw new InvalidModelException("invalid value reference (" + this.logicModelItemName + ") in " + this.getClass().getName());
            }
        }
        if (this.readonly == null) {
            Boolean bl = this.readonly = this.logicModelItem != null ? Boolean.valueOf(this.logicModelItem.isReadonly()) : Boolean.FALSE;
        }
        if (this.readonlyIfTransparent == null) {
            Boolean bl = this.readonlyIfTransparent = this.logicModelItem != null ? Boolean.valueOf(this.logicModelItem.isReadonlyIfTransparent()) : Boolean.FALSE;
        }
        if (this.printRowStateItemName != null) {
            this.printRowStateItem = (LogicModelItem)logicModelItems.get(this.printRowStateItemName);
            if (this.printRowStateItem == null) {
                throw new InvalidModelException("invalid printRowsItem reference (" + this.printRowStateItemName + ") in " + this.getClass().getName());
            }
        }
        if (!this.enhanced && this.columns == null) {
            throw new InvalidModelException("missing table content (" + this.logicModelItemName + ") in " + this.getClass().getName());
        }
        this.expertReadonlyHelper.init(logicModelItems, this.logicModelItem);
    }

    int getColumnCount() {
        if (this.columns == null) {
            return 0;
        }
        return this.columns.size();
    }

    int getFormElementCount() {
        if (this.formElements == null) {
            return 0;
        }
        return this.formElements.size();
    }

    public ExpertDisplayInfoDTO.ItemDTO getItemDTO(ExpertDisplayModel.RequestContext requestContext) throws InvalidModelItemKeyException {
        boolean ro;
        int i;
        Integer parentState;
        Set unsortedRowIndices;
        if (this.dummy) {
            return this.getDummyTableItemDTO(requestContext);
        }
        if (this.enhanced) {
            return this.getEnhancedItemDTO(requestContext);
        }
        ArrayList<ExpertDisplayInfoDTO.TableDTO.ColumnDTO> columnDTOs = new ArrayList<ExpertDisplayInfoDTO.TableDTO.ColumnDTO>();
        Iterator i2 = this.columns.iterator();
        while (i2.hasNext()) {
            ExpertTableColumn etc = (ExpertTableColumn)i2.next();
            columnDTOs.add(etc.getColumnDTO(requestContext, this.headerFont, this.cellFont));
        }
        ArrayList<ExpertDisplayInfoDTO.TableDTO.RowDTO> rowDTOs = new ArrayList<ExpertDisplayInfoDTO.TableDTO.RowDTO>();
        String dmk = ExpertDisplayUtil.getModelItemKey(this.logicModelItem, requestContext.getFormAccessKey());
        ModelItemDTO table_miDTO = requestContext.getDataModel().get(dmk);
        Set set = unsortedRowIndices = table_miDTO != null && table_miDTO.getValue() != null ? (Set)table_miDTO.getValue() : null;
        if (unsortedRowIndices != null && unsortedRowIndices.size() > 0) {
            ArrayList rowIndices = new ArrayList(unsortedRowIndices);
            Collections.sort(rowIndices, tableRowSorter);
            Iterator i3 = rowIndices.iterator();
            while (i3.hasNext()) {
                String rowIndex = i3.next().toString();
                ModelItemDTO row_miDTO = requestContext.getDataModel().get(dmk + "." + rowIndex);
                if (row_miDTO == null) continue;
                ArrayList<ExpertDisplayInfoDTO.TableDTO.CellDTO> cellDTOs = new ArrayList<ExpertDisplayInfoDTO.TableDTO.CellDTO>();
                String rowFormAccessKey = this.buildRowFormAccessKey(requestContext, rowIndex);
                Iterator j = this.columns.iterator();
                while (j.hasNext()) {
                    ExpertTableColumn etc = (ExpertTableColumn)j.next();
                    cellDTOs.add(etc.getCellDTO(requestContext, rowFormAccessKey, this.cellFont));
                }
                boolean printRow = this.isPrintRow(requestContext, rowFormAccessKey);
                String tableRowDmk = dmk + "." + rowIndex;
                rowDTOs.add(new ExpertDisplayInfoDTO.TableDTO.RowDTO(row_miDTO.getState(), cellDTOs, tableRowDmk, printRow, true, this.getUniqueItemIdentifier() + tableRowDmk, false));
            }
        }
        if (table_miDTO != null && table_miDTO.getState() != 12 && (parentState = ExpertDisplayUtil.getDisabledOrTransparentParentState(this.logicModelItem, requestContext.getDataModel(), dmk)) != null && ((i = parentState.intValue()) == 12 || i == 11)) {
            table_miDTO = table_miDTO.clone(i);
        }
        if (!(ro = this.expertReadonlyHelper.evaluateReadonlyMode(this.readonly, this.readonlyIfTransparent, this.logicModelItem, table_miDTO, dmk, requestContext.getDataModel()))) {
            int newRowIndex = EngineUtil.getNextTableItemIndex(requestContext.dataModel, (LogicModelItem.TableItem)((Object)this.logicModelItem), dmk);
            boolean writeOnView = requestContext.getDataModel().getWriteOnView();
            requestContext.getDataModel().setWriteOnView(false);
            ArrayList<ExpertDisplayInfoDTO.TableDTO.CellDTO> cellDTOs = new ArrayList<ExpertDisplayInfoDTO.TableDTO.CellDTO>();
            String rowFormAccessKey = this.buildRowFormAccessKey(requestContext, "" + newRowIndex);
            rowDTOs.add(new ExpertDisplayInfoDTO.TableDTO.RowDTO(3, cellDTOs, "", false, true, this.getUniqueItemIdentifier() + rowFormAccessKey, true));
            Iterator j = this.columns.iterator();
            while (j.hasNext()) {
                ExpertTableColumn etc = (ExpertTableColumn)j.next();
                cellDTOs.add(etc.getCellDTO(requestContext, rowFormAccessKey, this.cellFont));
            }
            requestContext.getDataModel().setWriteOnView(writeOnView);
        }
        return new ExpertDisplayInfoDTO.TableDTO(this.x, this.y, this.width, this.height, this.headerHeight, this.formRows, this.titleFont != null ? this.titleFont : requestContext.getDefaultTableTitleFont(), this.titlePattern != null ? this.titlePattern : requestContext.getDefaultTableTitlePattern(), this.bgColor, columnDTOs, rowDTOs, table_miDTO != null ? table_miDTO.getState() : 3, ro, this.enhanced, this.getPrintMode(), this.rowHeight, this.colSpace, this.title, this.borderColor, this.extraPagesRowPadding, dmk, this.getUniqueItemIdentifier(), this.headerVisible, true, this.startRow, this.endRow);
    }

    private boolean isPrintRow(ExpertDisplayModel.RequestContext requestContext, String rowFormAccessKey) throws InvalidModelItemKeyException {
        boolean printRow = true;
        if (this.printRowStateItem != null) {
            String dmk = ExpertDisplayUtil.getModelItemKey(this.printRowStateItem, rowFormAccessKey);
            ModelItemDTO modelItem = requestContext.getDataModel().getWithoutTouch(dmk);
            if (modelItem != null) {
                printRow = modelItem.getState() != 12;
            }
        }
        return printRow;
    }

    private ExpertDisplayInfoDTO.ItemDTO getEnhancedItemDTO(ExpertDisplayModel.RequestContext requestContext) throws InvalidModelItemKeyException {
        boolean ro;
        int i;
        Integer parentState;
        String rowFormAccessKey;
        Set unsortedRowIndices;
        ArrayList<ExpertDisplayInfoDTO.TableDTO.RowDTO> rowDTOs = new ArrayList<ExpertDisplayInfoDTO.TableDTO.RowDTO>();
        String dmk = ExpertDisplayUtil.getModelItemKey(this.logicModelItem, requestContext.getFormAccessKey());
        ModelItemDTO table_miDTO = requestContext.getDataModel().get(dmk);
        Set set = unsortedRowIndices = table_miDTO != null && table_miDTO.getValue() != null ? (Set)table_miDTO.getValue() : null;
        if (unsortedRowIndices != null && unsortedRowIndices.size() > 0) {
            ArrayList rowIndices = new ArrayList(unsortedRowIndices);
            Collections.sort(rowIndices, tableRowSorter);
            Iterator i2 = rowIndices.iterator();
            while (i2.hasNext()) {
                String rowIndex = i2.next().toString();
                ModelItemDTO row_miDTO = requestContext.getDataModel().get(dmk + "." + rowIndex);
                rowFormAccessKey = this.buildRowFormAccessKey(requestContext, rowIndex);
                boolean printRow = this.isPrintRow(requestContext, rowFormAccessKey);
                if (row_miDTO == null || !printRow) continue;
                ArrayList<ExpertDisplayInfoDTO.ItemDTO> rowFormElementDTOs = new ArrayList<ExpertDisplayInfoDTO.ItemDTO>();
                String rowDmk = dmk + "." + rowIndex;
                rowDTOs.add(new ExpertDisplayInfoDTO.TableDTO.RowDTO(row_miDTO.getState(), rowFormElementDTOs, rowDmk, true, true, this.getUniqueItemIdentifier() + rowDmk, false));
                Iterator j = this.formElements.iterator();
                while (j.hasNext()) {
                    ExpertFormItem.FormElement fe = (ExpertFormItem.FormElement)j.next();
                    ExpertDisplayModel.RequestContext rowReqCtx = new ExpertDisplayModel.RequestContext(requestContext.getDataModel(), rowFormAccessKey, requestContext.getDefaultFont(), requestContext.getDefaultTableFont(), requestContext.getDefaultTableHeaderFont(), requestContext.getDefaultTableTitleFont(), requestContext.getDefaultTableTitlePattern(), requestContext.getLogicModelItems());
                    if (!printRow) continue;
                    rowFormElementDTOs.add(fe.getItemDTO(rowReqCtx));
                }
            }
        }
        if (table_miDTO != null && table_miDTO.getState() != 12 && (parentState = ExpertDisplayUtil.getDisabledOrTransparentParentState(this.logicModelItem, requestContext.getDataModel(), dmk)) != null && ((i = parentState.intValue()) == 12 || i == 11)) {
            table_miDTO = table_miDTO.clone(i);
        }
        if (!(ro = this.expertReadonlyHelper.evaluateReadonlyMode(this.readonly, this.readonlyIfTransparent, this.logicModelItem, table_miDTO, dmk, requestContext.getDataModel()))) {
            int newRowIndex = EngineUtil.getNextTableItemIndex(requestContext.dataModel, (LogicModelItem.TableItem)((Object)this.logicModelItem), dmk);
            boolean writeOnView = requestContext.getDataModel().getWriteOnView();
            requestContext.getDataModel().setWriteOnView(false);
            ArrayList<ExpertDisplayInfoDTO.ItemDTO> rowFormElementDTOs = new ArrayList<ExpertDisplayInfoDTO.ItemDTO>();
            rowFormAccessKey = this.buildRowFormAccessKey(requestContext, "" + newRowIndex);
            rowDTOs.add(new ExpertDisplayInfoDTO.TableDTO.RowDTO(3, rowFormElementDTOs, "", false, true, this.getUniqueItemIdentifier() + dmk + "." + newRowIndex, true));
            Iterator j = this.formElements.iterator();
            while (j.hasNext()) {
                ExpertFormItem.FormElement fe = (ExpertFormItem.FormElement)j.next();
                ExpertDisplayModel.RequestContext rowReqCtx = new ExpertDisplayModel.RequestContext(requestContext.getDataModel(), rowFormAccessKey, requestContext.getDefaultFont(), requestContext.getDefaultTableFont(), requestContext.getDefaultTableHeaderFont(), requestContext.getDefaultTableTitleFont(), requestContext.getDefaultTableTitlePattern(), requestContext.getLogicModelItems());
                rowFormElementDTOs.add(fe.getItemDTO(rowReqCtx));
            }
            requestContext.getDataModel().setWriteOnView(writeOnView);
        }
        return new ExpertDisplayInfoDTO.TableDTO(this.x, this.y, this.width, this.height, this.headerHeight, this.formRows, this.titleFont != null ? this.titleFont : requestContext.getDefaultTableTitleFont(), this.titlePattern != null ? this.titlePattern : requestContext.getDefaultTableTitlePattern(), this.bgColor, null, rowDTOs, table_miDTO != null ? table_miDTO.getState() : 3, ro, this.enhanced, this.getPrintMode(), this.rowHeight, this.colSpace, this.title, this.borderColor, this.extraPagesRowPadding, dmk, this.getUniqueItemIdentifier(), this.headerVisible, true, this.startRow, this.endRow);
    }

    private ExpertDisplayInfoDTO.ItemDTO getDummyTableItemDTO(ExpertDisplayModel.RequestContext requestContext) throws InvalidModelItemKeyException {
        if (!this.enhanced) {
            throw new RuntimeException("dummy for non-encanced table is not yet implemented");
        }
        ArrayList<ExpertDisplayInfoDTO.ItemDTO> rowFormElementDTOs = new ArrayList<ExpertDisplayInfoDTO.ItemDTO>();
        ArrayList<ExpertDisplayInfoDTO.TableDTO.RowDTO> rowDTOs = new ArrayList<ExpertDisplayInfoDTO.TableDTO.RowDTO>();
        if (this.isPrintRow(requestContext, requestContext.getFormAccessKey())) {
            rowDTOs.add(new ExpertDisplayInfoDTO.TableDTO.RowDTO(1, rowFormElementDTOs, null, true, true, null, false));
            Iterator j = this.formElements.iterator();
            while (j.hasNext()) {
                ExpertFormItem.FormElement fe = (ExpertFormItem.FormElement)j.next();
                rowFormElementDTOs.add(fe.getItemDTO(requestContext));
            }
        }
        return new ExpertDisplayInfoDTO.TableDTO(this.x, this.y, this.width, this.height, this.headerHeight, this.formRows, this.titleFont != null ? this.titleFont : requestContext.getDefaultTableTitleFont(), this.titlePattern != null ? this.titlePattern : requestContext.getDefaultTableTitlePattern(), this.bgColor, null, rowDTOs, 1, this.readonly, this.enhanced, this.getPrintMode(), this.rowHeight, this.colSpace, this.title, this.borderColor, this.extraPagesRowPadding, null, this.getUniqueItemIdentifier(), this.headerVisible, true, 0, Integer.MAX_VALUE);
    }

    private String buildRowFormAccessKey(ExpertDisplayModel.RequestContext requestContext, String rowIndex) {
        String result = requestContext.getFormAccessKey();
        result = result.indexOf("#") < 0 ? result + "#" + rowIndex : (result.endsWith("#") || result.endsWith(".") ? result + rowIndex : result + "." + rowIndex);
        return result;
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<Object> tableColumns = null;
            ExpertDisplayInfoDTO.FontDTO font = null;
            ExpertDisplayInfoDTO.FontDTO titleFont = null;
            ExpertDisplayInfoDTO.FontDTO headerFont = null;
            ExpertDisplayInfoDTO.PatternDTO titlePattern = null;
            ArrayList<Object> formElements = null;
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                Element subElement = (Element)i.next();
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof ExpertTableColumn) {
                        if (tableColumns == null) {
                            tableColumns = new ArrayList<Object>();
                        }
                        tableColumns.add(ref);
                        continue;
                    }
                    if (ref instanceof ExpertDisplayInfoDTO.FontDTO) {
                        if (subElementName.equals("e-table-title-font")) {
                            titleFont = (ExpertDisplayInfoDTO.FontDTO)ref;
                            continue;
                        }
                        if (subElementName.equals("e-table-header-font")) {
                            headerFont = (ExpertDisplayInfoDTO.FontDTO)ref;
                            continue;
                        }
                        font = (ExpertDisplayInfoDTO.FontDTO)ref;
                        continue;
                    }
                    if (ref instanceof ExpertDisplayInfoDTO.PatternDTO) {
                        titlePattern = (ExpertDisplayInfoDTO.PatternDTO)ref;
                        continue;
                    }
                    if (ref instanceof ExpertFormItem.FormElement) {
                        if (formElements == null) {
                            formElements = new ArrayList<Object>();
                        }
                        formElements.add(ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), pnre);
                }
            }
            Boolean readonly = null;
            if (element.getAttribute("readonly") != null) {
                readonly = Boolean.valueOf(element.getAttributeValue("readonly"));
            }
            Boolean readonlyIfTransparent = null;
            if (element.getAttribute("readonly-if-transparent") != null) {
                readonlyIfTransparent = Boolean.valueOf(element.getAttributeValue("readonly-if-transparent"));
            }
            ExpertTableItem eti = new ExpertTableItem(ExpertDisplayUtil.toPixel(element.getAttributeValue("x")), ExpertDisplayUtil.toPixel(element.getAttributeValue("y")), ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.toPixel(element.getAttributeValue("height")), ExpertDisplayUtil.toPixel(element.getAttributeValue("headerHeight")), new Integer(element.getAttributeValue("rows")), font, titleFont, headerFont, titlePattern, ExpertDisplayUtil.parseColor(element.getAttributeValue("bgColor")), element.getAttributeValue("value"), readonly, tableColumns, formElements, ExpertDisplayUtil.parseOutputMode(element.getAttributeValue("printItem")), ExpertDisplayUtil.getBoolean(element.getAttributeValue("inputItem"), true), ExpertDisplayUtil.toPixelFloat(element.getAttributeValue("rowHeight")), element.getAttributeValue("title"), ExpertDisplayUtil.toPixelFloat(element.getAttributeValue("colSpace")), ExpertDisplayUtil.parseLanguages(element.getAttributeValue("lang")), element.getAttributeValue("printRowState"), ExpertDisplayUtil.parseColor(element.getAttributeValue("borderColor"), BLACK), ExpertDisplayUtil.toPixelFloat(element.getAttributeValue("extraPagesRowPadding")), readonlyIfTransparent, ExpertDisplayUtil.getBoolean(element.getAttributeValue("headerVisible"), true), ExpertDisplayUtil.getInt(element.getAttributeValue("startRow"), 0), ExpertDisplayUtil.getInt(element.getAttributeValue("endRow"), Integer.MAX_VALUE));
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$expertdisplay$ExpertFormItem$FormElement == null ? (class$ch$dvbern$tax$common$engine$expertdisplay$ExpertFormItem$FormElement = ExpertTableItem.class$("ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem$FormElement")) : class$ch$dvbern$tax$common$engine$expertdisplay$ExpertFormItem$FormElement, eti);
        }
    }
}

