/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.modelitems.Bool;
import ch.dvbern.tax.common.engine.modelitems.Calc;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.validators.Transparent;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ExpertReadonlyHelper {
    private LogicModelItem preSelectionItem;
    private LogicModelItem calcPreSelectionItem;
    private boolean calcPreSelectionItemExpr;

    public void init(Map logicModelItems, LogicModelItem logicModelItem) {
        if (logicModelItem == null) {
            return;
        }
        List validators = logicModelItem.getValidators();
        if (!logicModelItem.isReadonly() && validators != null) {
            Iterator i = validators.iterator();
            while (i.hasNext()) {
                CalcItem ci;
                Transparent t;
                Validator v = (Validator)i.next();
                if (!(v instanceof Transparent) || (t = (Transparent)v).getCalcItems().size() != 1 || !((ci = (CalcItem)t.getCalcItems().iterator().next()) instanceof Reference)) continue;
                LogicModelItem preSel = (LogicModelItem)logicModelItems.get(((Reference)((Object)ci)).getName());
                if (preSel instanceof Bool || preSel instanceof LogicModelItem.SelectItem) {
                    this.preSelectionItem = preSel;
                    continue;
                }
                if (!(preSel instanceof Calc)) continue;
                this.calcPreSelectionItem = preSel;
                this.calcPreSelectionItemExpr = t.getBooleanExpression();
            }
        }
    }

    public boolean evaluateReadonlyMode(boolean predefinedReadonlyFlag, boolean readonlyIfTransparent, LogicModelItem logicModelItem, ModelItemDTO miDTO, String dmk, ExpertDisplayModel.ProtectedMap dataModel) {
        String k;
        ModelItemDTO mi;
        boolean result = predefinedReadonlyFlag;
        if (readonlyIfTransparent && miDTO != null && miDTO.getState() == 11) {
            result = true;
        }
        if (!result && logicModelItem != null) {
            for (LogicModelItem lmi = logicModelItem.getParent(); lmi != null; lmi = lmi.getParent()) {
                String s;
                ModelItemDTO mi2;
                if (!lmi.isReadonlyIfTransparent() || (mi2 = dataModel.get(s = EngineUtil.mergeModelKey(lmi.getName(), dmk))) == null || mi2.getState() != 11) continue;
                result = true;
            }
        }
        if (!result && this.preSelectionItem != null && (mi = dataModel.get(k = EngineUtil.mergeModelKey(this.preSelectionItem.getName(), dmk))) != null && mi.getState() == 11) {
            result = true;
        }
        if (!result && this.calcPreSelectionItem != null && (mi = dataModel.get(k = EngineUtil.mergeModelKey(this.calcPreSelectionItem.getName(), dmk))) != null && mi.getValue() instanceof Boolean && this.calcPreSelectionItemExpr == (Boolean)mi.getValue()) {
            result = true;
        }
        return result;
    }
}

