/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertListIteratorItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertListRowItem;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.InvalidModelItemKeyException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExpertListItem
extends ExpertDisplayModelItem
implements ExpertFormItem.FormElement {
    private int x;
    private int y;
    private int width;
    private int height;
    private int rowHeight;
    private ExpertDisplayInfoDTO.FontDTO font;
    private ExpertDisplayInfoDTO.ColorDTO bgColor;
    private List rows;
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$expertdisplay$ExpertFormItem$FormElement;

    public ExpertListItem(int x, int y, int width, int height, int rowHeight, ExpertDisplayInfoDTO.FontDTO font, ExpertDisplayInfoDTO.ColorDTO bgColor, List rows, int printMode, Set languages) {
        super(languages, printMode, false);
        if (height < rowHeight) {
            height = Integer.MAX_VALUE;
        }
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.rowHeight = rowHeight;
        this.font = font;
        this.bgColor = bgColor;
        this.rows = rows;
    }

    public List getChildren() {
        return this.rows;
    }

    protected void additionalInitialization(Map logicModelItems, Map navigationItems) throws InvalidModelException {
        super.additionalInitialization(logicModelItems, navigationItems);
    }

    public ExpertDisplayInfoDTO.ItemDTO getItemDTO(ExpertDisplayModel.RequestContext requestContext) throws InvalidModelItemKeyException {
        ArrayList<ExpertDisplayInfoDTO.ListDTO.RowDTO> rowDTOs = new ArrayList<ExpertDisplayInfoDTO.ListDTO.RowDTO>();
        Iterator it = this.rows.iterator();
        while (it.hasNext()) {
            List l;
            Object item;
            ExpertDisplayInfoDTO.ListDTO.RowDTO rowDTO;
            Object listItem = it.next();
            if (listItem instanceof ExpertListRowItem && (rowDTO = (item = (ExpertListRowItem)listItem).getRowDTO(requestContext)) != null) {
                rowDTOs.add(rowDTO);
            }
            if (!(listItem instanceof ExpertListIteratorItem) || (l = ((ExpertListIteratorItem)(item = (ExpertListIteratorItem)listItem)).getRowDTOs(requestContext)) == null) continue;
            rowDTOs.addAll(l);
        }
        return new ExpertDisplayInfoDTO.ListDTO(this.x, this.y, this.width, this.height, this.rowHeight, this.font != null ? this.font : requestContext.getDefaultFont(), this.bgColor, rowDTOs, this.getPrintMode(), this.getUniqueItemIdentifier());
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<Object> rows = new ArrayList<Object>();
            ExpertDisplayInfoDTO.FontDTO font = null;
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                Element subElement = (Element)i.next();
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof ExpertListRowItem || ref instanceof ExpertListIteratorItem) {
                        rows.add(ref);
                        continue;
                    }
                    if (ref instanceof ExpertDisplayInfoDTO.FontDTO) {
                        font = (ExpertDisplayInfoDTO.FontDTO)ref;
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), pnre);
                }
            }
            ExpertListItem eli = new ExpertListItem(ExpertDisplayUtil.toPixel(element.getAttributeValue("x")), ExpertDisplayUtil.toPixel(element.getAttributeValue("y")), ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.toPixel(element.getAttributeValue("height")), ExpertDisplayUtil.toPixel(element.getAttributeValue("rowHeight")), font, ExpertDisplayUtil.parseColor(element.getAttributeValue("bgColor")), rows, ExpertDisplayUtil.parseOutputMode(element.getAttributeValue("printItem")), ExpertDisplayUtil.parseLanguages(element.getAttributeValue("lang")));
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$expertdisplay$ExpertFormItem$FormElement == null ? (class$ch$dvbern$tax$common$engine$expertdisplay$ExpertFormItem$FormElement = ExpertListItem.class$("ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem$FormElement")) : class$ch$dvbern$tax$common$engine$expertdisplay$ExpertFormItem$FormElement, eli);
        }
    }
}

