/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertNavigationItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.InvalidModelItemKeyException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ExpertFormItem
extends ExpertDisplayModelItem {
    private String name;
    private ExpertDisplayInfoDTO.PageSettingsDTO pageSettings;
    private ExpertDisplayInfoDTO.FontDTO defaultFont;
    private ExpertDisplayInfoDTO.FontDTO defaultTableFont;
    private ExpertDisplayInfoDTO.FontDTO defaultTableHeaderFont;
    private ExpertDisplayInfoDTO.FontDTO defaultTableTitleFont;
    private ExpertDisplayInfoDTO.PatternDTO defaultTableTitlePattern;
    private ExpertDisplayInfoDTO.ImageDTO guiBackground;
    private ExpertDisplayInfoDTO.ImageDTO printBackground;
    private ExpertDisplayInfoDTO.ImageDTO extraPagesBackground;
    private List formItems;
    private int valuePrintPaddingX;
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$expertdisplay$ExpertNavigationItem;

    public ExpertFormItem(String name, ExpertDisplayInfoDTO.PageSettingsDTO pageSettings, ExpertDisplayInfoDTO.FontDTO defaultFont, ExpertDisplayInfoDTO.FontDTO defaultTableFont, ExpertDisplayInfoDTO.FontDTO defaultTableHeaderFont, ExpertDisplayInfoDTO.FontDTO defaultTableTitleFont, ExpertDisplayInfoDTO.PatternDTO defaultTableTitlePattern, ExpertDisplayInfoDTO.ImageDTO guiBackground, ExpertDisplayInfoDTO.ImageDTO printBackground, List formItems, ExpertDisplayInfoDTO.ImageDTO extraPagesBackground, int valuePrintPaddingX) {
        super(null, 8, true);
        this.name = name;
        this.pageSettings = pageSettings;
        this.defaultFont = defaultFont;
        this.defaultTableFont = defaultTableFont == null ? defaultFont : defaultTableFont;
        this.defaultTableHeaderFont = defaultTableHeaderFont == null ? this.defaultTableFont : defaultTableHeaderFont;
        this.defaultTableTitleFont = defaultTableTitleFont == null ? this.defaultTableHeaderFont : defaultTableTitleFont;
        this.defaultTableTitlePattern = defaultTableTitlePattern;
        this.guiBackground = guiBackground;
        this.printBackground = printBackground;
        this.formItems = formItems;
        this.extraPagesBackground = extraPagesBackground;
        this.valuePrintPaddingX = valuePrintPaddingX;
    }

    public List getChildren() {
        return this.formItems;
    }

    protected void additionalInitialization(Map logicModelItems, Map navigationItems) throws InvalidModelException {
        super.additionalInitialization(logicModelItems, navigationItems);
        if (this.name == null || this.name.length() == 0) {
            throw new InvalidModelException("missing form item name in " + this.getClass().getName());
        }
        if (this.name.indexOf(46) != -1) {
            throw new InvalidModelException("invalid character (.) in expert form " + this.name);
        }
        if (this.name.indexOf(35) != -1) {
            throw new InvalidModelException("invalid character (#) in expert form " + this.name);
        }
        if (this.name.charAt(0) >= '0' && this.name.charAt(0) <= '9') {
            throw new InvalidModelException("invalid name (initial digit) in expert form " + this.name);
        }
        if (!navigationItems.containsKey(this.name)) {
            throw new InvalidModelException("missing navigation definition (" + this.name + ") in " + this.getClass().getName());
        }
        if (this.defaultFont == null && this.printBackground.getFileName() != null) {
            throw new InvalidModelException("missing default font definition (" + this.name + ") in " + this.getClass().getName());
        }
        if (this.formItems == null) {
            this.formItems = new ArrayList();
        }
    }

    public String getName() {
        return this.name;
    }

    public ExpertDisplayInfoDTO.FontDTO getDefaultFont() {
        return this.defaultFont;
    }

    public ExpertDisplayInfoDTO.FontDTO getDefaultTableFont() {
        return this.defaultTableFont;
    }

    public ExpertDisplayInfoDTO.FontDTO getDefaultTableHeaderFont() {
        return this.defaultTableHeaderFont;
    }

    public ExpertDisplayInfoDTO.FontDTO getDefaultTableTitleFont() {
        return this.defaultTableTitleFont;
    }

    public ExpertDisplayInfoDTO.PatternDTO getDefaultTableTitlePattern() {
        return this.defaultTableTitlePattern;
    }

    public ExpertDisplayInfoDTO getDTO(ExpertDisplayModel.RequestContext requestContext, List mainNavigationItems, Map allNavigationItems, Locale locale, int mode) throws InvalidModelItemKeyException {
        FastStack navigationPath = new FastStack();
        for (ExpertNavigationItem navItem = (ExpertNavigationItem)allNavigationItems.get(ExpertDisplayUtil.getFormKeyWithoutTableIndizes(requestContext.getFormAccessKey())); navItem != null; navItem = navItem.getParent()) {
            navigationPath.push(navItem);
        }
        ArrayList<ExpertDisplayInfoDTO.NavigationDTO> navigationItemDTOs = new ArrayList<ExpertDisplayInfoDTO.NavigationDTO>();
        Iterator i = mainNavigationItems.iterator();
        while (i.hasNext()) {
            ExpertNavigationItem eni = (ExpertNavigationItem)i.next();
            ExpertDisplayInfoDTO.NavigationDTO n = eni.getDTO(requestContext.getDataModel(), requestContext.getFormAccessKey(), new FastStack(), navigationPath, false);
            if (n == null) continue;
            navigationItemDTOs.add(n);
        }
        ArrayList<ExpertDisplayInfoDTO.ItemDTO> itemDTOs = new ArrayList<ExpertDisplayInfoDTO.ItemDTO>();
        Iterator i2 = this.formItems.iterator();
        while (i2.hasNext()) {
            ExpertDisplayInfoDTO.ItemDTO itemDTO;
            FormElement fe = (FormElement)i2.next();
            if (!fe.isEnabledForLanguage(locale) || !fe.isEnabledForMode(mode) || (itemDTO = fe.getItemDTO(requestContext)) == null) continue;
            itemDTOs.add(itemDTO);
        }
        return new ExpertDisplayInfoDTO(this.name, this.pageSettings, itemDTOs, this.guiBackground, this.printBackground, navigationItemDTOs, this.extraPagesBackground, this.getUniqueItemIdentifier() + requestContext.getFormAccessKey(), requestContext.getFormAccessKey(), this.valuePrintPaddingX);
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<Object> subItems = null;
            ExpertDisplayInfoDTO.FontDTO defaultFont = null;
            ExpertDisplayInfoDTO.FontDTO defaultTableFont = null;
            ExpertDisplayInfoDTO.FontDTO defaultTableHeaderFont = null;
            ExpertDisplayInfoDTO.FontDTO defaultTableTitleFont = null;
            ExpertDisplayInfoDTO.PatternDTO defaultTableTitlePattern = null;
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                Element subElement = (Element)i.next();
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof FormElement) {
                        if (subItems == null) {
                            subItems = new ArrayList<Object>();
                        }
                        subItems.add(ref);
                        continue;
                    }
                    if (ref instanceof ExpertDisplayInfoDTO.FontDTO) {
                        ExpertDisplayInfoDTO.FontDTO font = (ExpertDisplayInfoDTO.FontDTO)ref;
                        if (subElementName.equals("e-table-font")) {
                            defaultTableFont = font;
                            continue;
                        }
                        if (subElementName.equals("e-table-header-font")) {
                            defaultTableHeaderFont = font;
                            continue;
                        }
                        if (subElementName.equals("e-table-title-font")) {
                            defaultTableTitleFont = font;
                            continue;
                        }
                        defaultFont = font;
                        continue;
                    }
                    if (ref instanceof ExpertDisplayInfoDTO.PatternDTO) {
                        defaultTableTitlePattern = (ExpertDisplayInfoDTO.PatternDTO)ref;
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), pnre);
                }
            }
            ExpertDisplayInfoDTO.ImageDTO extraPagesBackground = null;
            if (element.getAttributeValue("extraPagesPdf") != null) {
                extraPagesBackground = new ExpertDisplayInfoDTO.ImageDTO(0, 0, ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.toPixel(element.getAttributeValue("height")), null, element.getAttributeValue("extraPagesPdf"), ExpertDisplayUtil.getInt(element.getAttributeValue("extraPagesPdfPage"), 0), 4, ExpertDisplayUtil.generateUniqueItemIdentifier());
            }
            ExpertFormItem efi = new ExpertFormItem(element.getAttributeValue("name"), new ExpertDisplayInfoDTO.PageSettingsDTO(ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.toPixel(element.getAttributeValue("height")), ExpertDisplayUtil.toPixel(element.getAttributeValue("marginTop")), ExpertDisplayUtil.toPixel(element.getAttributeValue("marginBottom")), ExpertDisplayUtil.toPixel(element.getAttributeValue("marginLeft")), ExpertDisplayUtil.toPixel(element.getAttributeValue("marginRight"))), defaultFont, defaultTableFont, defaultTableHeaderFont, defaultTableTitleFont, defaultTableTitlePattern, new ExpertDisplayInfoDTO.ImageDTO(0, 0, ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.toPixel(element.getAttributeValue("height")), null, element.getAttributeValue("image"), 0, 0, ExpertDisplayUtil.generateUniqueItemIdentifier()), new ExpertDisplayInfoDTO.ImageDTO(0, 0, ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.toPixel(element.getAttributeValue("height")), null, element.getAttributeValue("pdf"), ExpertDisplayUtil.getInt(element.getAttributeValue("pdfPage"), 0), 1, ExpertDisplayUtil.generateUniqueItemIdentifier()), subItems, extraPagesBackground, ExpertDisplayUtil.toPixel(element.getAttributeValue("valuePrintPaddingX")));
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$expertdisplay$ExpertNavigationItem == null ? (class$ch$dvbern$tax$common$engine$expertdisplay$ExpertNavigationItem = ExpertFormItem.class$("ch.dvbern.tax.common.engine.expertdisplay.ExpertNavigationItem")) : class$ch$dvbern$tax$common$engine$expertdisplay$ExpertNavigationItem, efi);
        }
    }

    public static interface FormElement {
        public ExpertDisplayInfoDTO.ItemDTO getItemDTO(ExpertDisplayModel.RequestContext var1) throws InvalidModelItemKeyException;

        public boolean isEnabledForLanguage(Locale var1);

        public boolean isEnabledForMode(int var1);
    }
}

