/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.dto.convert.BooleanConverter;
import ch.dvbern.tax.common.transfer.dto.convert.ComboboxConverter;
import ch.dvbern.tax.common.transfer.dto.convert.DateConverter;
import ch.dvbern.tax.common.transfer.dto.convert.DayMonthConverter;
import ch.dvbern.tax.common.transfer.dto.convert.FirstLetterConverter;
import ch.dvbern.tax.common.transfer.dto.convert.Float1Converter;
import ch.dvbern.tax.common.transfer.dto.convert.Float2Converter;
import ch.dvbern.tax.common.transfer.dto.convert.Float3Converter;
import ch.dvbern.tax.common.transfer.dto.convert.Float4Converter;
import ch.dvbern.tax.common.transfer.dto.convert.Float5Converter;
import ch.dvbern.tax.common.transfer.dto.convert.Float9Converter;
import ch.dvbern.tax.common.transfer.dto.convert.IntConverter;
import ch.dvbern.tax.common.transfer.dto.convert.IntSimpleConverter;
import ch.dvbern.tax.common.transfer.dto.convert.NumberConverter;
import ch.dvbern.tax.common.transfer.dto.convert.PrintZeroConverter;
import ch.dvbern.tax.common.transfer.dto.convert.RadioConverter;
import ch.dvbern.tax.common.transfer.dto.convert.TextConverter;
import ch.dvbern.tax.common.transfer.dto.convert.TextareaConverter;
import ch.dvbern.tax.common.transfer.failure.InvalidModelItemKeyException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class ExpertDisplayUtil {
    private static long uiid_incrementer = 0L;
    private static final OptionItemDTO BLANK_ITEM = new OptionItemDTO(null, "", "", false);
    private static final Map colors = new HashMap();

    public static void registerColor(String name, ExpertDisplayInfoDTO.ColorDTO color) {
        colors.put(name.toLowerCase(), color);
    }

    public static int toPixel(String mm) throws NumberFormatException {
        if (mm == null || mm.length() == 0) {
            return 0;
        }
        return ExpertDisplayUtil.toPixel(Float.parseFloat(mm));
    }

    public static float toPixelFloat(String mm) throws NumberFormatException {
        if (mm == null || mm.length() == 0) {
            return 0.0f;
        }
        return ExpertDisplayUtil.toPixelFloat(Float.parseFloat(mm));
    }

    public static int toPixel(float mm) throws NumberFormatException {
        return Math.round(ExpertDisplayUtil.toPixelFloat(mm));
    }

    public static float toPixelFloat(float mm) throws NumberFormatException {
        return mm / 25.4f * 72.0f;
    }

    public static ExpertDisplayInfoDTO.ColorDTO parseColor(String color, ExpertDisplayInfoDTO.ColorDTO def) {
        if (color == null || color.length() == 0) {
            return def;
        }
        ExpertDisplayInfoDTO.ColorDTO colorValue = null;
        if (color.startsWith("#")) {
            int r = Integer.parseInt(color.substring(1, 3), 16);
            int g = Integer.parseInt(color.substring(3, 5), 16);
            int b = Integer.parseInt(color.substring(5, 7), 16);
            colorValue = new ExpertDisplayInfoDTO.ColorDTO(r, g, b);
        } else {
            colorValue = (ExpertDisplayInfoDTO.ColorDTO)colors.get(color = color.toLowerCase());
            if (colorValue == null) {
                throw new RuntimeException("invalid color: '" + color + "'");
            }
        }
        return colorValue;
    }

    public static ExpertDisplayInfoDTO.ColorDTO parseColor(String color) {
        return ExpertDisplayUtil.parseColor(color, null);
    }

    public static int parseHAlignment(String alignment) {
        if (alignment == null || alignment.length() == 0) {
            return 0;
        }
        if ((alignment = alignment.toLowerCase()).equals("left")) {
            return 0;
        }
        if (alignment.equals("center")) {
            return 1;
        }
        if (alignment.equals("right")) {
            return 2;
        }
        throw new RuntimeException("invalid alignment: '" + alignment + "'");
    }

    public static int parseOutputMode(String mode) {
        return ExpertDisplayUtil.parseOutputMode(mode, 1);
    }

    public static int parseOutputMode(String mode, int def) {
        if (mode == null || mode.length() == 0) {
            return def;
        }
        if ((mode = mode.toLowerCase()).equals("false") || mode.equals("nopage")) {
            return 0;
        }
        if (mode.equals("firstpage")) {
            return 1;
        }
        if (mode.equals("lastpage")) {
            return 2;
        }
        if (mode.equals("extrapages")) {
            return 4;
        }
        if (mode.equals("allpages")) {
            return 8;
        }
        throw new RuntimeException("invalid output mode: '" + mode + "'");
    }

    public static TypeAndConverter parseInputType(Element element, AbstractConverter converter) throws ElementParserException {
        String inputType = element.getAttributeValue("type");
        TypeAndConverter result = new TypeAndConverter();
        if (inputType == null || inputType.length() == 0) {
            int maxlength = 100;
            if (element.getAttribute("maxlength") != null) {
                maxlength = Integer.parseInt(element.getAttributeValue("maxlength"));
            }
            result.type = 0;
            result.converter = converter != null ? converter : new TextConverter(maxlength);
            return result;
        }
        if ((inputType = inputType.toLowerCase()).equals("text")) {
            int maxlength = 100;
            if (element.getAttribute("maxlength") != null) {
                maxlength = Integer.parseInt(element.getAttributeValue("maxlength"));
            }
            result.type = 0;
            result.converter = converter != null ? converter : new TextConverter(maxlength);
        } else if (inputType.equals("textarea")) {
            int maxlength = 100;
            if (element.getAttribute("maxlength") != null) {
                maxlength = Integer.parseInt(element.getAttributeValue("maxlength"));
            }
            String style = "";
            if (element.getAttribute("style") != null) {
                style = element.getAttribute("style");
            }
            result.type = 4;
            result.converter = converter != null ? converter : new TextareaConverter(maxlength, style);
        } else if (inputType.equals("int")) {
            result.type = 0;
            boolean printZeroIfReadonly = Boolean.valueOf(element.getAttributeValue("printZeroIfReadonly"));
            result.converter = converter != null ? converter : new IntConverter(11, printZeroIfReadonly);
        } else if (inputType.equals("float-1")) {
            boolean dynamicFP = Boolean.valueOf(element.getAttributeValue("dynamicFP"));
            result.type = 0;
            result.converter = converter != null ? converter : new Float1Converter(14, dynamicFP);
        } else if (inputType.equals("float-2")) {
            boolean dynamicFP = Boolean.valueOf(element.getAttributeValue("dynamicFP"));
            result.type = 0;
            result.converter = converter != null ? converter : new Float2Converter(14, dynamicFP);
        } else if (inputType.equals("float-3")) {
            boolean dynamicFP = Boolean.valueOf(element.getAttributeValue("dynamicFP"));
            result.type = 0;
            result.converter = converter != null ? converter : new Float3Converter(15, dynamicFP);
        } else if (inputType.equals("float-4")) {
            boolean dynamicFP = Boolean.valueOf(element.getAttributeValue("dynamicFP"));
            result.type = 0;
            result.converter = converter != null ? converter : new Float4Converter(16, dynamicFP);
        } else if (inputType.equals("float-5")) {
            boolean dynamicFP = Boolean.valueOf(element.getAttributeValue("dynamicFP"));
            result.type = 0;
            result.converter = converter != null ? converter : new Float5Converter(17, dynamicFP);
        } else if (inputType.equals("float-9")) {
            boolean dynamicFP = Boolean.valueOf(element.getAttributeValue("dynamicFP"));
            result.type = 0;
            result.converter = converter != null ? converter : new Float9Converter(21, dynamicFP);
        } else if (inputType.equals("date")) {
            result.type = 0;
            result.converter = converter != null ? converter : new DateConverter();
        } else if (inputType.equals("boolean")) {
            result.type = 3;
            result.converter = converter != null ? converter : new BooleanConverter();
        } else if (inputType.equals("radio")) {
            result.type = 1;
            result.converter = converter != null ? converter : new RadioConverter();
        } else if (inputType.equals("combobox")) {
            result.type = 2;
            result.converter = converter != null ? converter : new ComboboxConverter(false);
        } else if (inputType.equals("combobox-short")) {
            result.type = 2;
            result.converter = converter != null ? converter : new ComboboxConverter(true);
        } else if (inputType.equals("int-simple")) {
            result.type = 0;
            result.converter = converter != null ? converter : new IntSimpleConverter(11);
        } else if (inputType.equals("day-month")) {
            String s = element.getAttributeValue("year");
            try {
                Long year = new Long(s);
                result.type = 0;
                result.converter = converter != null ? converter : new DayMonthConverter(year);
            }
            catch (Throwable t) {
                throw new ElementParserException("missing or invalid year reference for day-month input type in " + element.getName(), t);
            }
        } else if (inputType.equals("first-letter")) {
            result.type = 0;
            String s = element.getAttributeValue("chars");
            int chars = 1;
            if (s != null && s.length() > 0) {
                chars = Integer.parseInt(s);
            }
            result.converter = converter != null ? converter : new FirstLetterConverter(chars);
        } else {
            throw new RuntimeException("invalid alignment: '" + inputType + "'");
        }
        if ("true".equalsIgnoreCase(element.getAttributeValue("printZero"))) {
            PrintZeroConverter printZeroConverter = new PrintZeroConverter((NumberConverter)result.converter, true);
            result.converter = printZeroConverter;
        } else if ("false".equalsIgnoreCase(element.getAttributeValue("printZero"))) {
            PrintZeroConverter printZeroConverter = new PrintZeroConverter((NumberConverter)result.converter, false);
            result.converter = printZeroConverter;
        }
        return result;
    }

    public static int getShapeCount(String s) {
        int result = 0;
        int i = s.indexOf("#");
        while (i >= 0) {
            ++result;
            i = s.indexOf("#", i + 1);
        }
        return result;
    }

    public static String getModelItemKey(LogicModelItem lmi, String formKey) throws InvalidModelItemKeyException {
        StringBuffer result = new StringBuffer(lmi.getNameWithTableIndexShapes());
        int i = result.indexOf("#");
        StringTokenizer st = null;
        if (i >= 0) {
            int sharpPos = formKey.indexOf("#");
            if (sharpPos < 0) {
                throw new InvalidModelItemKeyException("insufficient table indices in formKey");
            }
            st = new StringTokenizer(formKey.substring(sharpPos + 1), ".");
        }
        if (st != null) {
            while (i >= 0) {
                if (!st.hasMoreTokens()) {
                    throw new InvalidModelItemKeyException("insufficient table indices in formKey. formKey=" + formKey);
                }
                result.replace(i, i + 1, st.nextToken());
                i = result.indexOf("#");
            }
        }
        return result.toString();
    }

    public static String getFormKeyWithoutTableIndizes(String formKey) {
        int i = formKey.indexOf("#");
        if (i >= 0) {
            return formKey.substring(0, i);
        }
        return formKey;
    }

    public static boolean isTableEntrySelected(int hierarchyLevel, Object currentTableEntryIndex, String formAccessKey) {
        String indices;
        StringTokenizer st;
        boolean result = false;
        int pos = formAccessKey.indexOf("#");
        if (pos >= 0 && hierarchyLevel < (st = new StringTokenizer(indices = formAccessKey.substring(pos + 1), ".")).countTokens()) {
            for (int i = 0; i < hierarchyLevel; ++i) {
                st.nextToken();
            }
            result = currentTableEntryIndex.toString().equals(st.nextToken());
        }
        return result;
    }

    public static boolean getBoolean(String s, boolean defaultValue) {
        if (s == null || s.length() == 0) {
            return defaultValue;
        }
        return Boolean.valueOf(s);
    }

    public static int getInt(String s, int defaultValue) {
        if (s == null || s.length() == 0) {
            return defaultValue;
        }
        return Integer.parseInt(s);
    }

    public static float getFloat(String s, float defaultValue) {
        if (s == null || s.length() == 0) {
            return defaultValue;
        }
        return Float.parseFloat(s);
    }

    public static String getString(String s, String defaultValue) {
        if (s == null || s.length() == 0) {
            return defaultValue;
        }
        return s;
    }

    public static Set parseLanguages(String languages) {
        if (languages == null || languages.length() == 0) {
            return null;
        }
        HashSet<String> langSet = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(languages, ",");
        while (st.hasMoreTokens()) {
            langSet.add(st.nextToken().toLowerCase());
        }
        return langSet;
    }

    public static void handleBlankItem(OptionItemsDTO optionItems, boolean blankItem) {
        if (optionItems == null) {
            return;
        }
        Map options = optionItems.getOptionItems();
        if (optionItems.isLocalized()) {
            Iterator locales = options.entrySet().iterator();
            while (locales.hasNext()) {
                Map.Entry me = locales.next();
                if (!(me.getValue() instanceof Map)) continue;
                ExpertDisplayUtil.handleBlankItem((LinkedHashMap)me.getValue(), blankItem);
            }
        } else {
            ExpertDisplayUtil.handleBlankItem((LinkedHashMap)options, blankItem);
        }
    }

    private static void handleBlankItem(LinkedHashMap m, boolean blankItem) {
        if (m.containsKey(null)) {
            m.remove(null);
        }
        if (blankItem) {
            LinkedHashMap newMap = new LinkedHashMap();
            newMap.put(null, BLANK_ITEM);
            newMap.putAll(m);
            m.clear();
            m.putAll(newMap);
        }
    }

    public static Integer getDisabledOrTransparentParentState(LogicModelItem lmi, ExpertDisplayModel.ProtectedMap dataModel, String dmk) {
        LogicModelItem parentLMI = lmi.getParent();
        if (parentLMI != null) {
            String s = EngineUtil.mergeModelKey(parentLMI.getName(), dmk);
            ModelItemDTO miDTO = dataModel.get(s);
            if (miDTO != null) {
                if (miDTO.getState() == 12) {
                    return new Integer(12);
                }
                if (miDTO.getState() == 11) {
                    Integer parentState = ExpertDisplayUtil.getDisabledOrTransparentParentState(parentLMI, dataModel, dmk);
                    if (parentState != null && parentState == 12) {
                        return new Integer(12);
                    }
                    return new Integer(11);
                }
                return ExpertDisplayUtil.getDisabledOrTransparentParentState(parentLMI, dataModel, dmk);
            }
            return ExpertDisplayUtil.getDisabledOrTransparentParentState(parentLMI, dataModel, dmk);
        }
        return null;
    }

    public static String generateUniqueItemIdentifier() {
        return Long.toString(++uiid_incrementer);
    }

    static {
        colors.put("black", new ExpertDisplayInfoDTO.ColorDTO(0, 0, 0));
        colors.put("white", new ExpertDisplayInfoDTO.ColorDTO(255, 255, 255));
        colors.put("red", new ExpertDisplayInfoDTO.ColorDTO(255, 0, 0));
        colors.put("green", new ExpertDisplayInfoDTO.ColorDTO(0, 255, 0));
        colors.put("blue", new ExpertDisplayInfoDTO.ColorDTO(0, 0, 255));
        colors.put("orange", new ExpertDisplayInfoDTO.ColorDTO(255, 200, 0));
        colors.put("yellow", new ExpertDisplayInfoDTO.ColorDTO(255, 255, 0));
        colors.put("magenta", new ExpertDisplayInfoDTO.ColorDTO(255, 0, 255));
        colors.put("grey", new ExpertDisplayInfoDTO.ColorDTO(182, 182, 182));
    }

    public static class TypeAndConverter {
        public int type;
        public AbstractConverter converter;
    }
}

