/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class ExpertDisplayModelItem {
    private String uniqueItemIdentifier;
    private Set languages;
    private int printMode;
    private boolean inputItem;

    public ExpertDisplayModelItem(Set languages, int printMode, boolean inputItem) {
        this.languages = languages;
        this.printMode = printMode;
        this.inputItem = inputItem;
    }

    public abstract List getChildren();

    public final void initializeExpertDisplayModel(Map logicModelItems, Map navigationItems) throws InvalidModelException {
        this.uniqueItemIdentifier = ExpertDisplayUtil.generateUniqueItemIdentifier();
        this.additionalInitialization(logicModelItems, navigationItems);
        if (this.getChildren() != null) {
            Iterator i = this.getChildren().iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                if (!(obj instanceof ExpertDisplayModelItem)) continue;
                ((ExpertDisplayModelItem)obj).initializeExpertDisplayModel(logicModelItems, navigationItems);
            }
        }
    }

    protected void additionalInitialization(Map logicModelItems, Map navigationItems) throws InvalidModelException {
    }

    protected String getUniqueItemIdentifier() {
        return this.uniqueItemIdentifier;
    }

    public boolean isEnabledForLanguage(Locale locale) {
        if (this.languages == null || locale == null || locale.getLanguage() == null) {
            return true;
        }
        return this.languages.contains(locale.getLanguage());
    }

    public boolean isEnabledForMode(int mode) {
        if (mode == 1) {
            return this.inputItem;
        }
        return this.printMode != 0;
    }

    protected int getPrintMode() {
        return this.printMode;
    }

    protected boolean isInputItem() {
        return this.inputItem;
    }
}

