/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.failure.InvalidModelItemKeyException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Barcode1DItem
extends ExpertDisplayModelItem
implements ExpertFormItem.FormElement {
    private int x;
    private int y;
    private int width;
    private int height;
    private int barHeight;
    private int textSize;
    private int type;
    private float minBarWidth;
    private float relBarWidth;
    private String logicModelItemName;
    private LogicModelItem logicModelItem;
    private ExpertDisplayInfoDTO.ColorDTO bgColor;
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$expertdisplay$Barcode1DItem;

    public Barcode1DItem(int x, int y, int width, int height, ExpertDisplayInfoDTO.ColorDTO bgColor, int barHeight, float minBarWidth, float relBarWidth, int textSize, int type, String logicModelItemName, int printMode, Set languages) {
        super(languages, printMode, false);
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.bgColor = bgColor;
        this.barHeight = barHeight;
        this.minBarWidth = minBarWidth;
        this.relBarWidth = relBarWidth;
        this.textSize = textSize;
        this.type = type;
        this.logicModelItemName = logicModelItemName;
    }

    public List getChildren() {
        return Collections.EMPTY_LIST;
    }

    public ExpertDisplayInfoDTO.ItemDTO getItemDTO(ExpertDisplayModel.RequestContext requestContext) throws InvalidModelItemKeyException {
        String text = "";
        String dmk = ExpertDisplayUtil.getModelItemKey(this.logicModelItem, requestContext.getFormAccessKey());
        ModelItemDTO miDTO = requestContext.getDataModel().getWithoutTouch(dmk);
        Object value = miDTO.getValue();
        if (value != null) {
            text = value.toString();
        }
        return new ExpertDisplayInfoDTO.Barcode1DDTO(this.x, this.y, this.width, this.height, this.bgColor, this.barHeight, this.minBarWidth, this.relBarWidth, this.textSize, text, this.type, this.getPrintMode(), this.getUniqueItemIdentifier());
    }

    protected void additionalInitialization(Map logicModelItems, Map navigationItems) throws InvalidModelException {
        super.additionalInitialization(logicModelItems, navigationItems);
        this.logicModelItem = (LogicModelItem)logicModelItems.get(this.logicModelItemName);
        if (this.logicModelItem == null) {
            throw new InvalidModelException("invalid item reference (" + this.logicModelItemName + ") in " + this.getClass().getName());
        }
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            int type;
            float barHeigth = ExpertDisplayUtil.getFloat(element.getAttributeValue("barHeight"), -1.0f);
            String typeAttr = element.getAttributeValue("type");
            if (typeAttr == null || typeAttr.length() == 0) {
                type = 1;
            } else if ("code39".equalsIgnoreCase(typeAttr)) {
                type = 1;
            } else if ("code128".equalsIgnoreCase(typeAttr)) {
                type = 2;
            } else {
                throw new ElementParserException("invalid barcode type: " + typeAttr);
            }
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$expertdisplay$Barcode1DItem == null ? (class$ch$dvbern$tax$common$engine$expertdisplay$Barcode1DItem = Barcode1DItem.class$("ch.dvbern.tax.common.engine.expertdisplay.Barcode1DItem")) : class$ch$dvbern$tax$common$engine$expertdisplay$Barcode1DItem, new Barcode1DItem(ExpertDisplayUtil.toPixel(element.getAttributeValue("x")), ExpertDisplayUtil.toPixel(element.getAttributeValue("y")), ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.toPixel(element.getAttributeValue("height")), ExpertDisplayUtil.parseColor(element.getAttributeValue("bgColor")), (int)(barHeigth > 0.0f ? (float)ExpertDisplayUtil.toPixel(barHeigth) : barHeigth), ExpertDisplayUtil.getFloat(element.getAttributeValue("minBarWidth"), -1.0f), ExpertDisplayUtil.getFloat(element.getAttributeValue("relBarWidth"), -1.0f), ExpertDisplayUtil.getInt(element.getAttributeValue("textSize"), -1), type, element.getAttributeValue("value"), ExpertDisplayUtil.parseOutputMode(element.getAttributeValue("printItem")), ExpertDisplayUtil.parseLanguages(element.getAttributeValue("lang"))));
        }
    }
}

