/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.convert.AhvConverter;
import java.text.Collator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class CalculateAhvNumber
implements CalcItem {
    private static final String ERR_SEXE = "Le sexe est incorrect";
    private static final String ERR_DATENAISS = "La date de naissance est incoh\u00e9rente";
    private static final String ERR_NOM = "Le nom de famille n'est pas correct";
    private static final String[] CORRESPONDANCE_NOM_CODE = CalculateAhvNumber.getNameCode();
    private static final String voyelle = "AEIOUY";
    private static final String carAccentues = "\u00e1\u00e0\u00e2\u00e4\u00e3\u00e9\u00e8\u00ea\u00eb\u00ed\u00ec\u00ee\u00ef\u00f3\u00f2\u00f4\u00f6\u00f5\u00fa\u00f9\u00fb\u00fc\u00fd\u00ff\u00f1\u00e7".toUpperCase();
    private static final String carRemplacement = "aaaaaeeeeiiiiooooouuuuyync".toUpperCase();
    private static final SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
    public static final int SEXE_MASCULIN = 1;
    public static final int SEXE_FEMININ = 2;

    public void evaluate(LogicModelItem.ProtectedMap model, FastStack stack, String dataModelKey) {
        Object nomObj = stack.pop();
        Object dateNaissanceObj = stack.pop();
        Object sexeObj = stack.pop();
        String nom = null;
        Date dateNaissance = null;
        int sexe = 0;
        if (nomObj != null && nomObj instanceof String) {
            nom = nomObj.toString();
        }
        if (dateNaissanceObj != null && dateNaissanceObj instanceof Date) {
            dateNaissance = (Date)dateNaissanceObj;
        }
        if (sexeObj != null && sexeObj instanceof Long) {
            sexe = ((Long)sexeObj).intValue();
        }
        if (nom == null || dateNaissance == null || sexe == 0) {
            stack.push(null);
            return;
        }
        try {
            String ahv = this.generateAVSNumber(nom, dateNaissance, sexe);
            stack.push(ahv);
        }
        catch (IllegalArgumentException e) {
            stack.push(null);
        }
    }

    public String generateAVSNumber(String pFamilyName, Date pBirthDate, int pSexe) throws IllegalArgumentException {
        if (pSexe < 1 || pSexe > 2) {
            throw new IllegalArgumentException(ERR_SEXE);
        }
        if (pFamilyName == null || pFamilyName.length() == 0) {
            throw new IllegalArgumentException(ERR_NOM);
        }
        String familyNameMaj = pFamilyName.toUpperCase();
        familyNameMaj = this.elimineCarSpeciaux(familyNameMaj);
        String ahvWithoutChecksum = this.generateNameGroup(familyNameMaj) + this.generateBirthYearGroup(pBirthDate) + this.generateSexAndBirthDateGroup(pBirthDate, pSexe);
        String ahvWithChecksum = ahvWithoutChecksum + "000";
        AhvConverter converter = new AhvConverter();
        return converter.getRenderedValue(ahvWithChecksum, false, null, null);
    }

    public String generateAVSNumber(String pFamilyName, String pBirthDate, int pSexe) throws IllegalArgumentException {
        try {
            return this.generateAVSNumber(pFamilyName, sdf.parse(pBirthDate), pSexe);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private String elimineCarSpeciaux(String pString) {
        int pos = 0;
        pString = pString.toUpperCase();
        for (int i = 0; i < pString.length(); ++i) {
            pos = carAccentues.indexOf(pString.charAt(i));
            if (pos < 0) continue;
            pString = pString.replace(carAccentues.charAt(pos), carRemplacement.charAt(pos));
        }
        pString = this.remplaceChaine(pString, "AE", "A");
        pString = this.remplaceChaine(pString, "OE", "O");
        pString = this.remplaceChaine(pString, "UE", "U");
        return pString;
    }

    private int generateBirthYearGroup(Date pBirthDate) throws IllegalArgumentException {
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(pBirthDate);
            int year = cal.get(1);
            return year % 100;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(ERR_DATENAISS);
        }
    }

    private String generateNameGroup(String pFamilyName) throws IllegalArgumentException {
        int i;
        int rang = -1;
        Collator collator = Collator.getInstance(new Locale("CH", "de"));
        for (i = 0; i < CORRESPONDANCE_NOM_CODE.length; ++i) {
            int comparaison = collator.compare(CORRESPONDANCE_NOM_CODE[i], pFamilyName);
            if (comparaison == 0) {
                rang = i;
                break;
            }
            if (comparaison <= 0) continue;
            rang = i - 1;
            break;
        }
        if (i == CORRESPONDANCE_NOM_CODE.length) {
            rang = i - 1;
        }
        if (rang > -1) {
            if (rang <= 680 || rang >= 775) {
                return String.valueOf(rang + 100);
            }
            if (rang <= 730) {
                return String.valueOf(rang + 119);
            }
            if (rang <= 746) {
                return String.valueOf(rang + 50);
            }
            if (rang <= 771) {
                return String.valueOf(rang + 103);
            }
            if (rang <= 774) {
                return String.valueOf(rang + 25);
            }
        }
        throw new IllegalArgumentException(ERR_NOM);
    }

    private String generateSexAndBirthDateGroup(Date pBirthDate, int pSexe) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(pBirthDate);
        int mois = cal.get(2) + 1;
        int jour = cal.get(5);
        int base = 100;
        if (pSexe == 2) {
            base += 400;
        }
        return String.valueOf(base + 31 * (mois - 1) + jour + (mois - 1) / 3 * 7);
    }

    private String remplaceChaine(String pFromString, String pToReplace, String pWithString) {
        pFromString = pFromString.toUpperCase();
        int pos = pFromString.indexOf(pToReplace, 0);
        while (pos >= 0) {
            if (pos == 0 || voyelle.indexOf(pFromString.charAt(pos - 1)) < 0) {
                pFromString = pFromString.substring(0, pos) + pWithString + pFromString.substring(pos + 2);
            } else {
                ++pos;
            }
            pos = pFromString.indexOf(pToReplace, pos);
        }
        return pFromString;
    }

    private static String[] getNameCode() {
        return new String[]{"A", "ABI", "ABL", "AC", "AF", "AG", "AL", "ALD", "ALL", "ALM", "AM", "AMD", "AMM", "AMO", "AMS", "AN", "ANDO", "ANE", "ANN", "AO", "AR", "ARNO", "ARO", "AS", "AU", "B", "BACH", "BACHM", "BAD", "BAG", "BAL", "BALL", "BALM", "BALS", "BAM", "BAN", "BAR", "BARC", "BARM", "BART", "BAS", "BAT", "BAU", "BAUE", "BAUM", "BAUMB", "BAUMG", "BAUN", "BAV", "BAY", "BE", "BED", "BEF", "BEL", "BEN", "BER", "BERG", "BERH", "BERN", "BERNE", "BERO", "BERT", "BES", "BEU", "BF", "BI", "BIE", "BIER", "BIF", "BIL", "BIN", "BIO", "BIS", "BISE", "BIT", "BL", "BLAS", "BLAT", "BLE", "BLU", "BO", "BOD", "BOF", "BOH", "BOI", "BOL", "BOLL", "BOLLI", "BOLM", "BOM", "BON", "BOO", "BOR", "BORG", "BORN", "BOS", "BOSS", "BOSSH", "BOT", "BOV", "BR", "BRAG", "BRAN", "BRAP", "BRAU", "BRE", "BREG", "BREL", "BRES", "BRI", "BRO", "BROF", "BRON", "BRONN", "BROO", "BRU", "BRUD", "BRUG", "BRUH", "BRUL", "BRUN", "BRUND", "BRUNN", "BRUNO", "BRUO", "BU", "BUCH", "BUCHI", "BUCHO", "BUCI", "BUD", "BUH", "BUHLM", "BUHM", "BUI", "BUR", "BURG", "BURGI", "BURH", "BURK", "BURKH", "BURKI", "BURL", "BURR", "BURS", "BUS", "BUSS", "BUT", "BUTT", "BY", "C", "CAI", "CAM", "CAN", "CAR", "CAS", "CAST", "CAT", "CAV", "CE", "CH", "CHAR", "CHE", "CHI", "CHR", "CI", "CL", "CO", "COM", "COR", "CORN", "COS", "CR", "CRI", "CU", "D", "DAM", "DAS", "DE", "DEG", "DEL", "DEM", "DEP", "DES", "DET", "DI", "DIE", "DIG", "DO", "DOR", "DR", "DU", "DUB", "DUC", "DUD", "DUM", "DUP", "DUR", "DUS", "DUV", "E", "EBI", "EC", "EG", "EGGEN", "EGGER", "EGGF", "EGH", "EH", "EHRE", "EI", "EICHF", "EID", "EIN", "EK", "EM", "EN", "ENG", "ENI", "EO", "ER", "ERN", "ES", "ET", "EU", "F", "FAH", "FAI", "FAN", "FAR", "FAS", "FASS", "FAT", "FAV", "FAW", "FE", "FEL", "FELI", "FEM", "FET", "FI", "FIN", "FISCH", "FISD", "FIT", "FL", "FLE", "FLI", "FLU", "FLUD", "FO", "FON", "FOR", "FORR", "FOS", "FR", "FRAN", "FRAP", "FRE", "FREI", "FREK", "FREY", "FRI", "FRIE", "FRIF", "FRIS", "FRIT", "FRO", "FROI", "FRU", "FU", "FUD", "FUI", "FUR", "FUS", "G", "GAF", "GAL", "GAM", "GAN", "GAP", "GAS", "GASS", "GAT", "GAV", "GE", "GEH", "GEI", "GEL", "GEO", "GER", "GERD", "GES", "GF", "GI", "GIG", "GIL", "GIM", "GIR", "GIS", "GL", "GLE", "GM", "GO", "GOM", "GR", "GRAF", "GRAG", "GRE", "GRES", "GRI", "GRIM", "GRO", "GROS", "GROT", "GRU", "GRUP", "GS", "GU", "GUD", "GUG", "GUI", "GUN", "GUT", "GW", "H", "HAB", "HABI", "HAC", "HAD", "HAF", "HAFL", "HAFN", "HAG", "HAH", "HAL", "HALL", "HAM", "HAN", "HANN", "HAO", "HAR", "HART", "HAS", "HAT", "HAU", "HAUS", "HAUSF", "HAUT", "HAV", "HE", "HEE", "HEG", "HEI", "HEIN", "HEL", "HELF", "HELL", "HEM", "HEN", "HENG", "HENO", "HEO", "HER", "HERM", "HERR", "HERS", "HERZ", "HES", "HET", "HI", "HIM", "HIR", "HIRT", "HIS", "HO", "HOF", "HOFF", "HOFM", "HOFN", "HOG", "HOL", "HOM", "HOR", "HOT", "HU", "HUBF", "HUC", "HUG", "HUGI", "HUH", "HUN", "HUNI", "HUNZ", "HUO", "HUR", "HURN", "HUS", "HUT", "HUW", "I", "IM", "IN", "IS", "IT", "J", "JAD", "JAH", "JAN", "JAR", "JE", "JEC", "JEH", "JEN", "JEP", "JO", "JOL", "JOR", "JOS", "JOT", "JU", "JUF", "JUN", "JUNK", "JUO", "K", "KAH", "KAL", "KAM", "KAN", "KAR", "KAS", "KASP", "KAT", "KAU", "KE", "KEL", "KEM", "KES", "KET", "KI", "KIF", "KIM", "KIR", "KIS", "KL", "KLE", "KLI", "KN", "KNO", "KO", "KOC", "KOD", "KOH", "KOL", "KOLL", "KOM", "KOP", "KOR", "KOT", "KR", "KRAP", "KRE", "KRI", "KRU", "KU", "KUC", "KUH", "KUI", "KUN", "KUNZ", "KUNZI", "KUO", "KUR", "KUS", "L", "LAF", "LAN", "LANG", "LANH", "LAO", "LAT", "LAU", "LAUD", "LAV", "LE", "LED", "LEE", "LEH", "LEHN", "LEI", "LEIP", "LEK", "LEO", "LER", "LEU", "LEUE", "LEUF", "LEUT", "LEV", "LI", "LIE", "LIEC", "LIED", "LIF", "LIN", "LIND", "LINE", "LIO", "LIS", "LO", "LOF", "LOO", "LOR", "LOT", "LU", "LUD", "LUG", "LUI", "LUS", "LUT", "LUTH", "LUTI", "LUU", "LY", "M", "MAD", "MAG", "MAI", "MAK", "MAR", "MARG", "MART", "MARTIN", "MARU", "MAS", "MAT", "MATT", "MAU", "MAY", "ME", "MEIER", "MEIF", "MEK", "MER", "MES", "MET", "MEY", "MEYER", "MEYF", "MI", "MIC", "MID", "MIN", "MIR", "MO", "MOI", "MON", "MONN", "MONO", "MOO", "MOR", "MORE", "MORG", "MOS", "MOSE", "MOSI", "MOT", "MU", "MUH", "MUL", "MULL", "MUM", "MUR", "MUS", "N", "NAG", "NE", "NEG", "NEU", "NI", "NIE", "NIEDERG", "NIEF", "NIF", "NO", "NOT", "NU", "NY", "NYF", "O", "OBI", "OC", "OD", "OF", "OK", "OP", "OS", "OT", "OU", "P", "PAG", "PAN", "PAR", "PAT", "PE", "PEL", "PER", "PERRI", "PERS", "PES", "PET", "PEU", "PF", "PFI", "PH", "PI", "PIG", "PIR", "PL", "PO", "POR", "PR", "PU", "Q", "R", "RAM", "RAN", "RAS", "RAU", "RE", "REC", "REI", "REIN", "REK", "REN", "RENI", "REO", "REY", "RH", "RI", "RIC", "RID", "RIE", "RIEG", "RIF", "RIN", "RIO", "RIT", "RIV", "RO", "ROC", "ROD", "ROH", "ROHR", "ROI", "ROM", "ROO", "ROS", "ROSS", "ROT", "ROTH", "ROTHA", "ROTI", "ROU", "RU", "RUC", "RUD", "RUF", "RUG", "RUH", "RUP", "RUS", "RUT", "RY", "S", "SAL", "SAM", "SAR", "SAV", "SB", "SCH", "SCHAD", "SCHAF", "SCHAL", "SCHAR", "SCHARB", "SCHARL", "SCHAS", "SCHAU", "SCHAV", "SCHE", "SCHEL", "SCHEN", "SCHER", "SCHEU", "SCHI", "SCHIL", "SCHL", "SCHLE", "SCHLU", "SCHM", "SCHMID", "SCHMIDA", "SCHMIE", "SCHMO", "SCHN", "SCHNEI", "SCHNEK", "SCHNI", "SCHNY", "SCHO", "SCHON", "SCHOO", "SCHOR", "SCHR", "SCHU", "SCHUL", "SCHUM", "SCHUR", "SCHUS", "SCHW", "SCHWAB", "SCHWAC", "SCHWAR", "SCHWARZ", "SCHWE", "SCHWEI", "SCHWEIZ", "SCHWEK", "SCHWI", "SE", "SEI", "SEN", "SEO", "SF", "SI", "SIEG", "SIF", "SIM", "SK", "SO", "SOM", "SP", "SPI", "SPO", "SQ", "ST", "STAH", "STAL", "STAM", "STAU", "STE", "STEF", "STEI", "STEIN", "STEK", "STI", "STO", "STOD", "STOL", "STOO", "STR", "STRAU", "STRE", "STRI", "STRU", "STU", "STUC", "STUD", "STUF", "STUS", "SU", "SUT", "SV", "T", "TAN", "TAO", "TE", "TER", "TH", "THE", "THO", "THON", "THR", "TI", "TIR", "TO", "TOG", "TOR", "TR", "TRE", "TRI", "TRO", "TRU", "TS", "TSCHA", "TSCHE", "TSCHU", "TU", "U", "UF", "UL", "UM", "UR", "V", "VAL", "VAM", "VAR", "VAU", "VE", "VET", "VI", "VIL", "VIO", "VO", "VOG", "VOGT", "VOH", "VOL", "VON", "VONG", "VONO", "VOO", "VU", "W", "WAG", "WAH", "WAL", "WALD", "WALE", "WALL", "WALT", "WAM", "WAP", "WAS", "WAT", "WE", "WEC", "WEH", "WEI", "WEIF", "WEIS", "WEIT", "WEK", "WEN", "WER", "WERN", "WES", "WEU", "WI", "WID", "WIE", "WIEL", "WIF", "WIL", "WILE", "WIM", "WIP", "WIR", "WIS", "WIT", "WITT", "WO", "WOL", "WU", "WUI", "WUN", "WUR", "WUT", "WY", "WYM", "WYS", "WYSS", "WYT", "X", "Z", "ZAM", "ZAU", "ZB", "ZE", "ZEH", "ZEI", "ZEM", "ZF", "ZI", "ZIM", "ZIN", "ZK", "ZO", "ZU", "ZUC", "ZUL", "ZUM", "ZUN", "ZUR", "ZUS", "ZW", "ZWE", "ZY"};
    }
}

